/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumBean;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.hamcrest.CoreMatchers;
import io.hops.hadoop.shaded.org.hamcrest.MatcherAssert;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import org.junit.Test;

public class QuorumBeanTest {
    @Test
    public void testGetNameProperty() {
        QuorumPeer qpMock = Mockito.mock(QuorumPeer.class);
        Mockito.when(qpMock.getId()).thenReturn(1L);
        QuorumBean qb = new QuorumBean(qpMock);
        MatcherAssert.assertThat("getName property should return Bean name in the right format", qb.getName(), CoreMatchers.equalTo("ReplicatedServer_id1"));
    }

    @Test
    public void testIsHiddenProperty() {
        QuorumPeer qpMock = Mockito.mock(QuorumPeer.class);
        QuorumBean qb = new QuorumBean(qpMock);
        MatcherAssert.assertThat("isHidden should return false", qb.isHidden(), CoreMatchers.equalTo(false));
    }

    @Test
    public void testGetQuorumSizeProperty() {
        QuorumPeer qpMock = Mockito.mock(QuorumPeer.class);
        QuorumBean qb = new QuorumBean(qpMock);
        Mockito.when(qpMock.getQuorumSize()).thenReturn(5);
        MatcherAssert.assertThat("getQuorumSize property should return value of peet.getQuorumSize()", qb.getQuorumSize(), CoreMatchers.equalTo(5));
    }

    @Test
    public void testSslQuorumProperty() {
        QuorumPeer qpMock = Mockito.mock(QuorumPeer.class);
        QuorumBean qb = new QuorumBean(qpMock);
        Mockito.when(qpMock.isSslQuorum()).thenReturn(true);
        MatcherAssert.assertThat("isSslQuorum property should return value of peer.isSslQuorum()", qb.isSslQuorum(), CoreMatchers.equalTo(true));
        Mockito.when(qpMock.isSslQuorum()).thenReturn(false);
        MatcherAssert.assertThat("isSslQuorum property should return value of peer.isSslQuorum()", qb.isSslQuorum(), CoreMatchers.equalTo(false));
    }

    @Test
    public void testPortUnificationProperty() {
        QuorumPeer qpMock = Mockito.mock(QuorumPeer.class);
        QuorumBean qb = new QuorumBean(qpMock);
        Mockito.when(qpMock.shouldUsePortUnification()).thenReturn(true);
        MatcherAssert.assertThat("isPortUnification property should return value of peer.shouldUsePortUnification()", qb.isPortUnification(), CoreMatchers.equalTo(true));
        Mockito.when(qpMock.shouldUsePortUnification()).thenReturn(false);
        MatcherAssert.assertThat("isPortUnification property should return value of peer.shouldUsePortUnification()", qb.isPortUnification(), CoreMatchers.equalTo(false));
    }
}

