/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.PendingBlockDataAccess;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingBlockInfo;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;

class PendingReplicationBlocks {
    private static final Logger LOG = BlockManager.LOG;
    private static long timeout = 300000L;

    PendingReplicationBlocks(long timeoutPeriod) {
        if (timeoutPeriod > 0L) {
            timeout = timeoutPeriod;
        }
    }

    void start() {
    }

    void increment(BlockInfoContiguous block, DatanodeDescriptor[] targets) throws StorageException, TransactionContextException {
        PendingBlockInfo found = this.getPendingBlock(block);
        if (found == null) {
            this.addPendingBlockInfo(new PendingBlockInfo(block.getBlockId(), block.getInodeId(), Time.now(), targets));
        } else {
            found.incrementReplicas(targets);
            found.setTimeStamp(Time.now());
            this.updatePendingBlockInfo(found);
        }
    }

    void decrement(BlockInfoContiguous block, DatanodeDescriptor dn) throws StorageException, TransactionContextException {
        PendingBlockInfo found = this.getPendingBlock(block);
        if (found != null && !this.isTimedout(found)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing pending replication for " + (Object)((Object)block));
            }
            if (found.decrementReplicas(dn)) {
                this.removePendingBlockInfo(found, dn);
            }
        }
    }

    void remove(BlockInfoContiguous block) throws StorageException, TransactionContextException {
        PendingBlockInfo found = this.getPendingBlock(block);
        if (found != null) {
            this.removePendingBlockInfo(found);
        }
    }

    public void clear() throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.DEL_ALL_PENDING_REPL_BLKS){

            public Object performTask() throws StorageException, IOException {
                PendingBlockDataAccess da = (PendingBlockDataAccess)HdfsStorageFactory.getDataAccess(PendingBlockDataAccess.class);
                da.removeAll();
                return null;
            }
        }.handle();
    }

    int size() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.COUNT_ALL_VALID_PENDING_REPL_BLKS){

            public Object performTask() throws StorageException, IOException {
                PendingBlockDataAccess da = (PendingBlockDataAccess)HdfsStorageFactory.getDataAccess(PendingBlockDataAccess.class);
                return da.countValidPendingBlocks(PendingReplicationBlocks.getTimeLimit());
            }
        }.handle();
    }

    int getNumReplicas(BlockInfoContiguous block) throws StorageException, TransactionContextException {
        PendingBlockInfo found = this.getPendingBlock(block);
        if (found != null && !this.isTimedout(found)) {
            return found.getNumReplicas();
        }
        return 0;
    }

    long[] getTimedOutBlocks() throws IOException {
        List timedOutItems = (List)new LightWeightRequestHandler(HDFSOperationType.GET_TIMED_OUT_PENDING_BLKS){

            public Object performTask() throws StorageException, IOException {
                long timeLimit = PendingReplicationBlocks.getTimeLimit();
                PendingBlockDataAccess da = (PendingBlockDataAccess)HdfsStorageFactory.getDataAccess(PendingBlockDataAccess.class);
                List timedoutPendings = da.findByTimeLimitLessThan(timeLimit);
                if (timedoutPendings == null || timedoutPendings.size() <= 0) {
                    return null;
                }
                return timedoutPendings;
            }
        }.handle();
        if (timedOutItems == null) {
            return null;
        }
        Collection filterd = Collections2.filter((Collection)timedOutItems, (Predicate)new Predicate<PendingBlockInfo>(){

            public boolean apply(PendingBlockInfo t) {
                return t != null;
            }
        });
        long[] blockIdArr = new long[filterd.size()];
        int i = 0;
        for (PendingBlockInfo p : filterd) {
            blockIdArr[i] = p.getBlockId();
            ++i;
        }
        return blockIdArr;
    }

    void stop() {
    }

    private boolean isTimedout(PendingBlockInfo pendingBlock) {
        return PendingReplicationBlocks.getTimeLimit() > pendingBlock.getTimeStamp();
    }

    private static long getTimeLimit() {
        return Time.now() - timeout;
    }

    private PendingBlockInfo getPendingBlock(BlockInfoContiguous block) throws StorageException, TransactionContextException {
        return (PendingBlockInfo)EntityManager.find((FinderType)PendingBlockInfo.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{block.getBlockId(), block.getInodeId()});
    }

    private List<PendingBlockInfo> getAllPendingBlocks() throws StorageException, TransactionContextException {
        return (List)EntityManager.findList((FinderType)PendingBlockInfo.Finder.All, (Object[])new Object[0]);
    }

    private BlockInfoContiguous getBlockInfo(PendingBlockInfo pendingBlock) throws StorageException, TransactionContextException {
        return (BlockInfoContiguous)((Object)EntityManager.find((FinderType)BlockInfoContiguous.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{pendingBlock.getBlockId()}));
    }

    private void addPendingBlockInfo(PendingBlockInfo pbi) throws StorageException, TransactionContextException {
        EntityManager.add((Object)pbi);
    }

    private void updatePendingBlockInfo(PendingBlockInfo pbi) throws StorageException, TransactionContextException {
        EntityManager.update((Object)pbi);
    }

    private void removePendingBlockInfo(PendingBlockInfo pbi, DatanodeDescriptor dn) throws StorageException, TransactionContextException {
        PendingBlockInfo toRemove = new PendingBlockInfo(pbi.getBlockId(), pbi.getInodeId(), pbi.getTimeStamp(), dn.getDatanodeUuid());
        EntityManager.remove((Object)toRemove);
    }

    private void removePendingBlockInfo(PendingBlockInfo pbi) throws StorageException, TransactionContextException {
        EntityManager.remove((Object)pbi);
    }
}

