/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.common;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.FileKeyStoreLoader;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.FileKeyStoreLoaderBuilderProvider;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.JKSFileLoader;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.KeyStoreFileType;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.PEMFileLoader;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.PKCS12FileLoader;
import org.junit.Assert;
import org.junit.Test;

public class FileKeyStoreLoaderBuilderProviderTest
extends ZKTestCase {
    @Test
    public void testGetBuilderForJKSFileType() {
        FileKeyStoreLoader.Builder<? extends FileKeyStoreLoader> builder = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(KeyStoreFileType.JKS);
        Assert.assertTrue((boolean)(builder instanceof JKSFileLoader.Builder));
    }

    @Test
    public void testGetBuilderForPEMFileType() {
        FileKeyStoreLoader.Builder<? extends FileKeyStoreLoader> builder = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(KeyStoreFileType.PEM);
        Assert.assertTrue((boolean)(builder instanceof PEMFileLoader.Builder));
    }

    @Test
    public void testGetBuilderForPKCS12FileType() {
        FileKeyStoreLoader.Builder<? extends FileKeyStoreLoader> builder = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(KeyStoreFileType.PKCS12);
        Assert.assertTrue((boolean)(builder instanceof PKCS12FileLoader.Builder));
    }

    @Test(expected=NullPointerException.class)
    public void testGetBuilderForNullFileType() {
        FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(null);
    }
}

