/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.cli;

import io.hops.hadoop.shaded.org.apache.commons.cli.CommandLine;
import io.hops.hadoop.shaded.org.apache.commons.cli.Options;
import io.hops.hadoop.shaded.org.apache.commons.cli.ParseException;
import io.hops.hadoop.shaded.org.apache.commons.cli.PosixParser;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.StatsTrack;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliCommand;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliParseException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliWrapperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.MalformedPathException;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;

public class ListQuotaCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public ListQuotaCommand() {
        super("listquota", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        PosixParser parser = new PosixParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        String absolutePath = "/zookeeper/quota" + path + "/" + "zookeeper_limits";
        try {
            this.err.println("absolute path is " + absolutePath);
            Stat stat = new Stat();
            byte[] data = this.zk.getData(absolutePath, false, stat);
            StatsTrack st = new StatsTrack(new String(data));
            this.out.println("Output quota for " + path + " " + st.toString());
            data = this.zk.getData("/zookeeper/quota" + path + "/" + "zookeeper_stats", false, stat);
            this.out.println("Output stat for " + path + " " + new StatsTrack(new String(data)).toString());
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException.NoNodeException ne) {
            this.err.println("quota for " + path + " does not exist.");
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }
}

