/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.commons.collections.CollectionUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.MultipleAddresses;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;

public class MultipleAddressesTest {
    public static final int PORTS_AMOUNT = 10;

    @Test
    public void testIsEmpty() {
        MultipleAddresses multipleAddresses = new MultipleAddresses();
        Assert.assertTrue((boolean)multipleAddresses.isEmpty());
        multipleAddresses.addAddress(new InetSocketAddress(22));
        Assert.assertFalse((boolean)multipleAddresses.isEmpty());
    }

    @Test
    public void testGetAllAddresses() {
        List<InetSocketAddress> addresses = this.getAddressList();
        MultipleAddresses multipleAddresses = new MultipleAddresses(addresses);
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(addresses, multipleAddresses.getAllAddresses()));
        multipleAddresses.addAddress(addresses.get(1));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(addresses, multipleAddresses.getAllAddresses()));
    }

    @Test
    public void testGetAllHostStrings() {
        List<InetSocketAddress> addresses = this.getAddressList();
        List<String> hostStrings = this.getHostStrings(addresses);
        MultipleAddresses multipleAddresses = new MultipleAddresses(addresses);
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(hostStrings, multipleAddresses.getAllHostStrings()));
        multipleAddresses.addAddress(addresses.get(addresses.size() - 1));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(hostStrings, multipleAddresses.getAllHostStrings()));
    }

    @Test
    public void testGetAllPorts() {
        List<Integer> ports = this.getPortList();
        MultipleAddresses multipleAddresses = new MultipleAddresses(this.getAddressList(ports));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(ports, multipleAddresses.getAllPorts()));
        multipleAddresses.addAddress(new InetSocketAddress("localhost", (int)ports.get(ports.size() - 1)));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(ports, multipleAddresses.getAllPorts()));
    }

    @Test
    public void testGetWildcardAddresses() {
        List<Integer> ports = this.getPortList();
        List<InetSocketAddress> addresses = this.getAddressList(ports);
        MultipleAddresses multipleAddresses = new MultipleAddresses(addresses);
        List allAddresses = ports.stream().map(InetSocketAddress::new).collect(Collectors.toList());
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(allAddresses, multipleAddresses.getWildcardAddresses()));
        multipleAddresses.addAddress(new InetSocketAddress("localhost", (int)ports.get(ports.size() - 1)));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(allAddresses, multipleAddresses.getWildcardAddresses()));
    }

    @Test
    public void testGetValidAddress() throws NoRouteToHostException {
        List<InetSocketAddress> addresses = this.getAddressList();
        MultipleAddresses multipleAddresses = new MultipleAddresses(addresses);
        Assert.assertTrue((boolean)addresses.contains(multipleAddresses.getReachableAddress()));
    }

    @Test(expected=NoRouteToHostException.class)
    public void testGetValidAddressWithNotValid() throws NoRouteToHostException {
        MultipleAddresses multipleAddresses = new MultipleAddresses(new InetSocketAddress("203.0.113.1", 22));
        multipleAddresses.getReachableAddress();
    }

    @Test
    public void testGetReachableOrOneWithSingleReachableAddress() {
        InetSocketAddress reachableAddress = new InetSocketAddress("127.0.0.1", PortAssignment.unique());
        MultipleAddresses multipleAddresses = new MultipleAddresses(Collections.singletonList(reachableAddress));
        InetSocketAddress actualReturnedAddress = multipleAddresses.getReachableOrOne();
        Assert.assertEquals((Object)reachableAddress, (Object)actualReturnedAddress);
    }

    @Test
    public void testGetReachableOrOneWithSingleUnreachableAddress() {
        InetSocketAddress unreachableAddress = new InetSocketAddress("unreachable.address.zookeeper.apache.com", 1234);
        MultipleAddresses multipleAddresses = new MultipleAddresses(Collections.singletonList(unreachableAddress));
        InetSocketAddress actualReturnedAddress = multipleAddresses.getReachableOrOne();
        Assert.assertEquals((Object)unreachableAddress, (Object)actualReturnedAddress);
    }

    @Test
    public void testRecreateSocketAddresses() throws UnknownHostException {
        List searchedAddresses = Arrays.stream(InetAddress.getAllByName("google.com")).map(addr -> new InetSocketAddress((InetAddress)addr, 222)).collect(Collectors.toList());
        MultipleAddresses multipleAddresses = new MultipleAddresses((InetSocketAddress)searchedAddresses.get(searchedAddresses.size() - 1));
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(multipleAddresses.getAllAddresses());
        Assert.assertEquals((long)1L, (long)addresses.size());
        Assert.assertEquals(searchedAddresses.get(searchedAddresses.size() - 1), addresses.get(0));
        multipleAddresses.recreateSocketAddresses();
        addresses = new ArrayList<InetSocketAddress>(multipleAddresses.getAllAddresses());
        Assert.assertEquals((long)1L, (long)addresses.size());
        Assert.assertEquals(searchedAddresses.get(0), addresses.get(0));
    }

    @Test
    public void testRecreateSocketAddressesWithWrongAddresses() {
        InetSocketAddress address = new InetSocketAddress("locahost", 222);
        MultipleAddresses multipleAddresses = new MultipleAddresses(address);
        multipleAddresses.recreateSocketAddresses();
        Assert.assertEquals((Object)address, (Object)multipleAddresses.getOne());
    }

    @Test
    public void testAlwaysGetReachableAddress() throws Exception {
        InetSocketAddress reachableHost = new InetSocketAddress("127.0.0.1", 1234);
        InetSocketAddress unreachableHost1 = new InetSocketAddress("unreachable1.address.zookeeper.apache.com", 1234);
        InetSocketAddress unreachableHost2 = new InetSocketAddress("unreachable2.address.zookeeper.apache.com", 1234);
        InetSocketAddress unreachableHost3 = new InetSocketAddress("unreachable3.address.zookeeper.apache.com", 1234);
        MultipleAddresses multipleAddresses = new MultipleAddresses(Arrays.asList(unreachableHost1, unreachableHost2, unreachableHost3, reachableHost));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)reachableHost, (Object)multipleAddresses.getReachableAddress());
        }
    }

    @Test
    public void testGetAllReachableAddresses() throws Exception {
        InetSocketAddress reachableHost1 = new InetSocketAddress("127.0.0.1", 1234);
        InetSocketAddress reachableHost2 = new InetSocketAddress("127.0.0.1", 2345);
        InetSocketAddress unreachableHost1 = new InetSocketAddress("unreachable1.address.zookeeper.apache.com", 1234);
        InetSocketAddress unreachableHost2 = new InetSocketAddress("unreachable2.address.zookeeper.apache.com", 1234);
        MultipleAddresses multipleAddresses = new MultipleAddresses(Arrays.asList(unreachableHost1, unreachableHost2, reachableHost1, reachableHost2));
        HashSet<InetSocketAddress> reachableHosts = new HashSet<InetSocketAddress>(Arrays.asList(reachableHost1, reachableHost2));
        Assert.assertEquals(reachableHosts, multipleAddresses.getAllReachableAddresses());
    }

    @Test
    public void testGetAllReachableAddressesOrAllWhenSomeReachable() throws Exception {
        InetSocketAddress reachableHost1 = new InetSocketAddress("127.0.0.1", 1234);
        InetSocketAddress reachableHost2 = new InetSocketAddress("127.0.0.1", 2345);
        InetSocketAddress unreachableHost1 = new InetSocketAddress("unreachable1.address.zookeeper.apache.com", 1234);
        InetSocketAddress unreachableHost2 = new InetSocketAddress("unreachable2.address.zookeeper.apache.com", 1234);
        MultipleAddresses multipleAddresses = new MultipleAddresses(Arrays.asList(unreachableHost1, unreachableHost2, reachableHost1, reachableHost2));
        HashSet<InetSocketAddress> reachableHosts = new HashSet<InetSocketAddress>(Arrays.asList(reachableHost1, reachableHost2));
        Assert.assertEquals(reachableHosts, multipleAddresses.getAllReachableAddressesOrAll());
    }

    @Test
    public void testGetAllReachableAddressesOrAllWhenNoneReachable() throws Exception {
        InetSocketAddress unreachableHost1 = new InetSocketAddress("unreachable1.address.zookeeper.apache.com", 1234);
        InetSocketAddress unreachableHost2 = new InetSocketAddress("unreachable2.address.zookeeper.apache.com", 1234);
        InetSocketAddress unreachableHost3 = new InetSocketAddress("unreachable3.address.zookeeper.apache.com", 1234);
        List<InetSocketAddress> allUnreachableAddresses = Arrays.asList(unreachableHost1, unreachableHost2, unreachableHost3);
        MultipleAddresses multipleAddresses = new MultipleAddresses(allUnreachableAddresses);
        Assert.assertEquals(new HashSet<InetSocketAddress>(allUnreachableAddresses), multipleAddresses.getAllReachableAddressesOrAll());
    }

    @Test
    public void testEquals() {
        List<InetSocketAddress> addresses = this.getAddressList();
        MultipleAddresses multipleAddresses = new MultipleAddresses(addresses);
        MultipleAddresses multipleAddressesEquals = new MultipleAddresses(addresses);
        Assert.assertEquals((Object)multipleAddresses, (Object)multipleAddressesEquals);
        MultipleAddresses multipleAddressesNotEquals = new MultipleAddresses(this.getAddressList());
        Assert.assertNotEquals((Object)multipleAddresses, (Object)multipleAddressesNotEquals);
    }

    @Test
    public void testSize() {
        List<InetSocketAddress> addresses = this.getAddressList();
        MultipleAddresses multipleAddresses = new MultipleAddresses(addresses);
        Assert.assertEquals((long)10L, (long)multipleAddresses.size());
    }

    public List<Integer> getPortList() {
        return IntStream.range(0, 10).mapToObj(i -> PortAssignment.unique()).collect(Collectors.toList());
    }

    public List<InetSocketAddress> getAddressList() {
        return this.getAddressList(this.getPortList());
    }

    public List<InetSocketAddress> getAddressList(List<Integer> ports) {
        return IntStream.range(0, ports.size()).mapToObj(i -> new InetSocketAddress("127.0.0." + i, (int)((Integer)ports.get(i)))).collect(Collectors.toList());
    }

    private List<String> getHostStrings(List<InetSocketAddress> addresses) {
        return IntStream.range(0, addresses.size()).mapToObj(i -> "127.0.0." + i).collect(Collectors.toList());
    }
}

