/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.security.GroupAlreadyExistsException;
import io.hops.security.UserAlreadyExistsException;
import io.hops.security.UsersGroups;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.AbstractFileTree;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.PathInformation;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.ipc.NotALeaderException;
import org.apache.hadoop.security.AccessControlException;

public class FSDirAttrOp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus setPermission(final FSDirectory fsd, String srcArg, final FsPermission permission) throws IOException {
        final FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(pc, srcArg, pathComponents);
        final INodeIdentifier inode = fsd.getFSNamesystem().lockSubtreeAndCheckOwnerAndParentPermission(src, true, null, SubTreeOperation.Type.SET_PERMISSION_STO);
        final boolean isSTO = inode != null;
        boolean txFailed = true;
        try {
            HdfsFileStatus ret = (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.SUBTREE_SETPERMISSION, src){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                    if (isSTO) {
                        il.setIgnoredSTOInodes(inode.getInodeId());
                        locks.add(lf.getSubTreeOpsLock(TransactionLockTypes.LockType.WRITE, fsd.getFSNamesystem().getSubTreeLockPathPrefix(src), false));
                    }
                    locks.add((Lock)il).add(lf.getBlockLock());
                    locks.add(lf.getAcesLock());
                    locks.add(lf.getEZLock());
                    locks.add(lf.getXAttrLock(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO));
                }

                public Object performTask() throws IOException {
                    INodesInPath iip = fsd.getINodesInPath4Write(src);
                    fsd.checkOwner(pc, iip);
                    FSDirAttrOp.unprotectedSetPermission(fsd, src, permission);
                    if (isSTO) {
                        INode inode2 = iip.getLastINode();
                        if (inode2 != null && inode2.isSTOLocked()) {
                            inode2.setSubtreeLocked(false);
                            EntityManager.update((Object)inode2);
                        }
                        SubTreeOperation subTreeOp = (SubTreeOperation)EntityManager.find((FinderType)SubTreeOperation.Finder.ByPath, (Object[])new Object[]{fsd.getFSNamesystem().getSubTreeLockPathPrefix(src)});
                        EntityManager.remove((Object)subTreeOp);
                    }
                    return fsd.getAuditFileInfo(iip);
                }
            }.handle();
            txFailed = false;
            HdfsFileStatus hdfsFileStatus = ret;
            return hdfsFileStatus;
        }
        finally {
            if (txFailed && inode != null) {
                fsd.getFSNamesystem().unlockSubtree(src, inode.getInodeId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus setOwner(final FSDirectory fsd, String srcArg, final String username, final String group) throws IOException {
        fsd.getFSNamesystem().saveTimes();
        final FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(pc, srcArg, pathComponents);
        boolean txFailed = true;
        final INodeIdentifier inode = fsd.getFSNamesystem().lockSubtreeAndCheckOwnerAndParentPermission(src, true, null, SubTreeOperation.Type.SET_OWNER_STO);
        final boolean isSTO = inode != null;
        try {
            HdfsFileStatus ret = (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.SET_OWNER_SUBTREE, src){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                    if (isSTO) {
                        il.setIgnoredSTOInodes(inode.getInodeId());
                        locks.add(lf.getSubTreeOpsLock(TransactionLockTypes.LockType.WRITE, fsd.getFSNamesystem().getSubTreeLockPathPrefix(src), false));
                    }
                    locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getAcesLock());
                    locks.add(lf.getEZLock());
                    locks.add(lf.getXAttrLock(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO));
                }

                public Object performTask() throws IOException {
                    INodesInPath iip = fsd.getINodesInPath4Write(src);
                    fsd.checkOwner(pc, iip);
                    if (!pc.isSuperUser()) {
                        if (username != null && !pc.getUser().equals(username)) {
                            throw new AccessControlException("Non-super user cannot change owner");
                        }
                        if (group != null && !pc.containsGroup(group)) {
                            throw new AccessControlException("User does not belong to " + group);
                        }
                    }
                    FSDirAttrOp.unprotectedSetOwner(fsd, src, username, group);
                    if (isSTO) {
                        INodesInPath inodesInPath = fsd.getINodesInPath(src, false);
                        INode inode2 = inodesInPath.getLastINode();
                        if (inode2 != null && inode2.isSTOLocked()) {
                            inode2.setSubtreeLocked(false);
                            EntityManager.update((Object)inode2);
                        }
                        SubTreeOperation subTreeOp = (SubTreeOperation)EntityManager.find((FinderType)SubTreeOperation.Finder.ByPath, (Object[])new Object[]{fsd.getFSNamesystem().getSubTreeLockPathPrefix(src)});
                        EntityManager.remove((Object)subTreeOp);
                    }
                    return fsd.getAuditFileInfo(iip);
                }
            }.handle();
            txFailed = false;
            HdfsFileStatus hdfsFileStatus = ret;
            return hdfsFileStatus;
        }
        finally {
            if (txFailed && inode != null) {
                fsd.getFSNamesystem().unlockSubtree(src, inode.getInodeId());
            }
        }
    }

    static HdfsFileStatus setTimes(final FSDirectory fsd, String srcArg, final long mtime, final long atime) throws IOException {
        if (!fsd.isAccessTimeSupported() && atime != -1L) {
            throw new IOException("Access time for hdfs is not configured.  Please set dfs.namenode.accesstime.precision configuration parameter.");
        }
        final FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(pc, srcArg, pathComponents);
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.SET_TIMES, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock());
                locks.add(lf.getAcesLock());
                locks.add(lf.getEZLock());
                locks.add(lf.getXAttrLock(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO));
            }

            public Object performTask() throws IOException {
                INode inode;
                INodesInPath iip = fsd.getINodesInPath4Write(src);
                if (fsd.isPermissionEnabled()) {
                    fsd.checkPathAccess(pc, iip, FsAction.WRITE);
                }
                if ((inode = iip.getLastINode()) == null) {
                    throw new FileNotFoundException("File/Directory " + src + " does not exist.");
                }
                boolean changed = FSDirAttrOp.unprotectedSetTimes(fsd, inode, mtime, atime, true);
                return fsd.getAuditFileInfo(iip);
            }
        }.handle();
    }

    static boolean setReplication(final FSDirectory fsd, final BlockManager bm, String srcArg, final short replication) throws IOException {
        bm.verifyReplication(srcArg, replication, null);
        final FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(pc, srcArg, pathComponents);
        HopsTransactionalRequestHandler setReplicationHandler = new HopsTransactionalRequestHandler(HDFSOperationType.SET_REPLICATION, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.IV)).add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                boolean isFile;
                INode lastInode;
                INodesInPath iip = fsd.getINodesInPath4Write(src);
                if (fsd.isPermissionEnabled()) {
                    fsd.checkPathAccess(pc, iip, FsAction.WRITE);
                }
                if ((lastInode = iip.getLastINode()).isFile() && lastInode.asFile().isFileStoredInDB()) {
                    INodeFile file = lastInode.asFile();
                    if (file.isFileStoredInDB()) {
                        file.setFileReplication(fsd.getFSNamesystem().getDBReplicationFactor());
                    }
                    return true;
                }
                short[] blockRepls = new short[2];
                BlockInfoContiguous[] blocks = FSDirAttrOp.unprotectedSetReplication(fsd, src, replication, blockRepls);
                boolean bl = isFile = blocks != null;
                if (isFile) {
                    bm.setReplication(blockRepls[0], blockRepls[1], src, blocks);
                }
                return isFile;
            }
        };
        return (Boolean)setReplicationHandler.handle();
    }

    static HdfsFileStatus setStoragePolicy(final FSDirectory fsd, final BlockManager bm, String srcArg, final String policyName) throws IOException {
        if (!fsd.isStoragePolicyEnabled()) {
            throw new IOException("Failed to set storage policy since dfs.storage.policy.enabled is set to false.");
        }
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = FSDirectory.resolvePath(srcArg, pathComponents, fsd);
        HopsTransactionalRequestHandler setStoragePolicyHandler = new HopsTransactionalRequestHandler(HDFSOperationType.SET_STORAGE_POLICY, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
                locks.add(lf.getEZLock());
                locks.add(lf.getXAttrLock(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO));
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                BlockStoragePolicy policy;
                FSPermissionChecker pc = fsd.getPermissionChecker();
                INodesInPath iip = fsd.getINodesInPath4Write(src);
                if (fsd.isPermissionEnabled()) {
                    fsd.checkPathAccess(pc, iip, FsAction.WRITE);
                }
                if ((policy = bm.getStoragePolicy(policyName)) == null) {
                    throw new HadoopIllegalArgumentException("Cannot find a block policy with the name " + policyName);
                }
                FSDirAttrOp.unprotectedSetStoragePolicy(fsd, bm, iip, policy.getId());
                return fsd.getAuditFileInfo(iip);
            }
        };
        return (HdfsFileStatus)setStoragePolicyHandler.handle();
    }

    static BlockStoragePolicy[] getStoragePolicies(BlockManager bm) throws IOException {
        return bm.getStoragePolicies();
    }

    static long getPreferredBlockSize(final FSDirectory fsd, String srcArg) throws IOException {
        final FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(pc, srcArg, pathComponents);
        HopsTransactionalRequestHandler getPreferredBlockSizeHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_PREFERRED_BLOCK_SIZE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                INodesInPath iip = fsd.getINodesInPath(src, false);
                if (fsd.isPermissionEnabled()) {
                    fsd.checkTraverse(pc, iip);
                }
                return INodeFile.valueOf(iip.getLastINode(), src).getPreferredBlockSize();
            }
        };
        return (Long)getPreferredBlockSizeHandler.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setQuota(final FSDirectory fsd, String srcArg, final long nsQuota, final long ssQuota, final StorageType type) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        if (fsd.isPermissionEnabled()) {
            pc.checkSuperuserPrivilege();
        }
        if (!fsd.getFSNamesystem().getNameNode().isLeader() && fsd.isQuotaEnabled()) {
            throw new NotALeaderException("Quota enabled. Delete operation can only be performed on a leader namenode");
        }
        INodeIdentifier subtreeRoot = null;
        boolean removeSTOLock = false;
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(pc, srcArg, pathComponents);
        try {
            Iterator<Long> idIterator;
            PathInformation pathInfo = fsd.getFSNamesystem().getPathExistingINodesFromDB(src, false, null, null, null, null);
            INode lastComp = pathInfo.getINodesInPath().getLastINode();
            if (lastComp == null) {
                throw new FileNotFoundException("Directory does not exist: " + src);
            }
            if (!lastComp.isDirectory()) {
                throw new FileNotFoundException(src + ": Is not a directory");
            }
            if (lastComp.isRoot() && nsQuota == -1L) {
                throw new IllegalArgumentException("Cannot clear namespace quota on root.");
            }
            if (INode.getPathNames(src).length == 0) {
                subtreeRoot = INodeDirectory.getRootIdentifier();
                subtreeRoot.setStoragePolicy((byte)0);
            } else {
                subtreeRoot = fsd.getFSNamesystem().lockSubtree(src, SubTreeOperation.Type.QUOTA_STO);
                if (subtreeRoot == null) {
                    throw new FileNotFoundException("Directory does not exist: " + src);
                }
                removeSTOLock = true;
            }
            final AbstractFileTree.IdCollectingCountingFileTree fileTree = new AbstractFileTree.IdCollectingCountingFileTree(fsd.getFSNamesystem(), subtreeRoot, subtreeRoot.getStoragePolicy());
            fileTree.buildUp(fsd.getBlockStoragePolicySuite());
            Iterator<Long> iterator = idIterator = fileTree.getOrderedIds().descendingIterator();
            synchronized (iterator) {
                fsd.getFSNamesystem().getQuotaUpdateManager().addPrioritizedUpdates(idIterator);
                try {
                    idIterator.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("Operation failed due to an Interrupt");
                }
            }
            HopsTransactionalRequestHandler setQuotaHandler = new HopsTransactionalRequestHandler(HDFSOperationType.SET_QUOTA, src){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).setIgnoredSTOInodes(fileTree.getSubtreeRootId().getInodeId()).setIgnoredSTOInodes(fileTree.getSubtreeRootId().getInodeId());
                    locks.add((Lock)il).add(lf.getBlockLock());
                }

                public Object performTask() throws IOException {
                    INodeDirectory changed = FSDirAttrOp.unprotectedSetQuota(fsd, src, nsQuota, ssQuota, fileTree.getUsedCounts(), type);
                    if (changed != null) {
                        QuotaCounts quotaCounts = changed.getQuotaCounts();
                    }
                    return null;
                }
            };
            setQuotaHandler.handle();
        }
        finally {
            if (removeSTOLock) {
                fsd.getFSNamesystem().unlockSubtree(src, subtreeRoot.getInodeId());
            }
        }
    }

    static void unprotectedSetPermission(FSDirectory fsd, String src, FsPermission permissions) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, StorageException, TransactionContextException {
        INodesInPath inodesInPath = fsd.getINodesInPath4Write(src, true);
        INode inode = inodesInPath.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        inode.setPermission(permissions);
    }

    static void unprotectedSetOwner(FSDirectory fsd, String src, String username, String groupname) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, IOException {
        INodesInPath inodesInPath = fsd.getINodesInPath4Write(src, true);
        INode inode = inodesInPath.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        if (username != null) {
            try {
                UsersGroups.addUser((String)username);
            }
            catch (UserAlreadyExistsException userAlreadyExistsException) {
                // empty catch block
            }
            inode.setUser(username);
            inode.setUserID(UsersGroups.getUserID((String)username));
        }
        if (groupname != null) {
            try {
                UsersGroups.addGroup((String)groupname);
            }
            catch (GroupAlreadyExistsException groupAlreadyExistsException) {
                // empty catch block
            }
            inode.setGroup(groupname);
            inode.setGroupID(UsersGroups.getGroupID((String)groupname));
        }
        inode.logMetadataEvent(INodeMetadataLogEntry.Operation.Update);
    }

    static boolean setTimes(FSDirectory fsd, INode inode, long mtime, long atime, boolean force) throws QuotaExceededException, TransactionContextException, StorageException {
        return FSDirAttrOp.unprotectedSetTimes(fsd, inode, mtime, atime, force);
    }

    static boolean unprotectedSetTimes(FSDirectory fsd, String src, long mtime, long atime, boolean force) throws UnresolvedLinkException, QuotaExceededException, TransactionContextException, StorageException {
        INodesInPath i = fsd.getINodesInPath(src, true);
        return FSDirAttrOp.unprotectedSetTimes(fsd, i.getLastINode(), mtime, atime, force);
    }

    static INodeDirectory unprotectedSetQuota(FSDirectory fsd, String src, long nsQuota, long ssQuota, QuotaCounts fileTreeUsage, StorageType type) throws FileNotFoundException, PathIsNotDirectoryException, QuotaExceededException, UnresolvedLinkException, UnsupportedActionException, StorageException, TransactionContextException {
        EnumCounters<StorageType> oldTypeQuotas;
        if (!fsd.isQuotaEnabled()) {
            return null;
        }
        if (nsQuota < 0L && nsQuota != Long.MAX_VALUE && nsQuota != -1L || ssQuota < 0L && ssQuota != Long.MAX_VALUE && ssQuota != -1L) {
            throw new IllegalArgumentException("Illegal value for nsQuota or ssQuota : " + nsQuota + " and " + ssQuota);
        }
        if (!(type == null || fsd.isQuotaByStorageTypeEnabled() && nsQuota == Long.MAX_VALUE)) {
            throw new UnsupportedActionException("Failed to set quota by storage type because eitherdfs.quota.by.storage.type.enabled is set to " + fsd.isQuotaByStorageTypeEnabled() + " or nsQuota value is illegal " + nsQuota);
        }
        String srcs = FSDirectory.normalizePath(src);
        INodesInPath iip = fsd.getINodesInPath4Write(srcs, true);
        INodeDirectory dirNode = INodeDirectory.valueOf(iip.getLastINode(), srcs);
        if (dirNode.isRoot() && nsQuota == -1L) {
            throw new IllegalArgumentException("Cannot clear namespace quota on root.");
        }
        QuotaCounts oldQuota = dirNode.getQuotaCounts();
        long oldNsQuota = oldQuota.getNameSpace();
        long oldSsQuota = oldQuota.getStorageSpace();
        if (nsQuota == Long.MAX_VALUE) {
            nsQuota = oldNsQuota;
        }
        if (ssQuota == Long.MAX_VALUE) {
            ssQuota = oldSsQuota;
        }
        if (type == null && oldNsQuota == nsQuota && oldSsQuota == ssQuota) {
            return null;
        }
        if (type != null && (oldTypeQuotas = oldQuota.getTypeSpaces()) != null && oldTypeQuotas.get(type) == ssQuota) {
            return null;
        }
        if (!dirNode.isRoot()) {
            dirNode.setQuota(fsd.getBlockStoragePolicySuite(), nsQuota, ssQuota, fileTreeUsage, type);
            INodeDirectory parent = (INodeDirectory)iip.getINode(-2);
            parent.replaceChild(dirNode);
        }
        return dirNode;
    }

    static BlockInfoContiguous[] unprotectedSetReplication(FSDirectory fsd, String src, short replication, short[] blockRepls) throws QuotaExceededException, UnresolvedLinkException, StorageException, TransactionContextException {
        INodesInPath iip = fsd.getINodesInPath4Write(src, true);
        INodeFile file = FSDirAttrOp.unprotectedSetReplicationWithoutGetBlocks(fsd, iip, replication, blockRepls);
        if (file == null) {
            return null;
        }
        return file.getBlocks();
    }

    static INodeFile unprotectedSetReplicationWithoutGetBlocks(FSDirectory fsd, INodesInPath iip, short replication, short[] blockRepls) throws TransactionContextException, StorageException, QuotaExceededException {
        INode inode = iip.getLastINode();
        if (inode == null || !inode.isFile()) {
            return null;
        }
        INodeFile file = inode.asFile();
        short oldBR = file.getBlockReplication();
        if (replication > oldBR) {
            long dsDelta = file.storagespaceConsumed() / (long)oldBR;
            fsd.updateCount(iip, 0L, dsDelta, oldBR, replication, true);
        }
        file.setFileReplication(replication);
        short newBR = file.getBlockReplication();
        if (newBR < oldBR) {
            long dsDelta = file.storagespaceConsumed() / (long)newBR;
            fsd.updateCount(iip, 0L, dsDelta, oldBR, newBR, true);
        }
        if (blockRepls != null) {
            blockRepls[0] = oldBR;
            blockRepls[1] = newBR;
        }
        return file;
    }

    static void unprotectedSetStoragePolicy(FSDirectory fsd, BlockManager bm, INodesInPath iip, byte policyId) throws IOException {
        INode inode = iip.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("File/Directory does not exist: " + iip.getPath());
        }
        if (inode.isFile()) {
            inode.asFile().setStoragePolicyID(policyId);
        } else if (inode.isDirectory()) {
            FSDirAttrOp.setDirStoragePolicy(fsd, inode.asDirectory(), policyId);
        } else {
            throw new FileNotFoundException(iip.getPath() + " is not a file or directory");
        }
    }

    private static void setDirStoragePolicy(FSDirectory fsd, INodeDirectory inode, byte policyId) throws IOException {
        inode.setStoragePolicyID(policyId);
    }

    private static boolean unprotectedSetTimes(FSDirectory fsd, INode inode, long mtime, long atime, boolean force) throws QuotaExceededException, TransactionContextException, StorageException {
        boolean status = false;
        if (mtime != -1L) {
            inode.setModificationTime(mtime);
            status = true;
        }
        if (atime != -1L) {
            long inodeTime = inode.getAccessTime();
            if (atime <= inodeTime + fsd.getFSNamesystem().getAccessTimePrecision() && !force) {
                status = false;
            } else {
                inode.setAccessTime(atime);
                status = true;
            }
        }
        return status;
    }
}

