/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerStats;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.command.StatResetCommand;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.BufferStats;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatResetCommandTest {
    private StatResetCommand statResetCommand;
    private StringWriter outputWriter;
    private ZooKeeperServer zks;
    private ServerStats serverStats;

    @Before
    public void setUp() {
        this.outputWriter = new StringWriter();
        ServerCnxn serverCnxnMock = Mockito.mock(ServerCnxn.class);
        this.zks = Mockito.mock(ZooKeeperServer.class);
        Mockito.when(this.zks.isRunning()).thenReturn(true);
        this.serverStats = Mockito.mock(ServerStats.class);
        Mockito.when(this.zks.serverStats()).thenReturn(this.serverStats);
        this.statResetCommand = new StatResetCommand(new PrintWriter(this.outputWriter), serverCnxnMock);
        this.statResetCommand.setZkServer(this.zks);
    }

    @Test
    public void testStatResetWithZKNotRunning() {
        Mockito.when(this.zks.isRunning()).thenReturn(false);
        this.statResetCommand.commandRun();
        String output = this.outputWriter.toString();
        Assert.assertEquals((Object)"This ZooKeeper instance is not currently serving requests\n", (Object)output);
    }

    @Test
    public void testStatResetWithFollower() {
        Mockito.when(this.zks.isRunning()).thenReturn(true);
        Mockito.when(this.serverStats.getServerState()).thenReturn("follower");
        this.statResetCommand.commandRun();
        String output = this.outputWriter.toString();
        Assert.assertEquals((Object)"Server stats reset.\n", (Object)output);
        Mockito.verify(this.serverStats, Mockito.times(1)).reset();
    }

    @Test
    public void testStatResetWithLeader() {
        LeaderZooKeeperServer leaderZks = Mockito.mock(LeaderZooKeeperServer.class);
        Mockito.when(leaderZks.isRunning()).thenReturn(true);
        Mockito.when(leaderZks.serverStats()).thenReturn(this.serverStats);
        Leader leader = Mockito.mock(Leader.class);
        Mockito.when(leaderZks.getLeader()).thenReturn(leader);
        this.statResetCommand.setZkServer(leaderZks);
        Mockito.when(this.serverStats.getServerState()).thenReturn("leader");
        BufferStats bufferStats = Mockito.mock(BufferStats.class);
        Mockito.when(leader.getProposalStats()).thenReturn(bufferStats);
        this.statResetCommand.commandRun();
        String output = this.outputWriter.toString();
        Assert.assertEquals((Object)"Server stats reset.\n", (Object)output);
        Mockito.verify(this.serverStats, Mockito.times(1)).reset();
        Mockito.verify(bufferStats, Mockito.times(1)).reset();
    }
}

