/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.StorageMap;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.CachedBlock;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CachedBlock;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeDescriptor
extends DatanodeInfo {
    public static final Log LOG = LogFactory.getLog(DatanodeDescriptor.class);
    public static final DatanodeDescriptor[] EMPTY_ARRAY = new DatanodeDescriptor[0];
    public DecommissioningStatus decommissioningStatus = new DecommissioningStatus();
    private long curBlockReportId = 0L;
    private BitSet curBlockReportRpcsSeen = null;
    private final Map<String, DatanodeStorageInfo> storageMap = new HashMap<String, DatanodeStorageInfo>();
    private long lastCachingDirectiveSentTimeMs;
    public boolean isAlive = false;
    public boolean needKeyUpdate = false;
    private long bandwidth;
    private BlockQueue<BlockTargetPair> replicateBlocks = new BlockQueue();
    private BlockQueue<BlockInfoContiguousUnderConstruction> recoverBlocks = new BlockQueue();
    private final LightWeightHashSet<Block> invalidateBlocks = new LightWeightHashSet();
    private EnumCounters<StorageType> currApproxBlocksScheduled = new EnumCounters<StorageType>(StorageType.class);
    private EnumCounters<StorageType> prevApproxBlocksScheduled = new EnumCounters<StorageType>(StorageType.class);
    private long lastBlocksScheduledRollTime = 0L;
    private static final int BLOCKS_SCHEDULED_ROLL_INTERVAL = 600000;
    private int volumeFailures = 0;
    private VolumeFailureSummary volumeFailureSummary = null;
    private boolean disallowed = false;
    private boolean heartbeatedSinceRegistration = false;
    private int PendingReplicationWithoutTargets = 0;
    private final StorageMap globalStorageMap;
    private static final List<DatanodeStorageInfo> EMPTY_STORAGE_INFO_LIST = ImmutableList.of();

    public int updateBlockReportContext(BlockReportContext context) {
        if (this.curBlockReportId != context.getReportId()) {
            this.curBlockReportId = context.getReportId();
            this.curBlockReportRpcsSeen = new BitSet(context.getTotalRpcs());
        }
        this.curBlockReportRpcsSeen.set(context.getCurRpc());
        return this.curBlockReportRpcsSeen.cardinality();
    }

    public void clearBlockReportContext() {
        this.curBlockReportId = 0L;
        this.curBlockReportRpcsSeen = null;
    }

    public Collection<org.apache.hadoop.hdfs.server.namenode.CachedBlock> getPendingCachedTX(DatanodeManager datanodeManager) throws TransactionContextException, StorageException, IOException {
        DatanodeDescriptor dnId = this;
        return (Collection)new HopsTransactionalRequestHandler(HDFSOperationType.GET_PENDING_CACHED, (DatanodeID)dnId, datanodeManager){
            final /* synthetic */ DatanodeID val$dnId;
            final /* synthetic */ DatanodeManager val$datanodeManager;
            {
                this.val$dnId = datanodeID;
                this.val$datanodeManager = datanodeManager;
                super(opType);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getDatanodeCachedBlockLocks(this.val$dnId));
            }

            public Object performTask() throws IOException {
                Collection tmp = EntityManager.findList((FinderType)CachedBlock.Finder.ByDatanodeAndTypes, (Object[])new Object[]{this.val$dnId.getDatanodeUuid(), CachedBlock.Type.PENDING_CACHED});
                return org.apache.hadoop.hdfs.server.namenode.CachedBlock.toHops(tmp, this.val$datanodeManager);
            }
        }.handle();
    }

    public Collection<org.apache.hadoop.hdfs.server.namenode.CachedBlock> getPendingCached(DatanodeManager datanodeManager) throws TransactionContextException, StorageException {
        return org.apache.hadoop.hdfs.server.namenode.CachedBlock.toHops(EntityManager.findList((FinderType)CachedBlock.Finder.ByDatanodeAndTypes, (Object[])new Object[]{this.getDatanodeUuid(), CachedBlock.Type.PENDING_CACHED}), datanodeManager);
    }

    public Collection<org.apache.hadoop.hdfs.server.namenode.CachedBlock> getCached(DatanodeManager datanodeManager) throws TransactionContextException, StorageException {
        return org.apache.hadoop.hdfs.server.namenode.CachedBlock.toHops(EntityManager.findList((FinderType)CachedBlock.Finder.ByDatanodeAndTypes, (Object[])new Object[]{this.getDatanodeUuid(), CachedBlock.Type.CACHED}), datanodeManager);
    }

    public Collection<org.apache.hadoop.hdfs.server.namenode.CachedBlock> getPendingUncachedTX(DatanodeManager datanodeManager) throws TransactionContextException, StorageException, IOException {
        DatanodeDescriptor dnId = this;
        return (Collection)new HopsTransactionalRequestHandler(HDFSOperationType.GET_PENDING_UNCACHED, (DatanodeID)dnId, datanodeManager){
            final /* synthetic */ DatanodeID val$dnId;
            final /* synthetic */ DatanodeManager val$datanodeManager;
            {
                this.val$dnId = datanodeID;
                this.val$datanodeManager = datanodeManager;
                super(opType);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getDatanodeCachedBlockLocks(this.val$dnId));
            }

            public Object performTask() throws IOException {
                return DatanodeDescriptor.this.getPendingUncached(this.val$datanodeManager);
            }
        }.handle();
    }

    public Collection<org.apache.hadoop.hdfs.server.namenode.CachedBlock> getPendingUncached(DatanodeManager datanodeManager) throws TransactionContextException, StorageException {
        return org.apache.hadoop.hdfs.server.namenode.CachedBlock.toHops(EntityManager.findList((FinderType)CachedBlock.Finder.ByDatanodeAndTypes, (Object[])new Object[]{this.getDatanodeUuid(), CachedBlock.Type.PENDING_UNCACHED}), datanodeManager);
    }

    public DatanodeDescriptor(StorageMap storageMap, DatanodeID nodeID) {
        super(nodeID);
        this.globalStorageMap = storageMap;
        this.updateHeartbeatState(StorageReport.EMPTY_ARRAY, 0L, 0L, 0, 0, null);
    }

    public DatanodeDescriptor(StorageMap storageMap, DatanodeID nodeID, String networkLocation) {
        super(nodeID, networkLocation);
        this.globalStorageMap = storageMap;
        this.updateHeartbeatState(StorageReport.EMPTY_ARRAY, 0L, 0L, 0, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public DatanodeStorageInfo getStorageInfo(String storageID) {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            return this.storageMap.get(storageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatanodeStorageInfo[] getStorageInfos() {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            Collection<DatanodeStorageInfo> storages = this.storageMap.values();
            return storages.toArray(new DatanodeStorageInfo[storages.size()]);
        }
    }

    public StorageReport[] getStorageReports() {
        DatanodeStorageInfo[] infos = this.getStorageInfos();
        StorageReport[] reports = new StorageReport[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            reports[i] = infos[i].toStorageReport();
        }
        return reports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasStaleStorages() {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            for (DatanodeStorageInfo storage : this.storageMap.values()) {
                if (!storage.areBlockContentsStale()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DatanodeStorageInfo> removeZombieStorages() {
        LinkedList<DatanodeStorageInfo> zombies = null;
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            Iterator<Map.Entry<String, DatanodeStorageInfo>> iter = this.storageMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, DatanodeStorageInfo> entry = iter.next();
                DatanodeStorageInfo storageInfo = entry.getValue();
                if (storageInfo.getLastBlockReportId() != this.curBlockReportId) {
                    LOG.info((Object)(storageInfo.getStorageID() + " had lastBlockReportId 0x" + Long.toHexString(storageInfo.getLastBlockReportId()) + ", but curBlockReportId = 0x" + Long.toHexString(this.curBlockReportId)));
                    iter.remove();
                    if (zombies == null) {
                        zombies = new LinkedList<DatanodeStorageInfo>();
                    }
                    zombies.add(storageInfo);
                }
                storageInfo.setLastBlockReportId(0L);
            }
        }
        return zombies == null ? EMPTY_STORAGE_INFO_LIST : zombies;
    }

    boolean removeBlock(BlockInfoContiguous b) throws TransactionContextException, StorageException {
        DatanodeStorageInfo s = b.getStorageOnNode(this);
        if (s != null) {
            return s.removeBlock(b);
        }
        return false;
    }

    boolean removeBlock(String storageID, BlockInfoContiguous b) throws StorageException, TransactionContextException {
        DatanodeStorageInfo s = this.getStorageInfo(storageID);
        if (s != null) {
            return b.removeReplica(s) != null;
        }
        return false;
    }

    public void resetBlocks() throws StorageException, TransactionContextException, IOException {
        this.setCapacity(0L);
        this.setRemaining(0L);
        this.setBlockPoolUsed(0L);
        this.setDfsUsed(0L);
        this.setXceiverCount(0);
        this.invalidateBlocks.clear();
        this.volumeFailures = 0;
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBlockQueues() throws TransactionContextException, StorageException, IOException {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            this.invalidateBlocks.clear();
            this.recoverBlocks.clear();
            this.replicateBlocks.clear();
        }
        this.clearCache();
    }

    private void clearCache() throws IOException {
        DatanodeDescriptor datanodeID = this;
        new HopsTransactionalRequestHandler(HDFSOperationType.CLEAR_CACHED_BLOCKS, (DatanodeID)datanodeID){
            final /* synthetic */ DatanodeID val$datanodeID;
            {
                this.val$datanodeID = datanodeID;
                super(opType);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getDatanodeCachedBlockLocks(this.val$datanodeID));
            }

            public Object performTask() throws IOException {
                Collection toRemove = EntityManager.findList((FinderType)CachedBlock.Finder.ByDatanodeId, (Object[])new Object[]{this.val$datanodeID});
                if (toRemove != null) {
                    for (CachedBlock block : toRemove) {
                        EntityManager.remove((Object)block);
                    }
                }
                return null;
            }
        }.handle();
    }

    public int numBlocks() throws IOException {
        int blocks = 0;
        for (DatanodeStorageInfo storage : this.getStorageInfos()) {
            blocks += storage.numBlocks();
        }
        return blocks;
    }

    public void updateHeartbeat(StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int volFailures, VolumeFailureSummary volumeFailureSummary) {
        this.updateHeartbeatState(reports, cacheCapacity, cacheUsed, xceiverCount, volFailures, volumeFailureSummary);
        this.heartbeatedSinceRegistration = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHeartbeatState(StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int volFailures, VolumeFailureSummary volumeFailureSummary) {
        long l;
        boolean checkFailedStorages;
        long totalCapacity = 0L;
        long totalRemaining = 0L;
        long totalBlockPoolUsed = 0L;
        long totalDfsUsed = 0L;
        this.setCacheCapacity(cacheCapacity);
        this.setCacheUsed(cacheUsed);
        HashSet<DatanodeStorageInfo> failedStorageInfos = null;
        if (volumeFailureSummary != null && this.volumeFailureSummary != null) {
            checkFailedStorages = volumeFailureSummary.getLastVolumeFailureDate() > this.volumeFailureSummary.getLastVolumeFailureDate();
        } else {
            boolean bl = checkFailedStorages = volFailures > this.volumeFailures || !this.heartbeatedSinceRegistration;
        }
        if (checkFailedStorages) {
            LOG.info((Object)("Number of failed storage changes from " + this.volumeFailures + " to " + volFailures));
            Map<String, DatanodeStorageInfo> object = this.storageMap;
            synchronized (object) {
                failedStorageInfos = new HashSet<DatanodeStorageInfo>(this.storageMap.values());
            }
        }
        this.setXceiverCount(xceiverCount);
        this.setLastUpdate(Time.now());
        this.setLastUpdateMonotonic(Time.monotonicNow());
        this.volumeFailures = volFailures;
        this.volumeFailureSummary = volumeFailureSummary;
        for (StorageReport report : reports) {
            try {
                DatanodeStorageInfo storage = this.updateStorage(report.getStorage());
                if (checkFailedStorages) {
                    failedStorageInfos.remove(storage);
                }
                storage.receivedHeartbeat(report);
                totalCapacity += report.getCapacity();
                totalRemaining += report.getRemaining();
                totalBlockPoolUsed += report.getBlockPoolUsed();
                totalDfsUsed += report.getDfsUsed();
            }
            catch (IOException ex) {
                LOG.error((Object)("could not handle storage report for storage: " + report.getStorage().getStorageID()), (Throwable)ex);
            }
        }
        this.rollBlocksScheduled(this.getLastUpdateMonotonic());
        this.setCapacity(totalCapacity);
        this.setRemaining(totalRemaining);
        this.setBlockPoolUsed(totalBlockPoolUsed);
        this.setDfsUsed(totalDfsUsed);
        if (checkFailedStorages) {
            this.updateFailedStorage(failedStorageInfos);
        }
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            l = this.storageMap.size();
        }
        if (l != (long)reports.length) {
            this.pruneStorageMap(reports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneStorageMap(StorageReport[] reports) {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Number of storages reported in heartbeat=" + reports.length + "; Number of storages in storageMap=" + this.storageMap.size()));
            }
            HashMap<String, DatanodeStorageInfo> excessStorages = new HashMap<String, DatanodeStorageInfo>(this.storageMap);
            for (StorageReport report : reports) {
                excessStorages.remove(report.getStorage().getStorageID());
            }
            for (DatanodeStorageInfo storageInfo : excessStorages.values()) {
                try {
                    if (storageInfo.numBlocks() == 0) {
                        this.storageMap.remove(storageInfo.getStorageID());
                        LOG.info((Object)("Removed storage " + storageInfo + " from DataNode" + (Object)((Object)this)));
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Deferring removal of stale storage " + storageInfo + " with " + storageInfo.numBlocks() + " blocks"));
                }
                catch (IOException e) {
                    LOG.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    private void updateFailedStorage(Set<DatanodeStorageInfo> failedStorageInfos) {
        for (DatanodeStorageInfo storageInfo : failedStorageInfos) {
            if (storageInfo.getState() == DatanodeStorage.State.FAILED) continue;
            LOG.info((Object)(storageInfo + " failed."));
            storageInfo.setState(DatanodeStorage.State.FAILED);
        }
    }

    Iterator<BlockInfoContiguous> getBlockIterator() throws IOException {
        return new BlockIterator(0, this.getStorageInfos());
    }

    Iterator<BlockInfoContiguous> getBlockIterator(int startBlock) throws IOException {
        return new BlockIterator(startBlock, this.getStorageInfos());
    }

    Iterator<BlockInfoContiguous> getBlockIterator(String storageID) throws IOException {
        return new BlockIterator(0, new DatanodeStorageInfo[]{this.getStorageInfo(storageID)});
    }

    public Map<Long, Long> getAllStorageReplicas(int numBuckets, int nbThreads, int BucketsPerThread, ExecutorService executor) throws IOException {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        for (DatanodeStorageInfo storageInfo : this.getStorageInfos()) {
            result.putAll(storageInfo.getAllStorageReplicas(numBuckets, nbThreads, BucketsPerThread, executor));
        }
        return result;
    }

    void incrementPendingReplicationWithoutTargets() {
        ++this.PendingReplicationWithoutTargets;
    }

    void decrementPendingReplicationWithoutTargets() {
        --this.PendingReplicationWithoutTargets;
    }

    void addBlockToBeReplicated(Block block, DatanodeStorageInfo[] targets) {
        assert (block != null && targets != null && targets.length > 0);
        this.replicateBlocks.offer(new BlockTargetPair(block, targets));
    }

    void addBlockToBeRecovered(BlockInfoContiguousUnderConstruction block) {
        if (this.recoverBlocks.contains(block)) {
            BlockManager.LOG.info((Object)((Object)block) + " is already in the recovery queue");
            return;
        }
        this.recoverBlocks.offer(block);
    }

    void addBlocksToBeInvalidated(List<Block> blocklist) {
        assert (blocklist != null && blocklist.size() > 0);
        for (Block blk : blocklist) {
            this.addBlockToBeInvalidated(blk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBlockToBeInvalidated(Block block) {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            this.invalidateBlocks.add(block);
        }
    }

    int getNumberOfBlocksToBeReplicated() {
        return this.PendingReplicationWithoutTargets + this.replicateBlocks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfBlocksToBeInvalidated() {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            return this.invalidateBlocks.size();
        }
    }

    public long getRemaining(StorageType t, long minSize) {
        long remaining = 0L;
        for (DatanodeStorageInfo s : this.getStorageInfos()) {
            long r;
            if (s.getState() != DatanodeStorage.State.NORMAL || t != null && s.getStorageType() != t || (r = s.getRemaining()) < minSize) continue;
            remaining += r;
        }
        return remaining;
    }

    public List<BlockTargetPair> getReplicationCommand(int maxTransfers) {
        return this.replicateBlocks.poll(maxTransfers);
    }

    public BlockInfoContiguousUnderConstruction[] getLeaseRecoveryCommand(int maxTransfers) {
        List<BlockInfoContiguousUnderConstruction> blocks = this.recoverBlocks.poll(maxTransfers);
        if (blocks == null) {
            return null;
        }
        return blocks.toArray(new BlockInfoContiguousUnderConstruction[blocks.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block[] getInvalidateBlocks(int maxblocks) {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            Block[] deleteList = this.invalidateBlocks.pollToArray((Block[])new Block[Math.min(this.invalidateBlocks.size(), maxblocks)]);
            return deleteList.length == 0 ? null : deleteList;
        }
    }

    public int getBlocksScheduled(StorageType t) {
        return (int)(this.currApproxBlocksScheduled.get(t) + this.prevApproxBlocksScheduled.get(t));
    }

    public int getBlocksScheduled() {
        return (int)(this.currApproxBlocksScheduled.sum() + this.prevApproxBlocksScheduled.sum());
    }

    void incrementBlocksScheduled(StorageType t) {
        this.currApproxBlocksScheduled.add(t, 1L);
    }

    void decrementBlocksScheduled(StorageType t) {
        if (this.prevApproxBlocksScheduled.get(t) > 0L) {
            this.prevApproxBlocksScheduled.subtract(t, 1L);
        } else if (this.currApproxBlocksScheduled.get(t) > 0L) {
            this.currApproxBlocksScheduled.subtract(t, 1L);
        }
    }

    private void rollBlocksScheduled(long now) {
        if (now - this.lastBlocksScheduledRollTime > 600000L) {
            this.prevApproxBlocksScheduled.set(this.currApproxBlocksScheduled);
            this.currApproxBlocksScheduled.reset();
            this.lastBlocksScheduledRollTime = now;
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    public void setDisallowed(boolean flag) {
        this.disallowed = flag;
    }

    public boolean isDisallowed() {
        return this.disallowed;
    }

    public int getVolumeFailures() {
        return this.volumeFailures;
    }

    public VolumeFailureSummary getVolumeFailureSummary() {
        return this.volumeFailureSummary;
    }

    public void updateRegInfo(DatanodeID nodeReg) {
        super.updateRegInfo(nodeReg);
        for (DatanodeStorageInfo storage : this.getStorageInfos()) {
            storage.setBlockReportCount(0);
        }
        this.heartbeatedSinceRegistration = false;
    }

    public long getBalancerBandwidth() {
        return this.bandwidth;
    }

    public void setBalancerBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
    }

    public String dumpDatanode() {
        int recover;
        int inval;
        StringBuilder sb = new StringBuilder(super.dumpDatanode());
        int repl = this.replicateBlocks.size();
        if (repl > 0) {
            sb.append(" ").append(repl).append(" blocks to be replicated;");
        }
        if ((inval = this.invalidateBlocks.size()) > 0) {
            sb.append(" ").append(inval).append(" blocks to be invalidated;");
        }
        if ((recover = this.recoverBlocks.size()) > 0) {
            sb.append(" ").append(recover).append(" blocks to be recovered;");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatanodeStorageInfo updateStorage(DatanodeStorage s) throws IOException {
        Map<String, DatanodeStorageInfo> map = this.storageMap;
        synchronized (map) {
            DatanodeStorageInfo storage = this.getStorageInfo(s.getStorageID());
            if (storage == null) {
                storage = new DatanodeStorageInfo(this, s);
                this.storageMap.put(s.getStorageID(), storage);
            } else if (storage.getState() != s.getState() || storage.getStorageType() != s.getStorageType()) {
                storage.updateFromStorage(s);
            }
            this.globalStorageMap.updateStorage(storage);
            return storage;
        }
    }

    public HashSet<Integer> getSidsOnNode() {
        HashSet<Integer> sids = new HashSet<Integer>();
        for (DatanodeStorageInfo s : this.getStorageInfos()) {
            sids.add(s.getSid());
        }
        return sids;
    }

    public boolean checkBlockReportReceived() {
        if (this.getStorageInfos().length == 0) {
            return false;
        }
        for (DatanodeStorageInfo storageInfo : this.getStorageInfos()) {
            if (storageInfo.getBlockReportCount() != 0) continue;
            return false;
        }
        return true;
    }

    public long getLastCachingDirectiveSentTimeMs() {
        return this.lastCachingDirectiveSentTimeMs;
    }

    public void setLastCachingDirectiveSentTimeMs(long time) {
        this.lastCachingDirectiveSentTimeMs = time;
    }

    public class DecommissioningStatus {
        private int underReplicatedBlocks;
        private int decommissionOnlyReplicas;
        private int underReplicatedInOpenFiles;
        private long startTime;

        synchronized void set(int underRep, int onlyRep, int underConstruction) {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return;
            }
            this.underReplicatedBlocks = underRep;
            this.decommissionOnlyReplicas = onlyRep;
            this.underReplicatedInOpenFiles = underConstruction;
        }

        public synchronized int getUnderReplicatedBlocks() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.underReplicatedBlocks;
        }

        public synchronized int getDecommissionOnlyReplicas() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.decommissionOnlyReplicas;
        }

        public synchronized int getUnderReplicatedInOpenFiles() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.underReplicatedInOpenFiles;
        }

        public synchronized void setStartTime(long time) {
            this.startTime = time;
        }

        public synchronized long getStartTime() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0L;
            }
            return this.startTime;
        }
    }

    private static class BlockIterator
    implements Iterator<BlockInfoContiguous> {
        private int index = 0;
        private final List<Iterator<BlockInfoContiguous>> iterators;

        private BlockIterator(int startBlock, DatanodeStorageInfo ... storages) throws IOException {
            if (startBlock < 0) {
                throw new IllegalArgumentException("Illegal value startBlock = " + startBlock);
            }
            ArrayList<Iterator<BlockInfoContiguous>> iterators = new ArrayList<Iterator<BlockInfoContiguous>>();
            int s = startBlock;
            int sumBlocks = 0;
            boolean first = true;
            for (DatanodeStorageInfo e : storages) {
                int numBlocks = e.numBlocks();
                if ((sumBlocks += numBlocks) <= startBlock) {
                    s -= numBlocks;
                    continue;
                }
                if (first) {
                    iterators.add(e.getBlockIterator(s));
                    first = false;
                    continue;
                }
                iterators.add(e.getBlockIterator(0));
            }
            this.iterators = Collections.unmodifiableList(iterators);
        }

        @Override
        public boolean hasNext() {
            this.update();
            return !this.iterators.isEmpty() && this.iterators.get(this.index).hasNext();
        }

        @Override
        public BlockInfoContiguous next() {
            this.update();
            return this.iterators.get(this.index).next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove unsupported.");
        }

        private void update() {
            while (this.index < this.iterators.size() - 1 && !this.iterators.get(this.index).hasNext()) {
                ++this.index;
            }
        }
    }

    private static class BlockQueue<E> {
        private final Queue<E> blockq = new LinkedList();

        private BlockQueue() {
        }

        synchronized int size() {
            return this.blockq.size();
        }

        synchronized boolean offer(E e) {
            return this.blockq.offer(e);
        }

        synchronized List<E> poll(int numBlocks) {
            if (numBlocks <= 0 || this.blockq.isEmpty()) {
                return null;
            }
            ArrayList<E> results = new ArrayList<E>();
            while (!this.blockq.isEmpty() && numBlocks > 0) {
                results.add(this.blockq.poll());
                --numBlocks;
            }
            return results;
        }

        boolean contains(E e) {
            return this.blockq.contains(e);
        }

        synchronized void clear() {
            this.blockq.clear();
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class BlockTargetPair {
        public final Block block;
        public final DatanodeStorageInfo[] targets;

        BlockTargetPair(Block block, DatanodeStorageInfo[] targets) {
            this.block = block;
            this.targets = targets;
        }
    }
}

