/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.util;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.BitHashSet;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class BitHashSetTest
extends ZKTestCase {
    @Test
    public void testAddWatchBit() {
        int watcherCacheSize = 1;
        BitHashSet ws = new BitHashSet(watcherCacheSize);
        Assert.assertTrue((boolean)ws.add(1));
        Assert.assertEquals((long)1L, (long)ws.size());
        Assert.assertEquals((long)1L, (long)ws.cachedSize());
        ArrayList<Integer> actualBits = new ArrayList<Integer>();
        for (int bit : ws) {
            actualBits.add(bit);
        }
        Assert.assertArrayEquals((Object[])new Integer[]{1}, (Object[])actualBits.toArray(new Integer[actualBits.size()]));
        Assert.assertFalse((boolean)ws.add(1));
        Assert.assertEquals((long)1L, (long)ws.size());
        Assert.assertEquals((long)1L, (long)ws.cachedSize());
        Assert.assertTrue((boolean)ws.add(2));
        Assert.assertEquals((long)2L, (long)ws.size());
        Assert.assertEquals((long)1L, (long)ws.cachedSize());
        Assert.assertTrue((boolean)ws.contains(1));
        actualBits.clear();
        for (int bit : ws) {
            actualBits.add(bit);
        }
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2}, (Object[])actualBits.toArray(new Integer[actualBits.size()]));
    }

    @Test
    public void testRemoveWatchBit() {
        int watcherCacheSize = 1;
        BitHashSet ws = new BitHashSet(watcherCacheSize);
        ws.add(1);
        ws.add(2);
        Assert.assertTrue((boolean)ws.contains(1));
        Assert.assertTrue((boolean)ws.contains(2));
        ws.remove(1);
        Assert.assertFalse((boolean)ws.contains(1));
        Assert.assertEquals((long)1L, (long)ws.size());
        Assert.assertEquals((long)0L, (long)ws.cachedSize());
        ArrayList<Integer> actualBits = new ArrayList<Integer>();
        for (int bit : ws) {
            actualBits.add(bit);
        }
        Assert.assertArrayEquals((Object[])new Integer[]{2}, (Object[])actualBits.toArray(new Integer[actualBits.size()]));
        ws.add(3);
        Assert.assertEquals((long)2L, (long)ws.size());
        Assert.assertEquals((long)1L, (long)ws.cachedSize());
        actualBits.clear();
        for (int bit : ws) {
            actualBits.add(bit);
        }
        Assert.assertArrayEquals((Object[])new Integer[]{2, 3}, (Object[])actualBits.toArray(new Integer[actualBits.size()]));
        ws.remove(2);
        ws.remove(3);
        Assert.assertEquals((long)0L, (long)ws.size());
        Assert.assertEquals((long)0L, (long)ws.cachedSize());
    }
}

