/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.nustaq.serialization;

import io.hops.hadoop.shaded.com.fasterxml.jackson.core.JsonFactory;
import io.hops.hadoop.shaded.com.fasterxml.jackson.core.JsonGenerator;
import io.hops.hadoop.shaded.com.fasterxml.jackson.core.ObjectCodec;
import io.hops.hadoop.shaded.com.fasterxml.jackson.core.PrettyPrinter;
import io.hops.hadoop.shaded.com.fasterxml.jackson.core.SerializableString;
import io.hops.hadoop.shaded.com.fasterxml.jackson.core.io.IOContext;
import io.hops.hadoop.shaded.com.fasterxml.jackson.core.json.UTF8JsonGenerator;
import io.hops.hadoop.shaded.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import io.hops.hadoop.shaded.org.nustaq.offheap.bytez.onheap.HeapBytez;
import io.hops.hadoop.shaded.org.nustaq.offheap.structs.FSTStruct;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTClassInstantiator;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTClazzInfo;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTClazzInfoRegistry;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTClazzNameRegistry;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTDecoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTDefaultClassInstantiator;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTEncoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTObjectInput;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTObjectOutput;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTObjectSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTObjenesisInstantiator;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTSerializerRegistry;
import io.hops.hadoop.shaded.org.nustaq.serialization.FSTSerializerRegistryDelegate;
import io.hops.hadoop.shaded.org.nustaq.serialization.coders.FSTBytezDecoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.coders.FSTBytezEncoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.coders.FSTJsonDecoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.coders.FSTJsonEncoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.coders.FSTMinBinDecoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.coders.FSTMinBinEncoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.coders.FSTStreamDecoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.coders.FSTStreamEncoder;
import io.hops.hadoop.shaded.org.nustaq.serialization.coders.Unknown;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTArrayListSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTBigIntegerSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTBigNumberSerializers;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTCPEnumSetSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTCPThrowableSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTClassSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTCollectionSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTDateSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTEnumSetSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTJSonSerializers;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTJSonUnmodifiableCollectionSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTJSonUnmodifiableMapSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTMapSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTStringBufferSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTStringBuilderSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTStringSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.serializers.FSTStructSerializer;
import io.hops.hadoop.shaded.org.nustaq.serialization.util.FSTInputStream;
import io.hops.hadoop.shaded.org.nustaq.serialization.util.FSTUtil;
import io.hops.hadoop.shaded.org.objenesis.ObjenesisStd;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class FSTConfiguration {
    StreamCoderFactory streamCoderFactory = new FSTDefaultStreamCoderFactory(this);
    String name;
    ClassSecurityVerifier verifier;
    ConfType type = ConfType.DEFAULT;
    FSTClazzInfoRegistry serializationInfoRegistry = new FSTClazzInfoRegistry();
    HashMap<Class, List<SoftReference>> cachedObjects = new HashMap(97);
    FSTClazzNameRegistry classRegistry = new FSTClazzNameRegistry(null);
    boolean preferSpeed = false;
    boolean shareReferences = true;
    volatile ClassLoader classLoader = this.getClass().getClassLoader();
    boolean forceSerializable = false;
    FSTClassInstantiator instantiator = new FSTDefaultClassInstantiator();
    Object coderSpecific;
    LastResortClassRessolver lastResortResolver;
    boolean forceClzInit = false;
    ConcurrentHashMap<FieldKey, FSTClazzInfo.FSTFieldInfo> fieldInfoCache;
    int cpAttrIdCount = 0;
    private HashMap<String, String> minbinNames = new HashMap();
    private HashMap<String, byte[]> minBinNamesBytez = new HashMap();
    private HashMap<String, String> minbinNamesReverse = new HashMap();
    private boolean crossPlatform = false;
    public static boolean isAndroid = System.getProperty("java.runtime.name", "no").toLowerCase().contains("android");
    static AtomicBoolean conflock = new AtomicBoolean(false);
    static FSTConfiguration singleton;
    AtomicBoolean cacheLock = new AtomicBoolean(false);
    AtomicBoolean cplock = new AtomicBoolean(false);

    public ClassSecurityVerifier getVerifier() {
        return this.verifier;
    }

    public FSTConfiguration setVerifier(ClassSecurityVerifier verifier) {
        this.verifier = verifier;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static FSTConfiguration getDefaultConfiguration() {
        while (!conflock.compareAndSet(false, true)) {
        }
        try {
            if (singleton == null) {
                singleton = FSTConfiguration.createDefaultConfiguration();
            }
            FSTConfiguration fSTConfiguration = singleton;
            return fSTConfiguration;
        }
        finally {
            conflock.set(false);
        }
    }

    public static FSTConfiguration createMinBinConfiguration() {
        return FSTConfiguration.createMinBinConfiguration(null);
    }

    protected static FSTConfiguration createMinBinConfiguration(ConcurrentHashMap<FieldKey, FSTClazzInfo.FSTFieldInfo> shared) {
        FSTConfiguration res = FSTConfiguration.createDefaultConfiguration(shared);
        res.setCrossPlatform(true);
        res.type = ConfType.MINBIN;
        res.setStreamCoderFactory(new MinBinStreamCoderFactory(res));
        FSTSerializerRegistry reg = res.serializationInfoRegistry.getSerializerRegistry();
        reg.putSerializer(EnumSet.class, new FSTCPEnumSetSerializer(), true);
        reg.putSerializer(Throwable.class, new FSTCPThrowableSerializer(), true);
        reg.putSerializer(AbstractCollection.class, new FSTCollectionSerializer(), true);
        reg.putSerializer(AbstractMap.class, new FSTMapSerializer(), true);
        res.registerCrossPlatformClassMapping(new String[][]{{"map", HashMap.class.getName()}, {"list", ArrayList.class.getName()}, {"set", HashSet.class.getName()}, {"long", Long.class.getName()}, {"integer", Integer.class.getName()}, {"short", Short.class.getName()}, {"byte", Byte.class.getName()}, {"char", Character.class.getName()}, {"float", Float.class.getName()}, {"double", Double.class.getName()}, {"date", Date.class.getName()}, {"enumSet", "java.util.RegularEnumSet"}, {"array", "[Ljava.lang.Object;"}, {"String[]", "[Ljava.lang.String;"}, {"Double[]", "[Ljava.lang.Double;"}, {"Float[]", "[Ljava.lang.Float;"}, {"double[]", "[D"}, {"float[]", "[F"}});
        res.registerSerializer(BigDecimal.class, new FSTJSonSerializers.BigDecSerializer(), true);
        return res;
    }

    public static FSTConfiguration createJsonNoRefConfiguration() {
        return FSTConfiguration.createJsonConfiguration(false, false);
    }

    public static FSTConfiguration createJsonConfiguration(boolean prettyPrint, boolean shareReferences) {
        if (shareReferences && prettyPrint) {
            throw new RuntimeException("unsupported flag combination");
        }
        return FSTConfiguration.createJsonConfiguration(prettyPrint, shareReferences, null);
    }

    protected static FSTConfiguration createJsonConfiguration(boolean prettyPrint, boolean shareReferences, ConcurrentHashMap<FieldKey, FSTClazzInfo.FSTFieldInfo> shared) {
        if (prettyPrint && shareReferences) {
            throw new RuntimeException("cannot use prettyPrint with shared refs to 'true'. Set shareRefs to false.");
        }
        return FSTConfiguration.constructJsonConf(prettyPrint, shareReferences, shared);
    }

    private static FSTConfiguration constructJsonConf(boolean prettyPrint, boolean shareReferences, ConcurrentHashMap<FieldKey, FSTClazzInfo.FSTFieldInfo> shared) {
        JsonFactory fac;
        FSTConfiguration conf = FSTConfiguration.createMinBinConfiguration(shared);
        FSTSerializerRegistry reg = conf.serializationInfoRegistry.getSerializerRegistry();
        reg.putSerializer(FSTJSonUnmodifiableCollectionSerializer.UNMODIFIABLE_COLLECTION_CLASS, new FSTJSonUnmodifiableCollectionSerializer(), true);
        reg.putSerializer(FSTJSonUnmodifiableMapSerializer.UNMODIFIABLE_MAP_CLASS, new FSTJSonUnmodifiableMapSerializer(), false);
        ConfType confType = conf.type = prettyPrint ? ConfType.JSONPRETTY : ConfType.JSON;
        if (prettyPrint) {
            fac = new JsonFactory(){

                protected JsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
                    SerializableString rootSep;
                    JacksonAccessWorkaround gen = new JacksonAccessWorkaround(ctxt, this._generatorFeatures, this._objectCodec, out);
                    if (this._characterEscapes != null) {
                        gen.setCharacterEscapes(this._characterEscapes);
                    }
                    if ((rootSep = this._rootValueSeparator) != DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR) {
                        gen.setRootValueSeparator(rootSep);
                    }
                    return gen;
                }

                public JsonGenerator createGenerator(OutputStream out) throws IOException {
                    return super.createGenerator(out).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
                }
            }.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM).disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        } else {
            fac = new JsonFactory(){

                protected JsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
                    SerializableString rootSep;
                    JacksonAccessWorkaround gen = new JacksonAccessWorkaround(ctxt, this._generatorFeatures, this._objectCodec, out);
                    if (this._characterEscapes != null) {
                        gen.setCharacterEscapes(this._characterEscapes);
                    }
                    if ((rootSep = this._rootValueSeparator) != DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR) {
                        gen.setRootValueSeparator(rootSep);
                    }
                    return gen;
                }
            };
            fac.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM).disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        }
        conf.setCoderSpecific(fac);
        conf.setStreamCoderFactory(new JSonStreamCoderFactory(conf));
        conf.setShareReferences(shareReferences);
        conf.setLastResortResolver(new LastResortClassRessolver(){

            @Override
            public Class getClass(String clName) {
                return Unknown.class;
            }
        });
        return conf;
    }

    public static void prettyPrintJson(Object o) {
        FSTConfiguration conf = FSTConfiguration.constructJsonConf(true, true, null);
        System.out.println(conf.asJsonString(o));
    }

    public static FSTConfiguration createAndroidDefaultConfiguration() {
        return FSTConfiguration.createAndroidDefaultConfiguration(null);
    }

    protected static FSTConfiguration createAndroidDefaultConfiguration(ConcurrentHashMap<FieldKey, FSTClazzInfo.FSTFieldInfo> shared) {
        final ObjenesisStd genesis = new ObjenesisStd();
        FSTConfiguration conf = new FSTConfiguration(shared){

            @Override
            public FSTClassInstantiator getInstantiator(Class clazz) {
                return new FSTObjenesisInstantiator(genesis, clazz);
            }
        };
        FSTConfiguration.initDefaultFstConfigurationInternal(conf);
        if (isAndroid) {
            try {
                conf.registerSerializer(Class.forName("io.hops.hadoop.shaded.com.google.gson.internal.LinkedTreeMap"), new FSTMapSerializer(), true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                conf.registerSerializer(Class.forName("io.hops.hadoop.shaded.com.google.gson.internal.LinkedHashTreeMap"), new FSTMapSerializer(), true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return conf;
    }

    public static FSTConfiguration createConfiguration(ConfType ct, boolean shareRefs) {
        return FSTConfiguration.createConfiguration(ct, shareRefs);
    }

    protected static FSTConfiguration createConfiguration(ConfType ct, boolean shareRefs, ConcurrentHashMap<FieldKey, FSTClazzInfo.FSTFieldInfo> shared) {
        FSTConfiguration res;
        switch (ct) {
            case DEFAULT: {
                res = FSTConfiguration.createDefaultConfiguration(shared);
                break;
            }
            case MINBIN: {
                res = FSTConfiguration.createMinBinConfiguration(shared);
                break;
            }
            case UNSAFE: {
                res = FSTConfiguration.createUnsafeBinaryConfiguration(shared);
                break;
            }
            case JSON: {
                res = FSTConfiguration.createJsonConfiguration(false, shareRefs, shared);
                break;
            }
            case JSONPRETTY: {
                res = FSTConfiguration.createJsonConfiguration(true, shareRefs, shared);
                break;
            }
            default: {
                throw new RuntimeException("unsupported conftype for factory method");
            }
        }
        res.setShareReferences(shareRefs);
        return res;
    }

    public static FSTConfiguration createDefaultConfiguration() {
        return FSTConfiguration.createDefaultConfiguration(null);
    }

    protected static FSTConfiguration createDefaultConfiguration(ConcurrentHashMap<FieldKey, FSTClazzInfo.FSTFieldInfo> shared) {
        if (isAndroid) {
            return FSTConfiguration.createAndroidDefaultConfiguration(shared);
        }
        FSTConfiguration conf = new FSTConfiguration(shared);
        return FSTConfiguration.initDefaultFstConfigurationInternal(conf);
    }

    protected static FSTConfiguration initDefaultFstConfigurationInternal(FSTConfiguration conf) {
        conf.addDefaultClazzes();
        FSTSerializerRegistry reg = conf.getCLInfoRegistry().getSerializerRegistry();
        reg.putSerializer(Class.class, new FSTClassSerializer(), false);
        reg.putSerializer(String.class, new FSTStringSerializer(), false);
        reg.putSerializer(Byte.class, new FSTBigNumberSerializers.FSTByteSerializer(), false);
        reg.putSerializer(Character.class, new FSTBigNumberSerializers.FSTCharSerializer(), false);
        reg.putSerializer(Short.class, new FSTBigNumberSerializers.FSTShortSerializer(), false);
        reg.putSerializer(Float.class, new FSTBigNumberSerializers.FSTFloatSerializer(), false);
        reg.putSerializer(Double.class, new FSTBigNumberSerializers.FSTDoubleSerializer(), false);
        reg.putSerializer(Date.class, new FSTDateSerializer(), false);
        reg.putSerializer(StringBuffer.class, new FSTStringBufferSerializer(), true);
        reg.putSerializer(StringBuilder.class, new FSTStringBuilderSerializer(), true);
        reg.putSerializer(EnumSet.class, new FSTEnumSetSerializer(), true);
        reg.putSerializer(ArrayList.class, new FSTArrayListSerializer(), false);
        reg.putSerializer(Vector.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(LinkedList.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(HashSet.class, new FSTCollectionSerializer(), false);
        reg.putSerializer(HashMap.class, new FSTMapSerializer(), false);
        reg.putSerializer(LinkedHashMap.class, new FSTMapSerializer(), false);
        reg.putSerializer(Hashtable.class, new FSTMapSerializer(), true);
        reg.putSerializer(ConcurrentHashMap.class, new FSTMapSerializer(), true);
        reg.putSerializer(FSTStruct.class, new FSTStructSerializer(), true);
        reg.putSerializer(BigInteger.class, new FSTBigIntegerSerializer(), true);
        return conf;
    }

    public static FSTConfiguration createUnsafeBinaryConfiguration() {
        return FSTConfiguration.createUnsafeBinaryConfiguration(null);
    }

    protected static FSTConfiguration createUnsafeBinaryConfiguration(ConcurrentHashMap<FieldKey, FSTClazzInfo.FSTFieldInfo> shared) {
        if (isAndroid) {
            throw new RuntimeException("not supported under android platform, use default configuration");
        }
        FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration(shared);
        conf.type = ConfType.UNSAFE;
        conf.setStreamCoderFactory(new FBinaryStreamCoderFactory(conf));
        return conf;
    }

    public void registerSerializer(Class clazz, FSTObjectSerializer ser, boolean alsoForAllSubclasses) {
        this.serializationInfoRegistry.getSerializerRegistry().putSerializer(clazz, ser, alsoForAllSubclasses);
    }

    public boolean isForceClzInit() {
        return this.forceClzInit;
    }

    public LastResortClassRessolver getLastResortResolver() {
        return this.lastResortResolver;
    }

    public void setLastResortResolver(LastResortClassRessolver lastResortResolver) {
        this.lastResortResolver = lastResortResolver;
    }

    public FSTConfiguration setForceClzInit(boolean forceClzInit) {
        this.forceClzInit = forceClzInit;
        return this;
    }

    public FSTClassInstantiator getInstantiator(Class clazz) {
        return this.instantiator;
    }

    public void setInstantiator(FSTClassInstantiator instantiator) {
        this.instantiator = instantiator;
    }

    public <T> T getCoderSpecific() {
        return (T)this.coderSpecific;
    }

    public void setCoderSpecific(Object coderSpecific) {
        this.coderSpecific = coderSpecific;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static FSTConfiguration createStructConfiguration() {
        FSTConfiguration conf = new FSTConfiguration(null);
        conf.setStructMode(true);
        return conf;
    }

    protected FSTConfiguration(ConcurrentHashMap<FieldKey, FSTClazzInfo.FSTFieldInfo> sharedFieldInfos) {
        this.fieldInfoCache = sharedFieldInfos;
    }

    public StreamCoderFactory getStreamCoderFactory() {
        return this.streamCoderFactory;
    }

    public void setStreamCoderFactory(StreamCoderFactory streamCoderFactory) {
        this.streamCoderFactory = streamCoderFactory;
    }

    public void returnObject(Object cached) {
        try {
            while (!this.cacheLock.compareAndSet(false, true)) {
            }
            List<SoftReference> li = this.cachedObjects.get(cached.getClass());
            if (li == null) {
                li = new ArrayList<SoftReference>();
                this.cachedObjects.put(cached.getClass(), li);
            }
            if (li.size() < 5) {
                li.add(new SoftReference<Object>(cached));
            }
        }
        finally {
            this.cacheLock.set(false);
        }
    }

    public boolean isPreferSpeed() {
        return this.preferSpeed;
    }

    public void setPreferSpeed(boolean preferSpeed) {
        this.preferSpeed = preferSpeed;
    }

    public int calcObjectSizeBytesNotAUtility(Object obj) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        FSTObjectOutput ou = new FSTObjectOutput(bout, this);
        ou.writeObject(obj, obj.getClass());
        ou.close();
        return bout.toByteArray().length;
    }

    public void setSerializerRegistryDelegate(FSTSerializerRegistryDelegate del) {
        this.serializationInfoRegistry.setSerializerRegistryDelegate(del);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedObject(Class cl) {
        try {
            while (!this.cacheLock.compareAndSet(false, true)) {
            }
            List<SoftReference> li = this.cachedObjects.get(cl);
            if (li == null) {
                Object var3_3 = null;
                return var3_3;
            }
            for (int i = li.size() - 1; i >= 0; --i) {
                SoftReference softReference = li.get(i);
                Object res = softReference.get();
                li.remove(i);
                if (res == null) continue;
                Object t = res;
                return t;
            }
        }
        finally {
            this.cacheLock.set(false);
        }
        return null;
    }

    public boolean isForceSerializable() {
        return this.forceSerializable;
    }

    public FSTConfiguration setForceSerializable(boolean forceSerializable) {
        this.forceSerializable = forceSerializable;
        return this;
    }

    public static void clearGlobalCaches() {
        FSTClazzInfo.sharedFieldSets.clear();
        FSTDefaultClassInstantiator.constructorMap.clear();
    }

    public void clearCaches() {
        try {
            FSTInputStream.cachedBuffer.set(null);
            while (!this.cacheLock.compareAndSet(false, true)) {
            }
            this.cachedObjects.clear();
        }
        finally {
            this.cacheLock.set(false);
        }
    }

    public boolean isShareReferences() {
        return this.shareReferences;
    }

    public void setShareReferences(boolean shareReferences) {
        this.shareReferences = shareReferences;
    }

    public void registerClass(Class ... c) {
        for (int i = 0; i < c.length; ++i) {
            this.classRegistry.registerClass(c[i], this);
            try {
                Class<?> ac = Class.forName("[L" + c[i].getName() + ";");
                this.classRegistry.registerClass(ac, this);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    void addDefaultClazzes() {
        this.classRegistry.registerClass(String.class, this);
        this.classRegistry.registerClass(Byte.class, this);
        this.classRegistry.registerClass(Short.class, this);
        this.classRegistry.registerClass(Integer.class, this);
        this.classRegistry.registerClass(Long.class, this);
        this.classRegistry.registerClass(Float.class, this);
        this.classRegistry.registerClass(Double.class, this);
        this.classRegistry.registerClass(BigDecimal.class, this);
        this.classRegistry.registerClass(BigInteger.class, this);
        this.classRegistry.registerClass(Character.class, this);
        this.classRegistry.registerClass(Boolean.class, this);
        this.classRegistry.registerClass(TreeMap.class, this);
        this.classRegistry.registerClass(HashMap.class, this);
        this.classRegistry.registerClass(ArrayList.class, this);
        this.classRegistry.registerClass(ConcurrentHashMap.class, this);
        this.classRegistry.registerClass(URL.class, this);
        this.classRegistry.registerClass(Date.class, this);
        this.classRegistry.registerClass(java.sql.Date.class, this);
        this.classRegistry.registerClass(SimpleDateFormat.class, this);
        this.classRegistry.registerClass(TreeSet.class, this);
        this.classRegistry.registerClass(LinkedList.class, this);
        this.classRegistry.registerClass(SimpleTimeZone.class, this);
        this.classRegistry.registerClass(GregorianCalendar.class, this);
        this.classRegistry.registerClass(Vector.class, this);
        this.classRegistry.registerClass(Hashtable.class, this);
        this.classRegistry.registerClass(BitSet.class, this);
        this.classRegistry.registerClass(Locale.class, this);
        this.classRegistry.registerClass(StringBuffer.class, this);
        this.classRegistry.registerClass(StringBuilder.class, this);
        this.classRegistry.registerClass(Object.class, this);
        this.classRegistry.registerClass(Object[].class, this);
        this.classRegistry.registerClass(Object[][].class, this);
        this.classRegistry.registerClass(Object[][][].class, this);
        this.classRegistry.registerClass(byte[].class, this);
        this.classRegistry.registerClass(byte[][].class, this);
        this.classRegistry.registerClass(char[].class, this);
        this.classRegistry.registerClass(char[][].class, this);
        this.classRegistry.registerClass(short[].class, this);
        this.classRegistry.registerClass(short[][].class, this);
        this.classRegistry.registerClass(int[].class, this);
        this.classRegistry.registerClass(int[][].class, this);
        this.classRegistry.registerClass(float[].class, this);
        this.classRegistry.registerClass(float[][].class, this);
        this.classRegistry.registerClass(double[].class, this);
        this.classRegistry.registerClass(double[][].class, this);
        this.classRegistry.registerClass(long[].class, this);
        this.classRegistry.registerClass(long[][].class, this);
    }

    public FSTClazzNameRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public FSTClazzInfoRegistry getCLInfoRegistry() {
        return this.serializationInfoRegistry;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public FSTClazzInfo getClassInfo(Class type) {
        return this.serializationInfoRegistry.getCLInfo(type, this);
    }

    public FSTObjectInput getObjectInput(InputStream in) {
        FSTObjectInput fstObjectInput = this.getIn();
        try {
            fstObjectInput.resetForReuse(in);
            return fstObjectInput;
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
            return null;
        }
    }

    public FSTObjectInput getObjectInput() {
        return this.getObjectInput((InputStream)null);
    }

    public FSTObjectInput getObjectInput(byte[] arr) {
        return this.getObjectInput(arr, arr.length);
    }

    public FSTObjectInput getObjectInput(byte[] arr, int len) {
        FSTObjectInput fstObjectInput = this.getIn();
        try {
            fstObjectInput.resetForReuseUseArray(arr, len);
            return fstObjectInput;
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
            return null;
        }
    }

    public FSTObjectInput getObjectInputCopyFrom(byte[] arr, int off, int len) {
        FSTObjectInput fstObjectInput = this.getIn();
        try {
            fstObjectInput.resetForReuseCopyArray(arr, off, len);
            return fstObjectInput;
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
            return null;
        }
    }

    protected FSTObjectInput getIn() {
        FSTObjectInput fstObjectInput = (FSTObjectInput)this.streamCoderFactory.getInput().get();
        if (fstObjectInput == null) {
            this.streamCoderFactory.getInput().set(new FSTObjectInput(this));
            return this.getIn();
        }
        fstObjectInput.conf = this;
        fstObjectInput.getCodec().setConf(this);
        return fstObjectInput;
    }

    protected FSTObjectOutput getOut() {
        FSTObjectOutput fstOut = (FSTObjectOutput)this.streamCoderFactory.getOutput().get();
        if (fstOut == null || fstOut.closed) {
            this.streamCoderFactory.getOutput().set(new FSTObjectOutput(this));
            return this.getOut();
        }
        fstOut.conf = this;
        fstOut.getCodec().setConf(this);
        return fstOut;
    }

    public FSTObjectOutput getObjectOutput(OutputStream out) {
        FSTObjectOutput fstObjectOutput = this.getOut();
        fstObjectOutput.resetForReUse(out);
        return fstObjectOutput;
    }

    public FSTObjectOutput getObjectOutput() {
        return this.getObjectOutput((OutputStream)null);
    }

    public FSTObjectOutput getObjectOutput(byte[] outByte) {
        FSTObjectOutput fstObjectOutput = this.getOut();
        fstObjectOutput.resetForReUse(outByte);
        return fstObjectOutput;
    }

    public void setStructMode(boolean ignoreSerialInterfaces) {
        this.serializationInfoRegistry.setStructMode(ignoreSerialInterfaces);
    }

    public boolean isStructMode() {
        return this.serializationInfoRegistry.isStructMode();
    }

    public FSTClazzInfo getClazzInfo(Class rowClass) {
        return this.getCLInfoRegistry().getCLInfo(rowClass, this);
    }

    public void setCrossPlatform(boolean crossPlatform) {
        this.crossPlatform = crossPlatform;
    }

    public boolean isCrossPlatform() {
        return this.crossPlatform;
    }

    public <T> T deepCopy(T metadata) {
        return (T)this.asObject(this.asByteArray(metadata));
    }

    public FSTEncoder createStreamEncoder() {
        return this.streamCoderFactory.createStreamEncoder();
    }

    public FSTDecoder createStreamDecoder() {
        return this.streamCoderFactory.createStreamDecoder();
    }

    public void registerCrossPlatformClassBinaryCache(String fulLQName, byte[] binary) {
        try {
            while (this.cplock.compareAndSet(false, true)) {
            }
            this.minBinNamesBytez.put(fulLQName, binary);
        }
        finally {
            this.cplock.set(false);
        }
    }

    public byte[] getCrossPlatformBinaryCache(String symbolicName) {
        try {
            while (this.cplock.compareAndSet(false, true)) {
            }
            byte[] byArray = this.minBinNamesBytez.get(symbolicName);
            return byArray;
        }
        finally {
            this.cplock.set(false);
        }
    }

    public FSTConfiguration registerCrossPlatformClassMapping(String[][] keysAndVals) {
        for (int i = 0; i < keysAndVals.length; ++i) {
            String[] keysAndVal = keysAndVals[i];
            this.registerCrossPlatformClassMapping(keysAndVal[0], keysAndVal[1]);
        }
        return this;
    }

    public FSTConfiguration registerCrossPlatformClassMapping(String shortName, String fqName) {
        this.minbinNames.put(shortName, fqName);
        this.minbinNamesReverse.put(fqName, shortName);
        return this;
    }

    public FSTConfiguration cpMap(String shortName, Class clz) {
        return this.registerCrossPlatformClassMapping(shortName, clz.getName());
    }

    public FSTConfiguration registerCrossPlatformClassMappingUseSimpleName(Class ... classes) {
        this.registerCrossPlatformClassMappingUseSimpleName(Arrays.asList(classes));
        return this;
    }

    public FSTConfiguration registerCrossPlatformClassMappingUseSimpleName(List<Class> classes) {
        for (int i = 0; i < classes.size(); ++i) {
            Class clz = classes.get(i);
            this.minbinNames.put(clz.getSimpleName(), clz.getName());
            this.minbinNamesReverse.put(clz.getName(), clz.getSimpleName());
            try {
                if (clz.isArray()) continue;
                Class<?> ac = Class.forName("[L" + clz.getName() + ";");
                this.minbinNames.put(clz.getSimpleName() + "[]", ac.getName());
                this.minbinNamesReverse.put(ac.getName(), clz.getSimpleName() + "[]");
                continue;
            }
            catch (ClassNotFoundException e) {
                FSTUtil.rethrow(e);
            }
        }
        return this;
    }

    public String getCPNameForClass(Class cl) {
        String res = this.minbinNamesReverse.get(cl.getName());
        if (res == null) {
            if (cl.isAnonymousClass()) {
                return this.getCPNameForClass(cl.getSuperclass());
            }
            return cl.getName();
        }
        return res;
    }

    public String getClassForCPName(String name) {
        String res = this.minbinNames.get(name);
        if (res == null) {
            return name;
        }
        return res;
    }

    public Object asObject(byte[] b) {
        try {
            return this.getObjectInput(b).readObject();
        }
        catch (Exception e) {
            System.out.println("unable to decode:" + new String(b, 0, 0, Math.min(b.length, 100)));
            try {
                String string = new String(b, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                this.getObjectInput(b).readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
            FSTUtil.rethrow(e);
            return null;
        }
    }

    public byte[] asByteArray(Object object) {
        FSTObjectOutput objectOutput = this.getObjectOutput();
        try {
            objectOutput.writeObject(object);
            return objectOutput.getCopyOfWrittenBuffer();
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
            return null;
        }
    }

    public byte[] asSharedByteArray(Object object, int[] length) {
        FSTObjectOutput objectOutput = this.getObjectOutput();
        try {
            objectOutput.writeObject(object);
            length[0] = objectOutput.getWritten();
            return objectOutput.getBuffer();
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
            return null;
        }
    }

    public String asJsonString(Object o) {
        if (!(this.getCoderSpecific() instanceof JsonFactory)) {
            return "can be called on JsonConfiguration only";
        }
        try {
            return new String(this.asByteArray(o), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            FSTUtil.rethrow(e);
            return null;
        }
    }

    public void encodeToStream(OutputStream out, Object toSerialize) throws IOException {
        FSTObjectOutput objectOutput = this.getObjectOutput();
        objectOutput.writeObject(toSerialize);
        int written = objectOutput.getWritten();
        out.write(written >>> 0 & 0xFF);
        out.write(written >>> 8 & 0xFF);
        out.write(written >>> 16 & 0xFF);
        out.write(written >>> 24 & 0xFF);
        out.write(objectOutput.getBuffer(), 0, written);
        objectOutput.flush();
    }

    public Object decodeFromStream(InputStream in) throws Exception {
        int read = in.read();
        if (read < 0) {
            throw new EOFException("stream is closed");
        }
        int ch1 = read + 256 & 0xFF;
        int ch2 = in.read() + 256 & 0xFF;
        int ch3 = in.read() + 256 & 0xFF;
        int ch4 = in.read() + 256 & 0xFF;
        int len = (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
        if (len <= 0) {
            throw new EOFException("stream is corrupted");
        }
        byte[] buffer = new byte[len];
        while (len > 0) {
            len -= in.read(buffer, buffer.length - len, len);
        }
        return this.getObjectInput(buffer).readObject();
    }

    public FSTConfiguration deriveConfiguration() {
        if (this.fieldInfoCache == null) {
            this.fieldInfoCache = new ConcurrentHashMap();
        }
        FSTConfiguration derived = FSTConfiguration.createConfiguration(this.type, this.shareReferences, this.fieldInfoCache);
        derived.fieldInfoCache = this.fieldInfoCache;
        derived.minbinNames = this.minbinNames;
        derived.minBinNamesBytez = this.minBinNamesBytez;
        derived.minbinNamesReverse = this.minbinNamesReverse;
        return derived;
    }

    public String toString() {
        return "FSTConfiguration{name='" + this.name + '\'' + '}';
    }

    protected static class FBinaryStreamCoderFactory
    implements StreamCoderFactory {
        protected final FSTConfiguration conf;
        static ThreadLocal input = new ThreadLocal();
        static ThreadLocal output = new ThreadLocal();

        public FBinaryStreamCoderFactory(FSTConfiguration conf) {
            this.conf = conf;
        }

        @Override
        public FSTEncoder createStreamEncoder() {
            return new FSTBytezEncoder(this.conf, new HeapBytez(new byte[4096]));
        }

        @Override
        public FSTDecoder createStreamDecoder() {
            return new FSTBytezDecoder(this.conf);
        }

        @Override
        public ThreadLocal getInput() {
            return input;
        }

        @Override
        public ThreadLocal getOutput() {
            return output;
        }
    }

    protected static class JSonStreamCoderFactory
    implements StreamCoderFactory {
        protected final FSTConfiguration conf;
        static ThreadLocal input = new ThreadLocal();
        static ThreadLocal output = new ThreadLocal();

        public JSonStreamCoderFactory(FSTConfiguration conf) {
            this.conf = conf;
        }

        @Override
        public FSTEncoder createStreamEncoder() {
            return new FSTJsonEncoder(this.conf);
        }

        @Override
        public FSTDecoder createStreamDecoder() {
            return new FSTJsonDecoder(this.conf);
        }

        @Override
        public ThreadLocal getInput() {
            return input;
        }

        @Override
        public ThreadLocal getOutput() {
            return output;
        }
    }

    protected static class FSTDefaultStreamCoderFactory
    implements StreamCoderFactory {
        private FSTConfiguration fstConfiguration;
        static ThreadLocal input = new ThreadLocal();
        static ThreadLocal output = new ThreadLocal();

        public FSTDefaultStreamCoderFactory(FSTConfiguration fstConfiguration) {
            this.fstConfiguration = fstConfiguration;
        }

        @Override
        public FSTEncoder createStreamEncoder() {
            return new FSTStreamEncoder(this.fstConfiguration);
        }

        @Override
        public FSTDecoder createStreamDecoder() {
            return new FSTStreamDecoder(this.fstConfiguration);
        }

        @Override
        public ThreadLocal getInput() {
            return input;
        }

        @Override
        public ThreadLocal getOutput() {
            return output;
        }
    }

    protected static class MinBinStreamCoderFactory
    implements StreamCoderFactory {
        private final FSTConfiguration conf;
        static ThreadLocal input = new ThreadLocal();
        static ThreadLocal output = new ThreadLocal();

        public MinBinStreamCoderFactory(FSTConfiguration conf) {
            this.conf = conf;
        }

        @Override
        public FSTEncoder createStreamEncoder() {
            return new FSTMinBinEncoder(this.conf);
        }

        @Override
        public FSTDecoder createStreamDecoder() {
            return new FSTMinBinDecoder(this.conf);
        }

        @Override
        public ThreadLocal getInput() {
            return input;
        }

        @Override
        public ThreadLocal getOutput() {
            return output;
        }
    }

    public static interface StreamCoderFactory {
        public FSTEncoder createStreamEncoder();

        public FSTDecoder createStreamDecoder();

        public ThreadLocal getInput();

        public ThreadLocal getOutput();
    }

    public static class JacksonAccessWorkaround
    extends UTF8JsonGenerator {
        public JacksonAccessWorkaround(IOContext ctxt, int features, ObjectCodec codec, OutputStream out) {
            super(ctxt, features, codec, out);
        }

        public JacksonAccessWorkaround(IOContext ctxt, int features, ObjectCodec codec, OutputStream out, byte[] outputBuffer, int outputOffset, boolean bufferRecyclable) {
            super(ctxt, features, codec, out, outputBuffer, outputOffset, bufferRecyclable);
        }

        public int getOutputTail() {
            return this._outputTail;
        }
    }

    static class FieldKey {
        Class clazz;
        String fieldName;

        public FieldKey(Class clazz, String fieldName) {
            this.clazz = clazz;
            this.fieldName = fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldKey fieldKey = (FieldKey)o;
            if (!this.clazz.equals(fieldKey.clazz)) {
                return false;
            }
            return this.fieldName.equals(fieldKey.fieldName);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.fieldName.hashCode();
            return result;
        }
    }

    public static interface ClassSecurityVerifier {
        public boolean allowClassDeserialization(Class var1);
    }

    public static interface LastResortClassRessolver {
        public Class getClass(String var1);
    }

    static enum ConfType {
        DEFAULT,
        UNSAFE,
        MINBIN,
        JSON,
        JSONPRETTY;

    }
}

