/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.terracotta.statistics.extended;

import io.hops.hadoop.shaded.org.terracotta.statistics.ValueStatistic;
import io.hops.hadoop.shaded.org.terracotta.statistics.archive.StatisticArchive;
import io.hops.hadoop.shaded.org.terracotta.statistics.archive.StatisticSampler;
import io.hops.hadoop.shaded.org.terracotta.statistics.archive.Timestamped;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class StatisticHistory<T extends Number> {
    private final StatisticSampler<T> sampler;
    private final StatisticArchive<T> history;

    public StatisticHistory(ValueStatistic<T> statistic, ScheduledExecutorService executor, int historySize, long period, TimeUnit periodTimeUnit) {
        this.history = new StatisticArchive(historySize);
        this.sampler = new StatisticSampler<T>(executor, period, periodTimeUnit, statistic, this.history);
    }

    public void startSampling() {
        this.sampler.start();
    }

    public void stopSampling() {
        this.sampler.stop();
        this.history.clear();
    }

    public List<Timestamped<T>> history() {
        return this.history.getArchive();
    }

    public List<Timestamped<T>> history(long since) {
        return this.history.getArchive(since);
    }

    void adjust(int historySize, long historyPeriod, TimeUnit historyTimeUnit) {
        this.history.setCapacity(historySize);
        this.sampler.setPeriod(historyPeriod, historyTimeUnit);
    }
}

