/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTimeoutTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(SessionTimeoutTest.class);
    private TestableZooKeeper zk;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
    }

    @Test
    public void testSessionExpiration() throws InterruptedException, KeeperException {
        CountDownLatch expirationLatch = new CountDownLatch(1);
        Watcher watcher = event -> {
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                expirationLatch.countDown();
            }
        };
        this.zk.exists("/foo", watcher);
        this.zk.getTestable().injectSessionExpiration();
        Assert.assertTrue((boolean)expirationLatch.await(5L, TimeUnit.SECONDS));
        boolean gotException = false;
        try {
            this.zk.exists("/foo", false);
            Assert.fail((String)"Should have thrown a SessionExpiredException");
        }
        catch (KeeperException.SessionExpiredException e) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
    }

    @Test
    public void testQueueEvent() throws InterruptedException, KeeperException {
        CountDownLatch eventLatch = new CountDownLatch(1);
        Watcher watcher = event -> {
            if (event.getType() == Watcher.Event.EventType.NodeDataChanged && event.getPath().equals("/foo/bar")) {
                eventLatch.countDown();
            }
        };
        this.zk.exists("/foo/bar", watcher);
        WatchedEvent event2 = new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, "/foo/bar");
        this.zk.getTestable().queueEvent(event2);
        Assert.assertTrue((boolean)eventLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testSessionDisconnect() throws KeeperException, InterruptedException, IOException {
        this.zk.create("/sdisconnect", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assert.assertNotNull((String)"Ephemeral node has not been created", (Object)this.zk.exists("/sdisconnect", null));
        this.zk.close();
        this.zk = this.createClient();
        Assert.assertNull((String)"Ephemeral node shouldn't exist after client disconnect", (Object)this.zk.exists("/sdisconnect", null));
    }

    @Test
    public void testSessionRestore() throws KeeperException, InterruptedException, IOException {
        this.zk.create("/srestore", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assert.assertNotNull((String)"Ephemeral node has not been created", (Object)this.zk.exists("/srestore", null));
        this.zk.disconnect();
        this.zk.close();
        this.zk = this.createClient();
        Assert.assertNotNull((String)"Ephemeral node should be present when session is restored", (Object)this.zk.exists("/srestore", null));
    }

    @Test
    public void testSessionSurviveServerRestart() throws Exception {
        this.zk.create("/sdeath", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assert.assertNotNull((String)"Ephemeral node has not been created", (Object)this.zk.exists("/sdeath", null));
        this.zk.disconnect();
        this.stopServer();
        this.startServer();
        this.zk = this.createClient();
        Assert.assertNotNull((String)"Ephemeral node should be present when server restarted", (Object)this.zk.exists("/sdeath", null));
    }
}

