/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher;

import io.hops.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.service.launcher.LauncherExitCodes;
import org.apache.hadoop.service.launcher.ServiceLaunchException;
import org.apache.hadoop.service.launcher.ServiceLauncher;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitCodeProvider;
import org.apache.hadoop.util.ExitUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractServiceLauncherTestBase
extends Assert
implements LauncherExitCodes {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServiceLauncherTestBase.class);
    public static final String CONF_FILE_DIR = "target/launcher/conf";
    private Service serviceToTeardown;
    @Rule
    public Timeout testTimeout = new Timeout(15000);
    @Rule
    public TestName methodName = new TestName();

    @BeforeClass
    public static void disableJVMExits() {
        ExitUtil.disableSystemExit();
        ExitUtil.disableSystemHalt();
    }

    @Before
    public void nameThread() {
        Thread.currentThread().setName("JUnit");
    }

    @After
    public void stopService() {
        ServiceOperations.stopQuietly((Service)this.serviceToTeardown);
    }

    public void setServiceToTeardown(Service serviceToTeardown) {
        this.serviceToTeardown = serviceToTeardown;
    }

    protected void assertInState(Service service, Service.STATE expected) {
        AbstractServiceLauncherTestBase.assertNotNull((Object)service);
        Service.STATE actual = service.getServiceState();
        GenericTestUtils.failif(actual != expected, "Service %s in state %s expected state: %s", service.getName(), actual, expected);
    }

    protected void assertStopped(Service service) {
        this.assertInState(service, Service.STATE.STOPPED);
    }

    protected void assertExceptionDetails(int expected, String text, ExitCodeProvider e) {
        AbstractServiceLauncherTestBase.assertNotNull((Object)e);
        String toString = e.toString();
        int exitCode = e.getExitCode();
        boolean failed = expected != exitCode;
        GenericTestUtils.failif(failed |= StringUtils.isNotEmpty((CharSequence)text) && !StringUtils.contains((CharSequence)toString, (CharSequence)text), "Expected exception with exit code %d and text \"%s\" but got the exit code %d in \"%s\"", expected, text, exitCode, e);
    }

    protected void assertServiceCreationFails(String classname) {
        this.assertLaunchOutcome(56, "", classname);
    }

    protected void assertLaunchOutcome(int expected, String text, String ... args) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Launching service with expected outcome {}", (Object)expected);
                for (String arg : args) {
                    LOG.debug(arg);
                }
            }
            ServiceLauncher.serviceMain((String[])args);
        }
        catch (ServiceLaunchException e) {
            this.assertExceptionDetails(expected, text, (ExitCodeProvider)e);
        }
    }

    protected void assertRuns(String ... args) {
        this.assertLaunchOutcome(0, "", args);
    }

    protected <S extends Service> S run(S service) {
        AbstractServiceLauncherTestBase.assertNotNull(service);
        service.init(new Configuration());
        service.start();
        return service;
    }

    protected String configFile(Configuration conf) throws IOException {
        File directory = new File(CONF_FILE_DIR);
        directory.mkdirs();
        File file = File.createTempFile("conf", ".xml", directory);
        try (FileOutputStream fos = new FileOutputStream(file);){
            conf.writeXml((OutputStream)fos);
        }
        return file.getAbsolutePath();
    }

    protected Configuration newConf(String ... kvp) {
        int len = kvp.length;
        AbstractServiceLauncherTestBase.assertEquals((String)("unbalanced keypair len of " + len), (long)0L, (long)(len % 2));
        Configuration conf = new Configuration(false);
        for (int i = 0; i < len; i += 2) {
            conf.set(kvp[i], kvp[i + 1]);
        }
        return conf;
    }

    protected List<String> asList(String ... args) {
        return Arrays.asList(args);
    }

    protected <S extends Service> ServiceLauncher<S> launchService(Class serviceClass, Configuration conf, List<String> args, boolean execute) throws ExitUtil.ExitException {
        ServiceLauncher serviceLauncher = new ServiceLauncher(serviceClass.getName());
        ExitUtil.ExitException exitException = serviceLauncher.launchService(conf, args, false, execute);
        if (exitException.getExitCode() == 0) {
            return serviceLauncher;
        }
        throw exitException;
    }

    protected <S extends Service> ServiceLauncher<S> launchService(Class serviceClass, Configuration conf, String ... args) throws ExitUtil.ExitException {
        return this.launchService(serviceClass, conf, Arrays.asList(args), false);
    }

    protected ExitUtil.ExitException launchExpectingException(Class serviceClass, Configuration conf, String expectedText, int errorCode, String ... args) {
        try {
            ServiceLauncher launch = this.launchService(serviceClass, conf, Arrays.asList(args), true);
            GenericTestUtils.failf("Expected an exception with error code %d and text \"%s\"  -but the service completed with :%s", new Object[]{errorCode, expectedText, launch.getServiceException()});
            return null;
        }
        catch (ExitUtil.ExitException e) {
            int actualCode = e.getExitCode();
            boolean condition = errorCode != actualCode || !StringUtils.contains((CharSequence)e.toString(), (CharSequence)expectedText);
            GenericTestUtils.failif(condition, "Expected an exception with error code %d and text \"%s\"  -but the service threw an exception with exit code %d: %s", new Object[]{errorCode, expectedText, actualCode, e});
            return e;
        }
    }
}

