/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import com.google.common.annotations.VisibleForTesting;
import io.hops.hadoop.shaded.org.fusesource.leveldbjni.JniDBFactory;
import io.hops.hadoop.shaded.org.fusesource.leveldbjni.internal.NativeDB;
import io.hops.hadoop.shaded.org.iq80.leveldb.DB;
import io.hops.hadoop.shaded.org.iq80.leveldb.DBComparator;
import io.hops.hadoop.shaded.org.iq80.leveldb.DBException;
import io.hops.hadoop.shaded.org.iq80.leveldb.DBIterator;
import io.hops.hadoop.shaded.org.iq80.leveldb.Options;
import io.hops.hadoop.shaded.org.iq80.leveldb.WriteBatch;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;

public class LeveldbConfigurationStore
extends YarnConfigurationStore {
    public static final Log LOG = LogFactory.getLog(LeveldbConfigurationStore.class);
    private static final String DB_NAME = "yarn-conf-store";
    private static final String LOG_KEY = "log";
    private static final String VERSION_KEY = "version";
    private DB db;
    private long maxLogs;
    private Configuration conf;
    private YarnConfigurationStore.LogMutation pendingMutation;
    @VisibleForTesting
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance(0, 1);
    private Timer compactionTimer;
    private long compactionIntervalMsec;

    @Override
    public void initialize(Configuration config, Configuration schedConf, RMContext rmContext) throws IOException {
        this.conf = config;
        try {
            this.initDatabase(schedConf);
            this.maxLogs = config.getLong("yarn.scheduler.configuration.store.max-logs", 1000L);
            this.compactionIntervalMsec = config.getLong("yarn.scheduler.configuration.leveldb-store.compaction-interval-secs", 86400L) * 1000L;
            this.startCompactionTimer();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void initDatabase(Configuration config) throws Exception {
        Path storeRoot = this.createStorageDir();
        Options options = new Options();
        options.createIfMissing(false);
        options.comparator(new DBComparator(){

            public int compare(byte[] key1, byte[] key2) {
                String key1Str = new String(key1, StandardCharsets.UTF_8);
                String key2Str = new String(key2, StandardCharsets.UTF_8);
                if (key1Str.equals(key2Str)) {
                    return 0;
                }
                if (key1Str.equals(LeveldbConfigurationStore.VERSION_KEY)) {
                    return 1;
                }
                if (key2Str.equals(LeveldbConfigurationStore.VERSION_KEY)) {
                    return -1;
                }
                if (key1Str.equals(LeveldbConfigurationStore.LOG_KEY)) {
                    return 1;
                }
                if (key2Str.equals(LeveldbConfigurationStore.LOG_KEY)) {
                    return -1;
                }
                return key1Str.compareTo(key2Str);
            }

            public String name() {
                return "keyComparator";
            }

            public byte[] findShortestSeparator(byte[] start, byte[] limit) {
                return start;
            }

            public byte[] findShortSuccessor(byte[] key) {
                return key;
            }
        });
        LOG.info((Object)("Using conf database at " + storeRoot));
        File dbfile = new File(storeRoot.toString());
        try {
            this.db = JniDBFactory.factory.open(dbfile, options);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                LOG.info((Object)("Creating conf database at " + dbfile));
                options.createIfMissing(true);
                try {
                    this.db = JniDBFactory.factory.open(dbfile, options);
                    WriteBatch initBatch = this.db.createWriteBatch();
                    for (Map.Entry kv : config) {
                        initBatch.put(JniDBFactory.bytes((String)((String)kv.getKey())), JniDBFactory.bytes((String)((String)kv.getValue())));
                    }
                    this.db.write(initBatch);
                }
                catch (DBException dbErr) {
                    throw new IOException(dbErr.getMessage(), dbErr);
                }
            }
            throw e;
        }
    }

    private Path createStorageDir() throws IOException {
        Path root = this.getStorageDir();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        fs.mkdirs(root, new FsPermission(448));
        return root;
    }

    private Path getStorageDir() throws IOException {
        String storePath = this.conf.get("yarn.scheduler.configuration.leveldb-store.path");
        if (storePath == null) {
            throw new IOException("No store location directory configured in yarn.scheduler.configuration.leveldb-store.path");
        }
        return new Path(storePath, DB_NAME);
    }

    @Override
    public void close() throws IOException {
        if (this.db != null) {
            this.db.close();
        }
    }

    @Override
    public void logMutation(YarnConfigurationStore.LogMutation logMutation) throws IOException {
        LinkedList<YarnConfigurationStore.LogMutation> logs = this.deserLogMutations(this.db.get(JniDBFactory.bytes((String)LOG_KEY)));
        logs.add(logMutation);
        if ((long)logs.size() > this.maxLogs) {
            logs.removeFirst();
        }
        this.db.put(JniDBFactory.bytes((String)LOG_KEY), this.serLogMutations(logs));
        this.pendingMutation = logMutation;
    }

    @Override
    public void confirmMutation(boolean isValid) throws IOException {
        WriteBatch updateBatch = this.db.createWriteBatch();
        if (isValid) {
            for (Map.Entry<String, String> changes : this.pendingMutation.getUpdates().entrySet()) {
                if (changes.getValue() == null || changes.getValue().isEmpty()) {
                    updateBatch.delete(JniDBFactory.bytes((String)changes.getKey()));
                    continue;
                }
                updateBatch.put(JniDBFactory.bytes((String)changes.getKey()), JniDBFactory.bytes((String)changes.getValue()));
            }
        }
        this.db.write(updateBatch);
        this.pendingMutation = null;
    }

    private byte[] serLogMutations(LinkedList<YarnConfigurationStore.LogMutation> mutations) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(mutations);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LinkedList<YarnConfigurationStore.LogMutation> deserLogMutations(byte[] mutations) throws IOException {
        if (mutations == null) {
            return new LinkedList<YarnConfigurationStore.LogMutation>();
        }
        try (ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(mutations));){
            LinkedList linkedList = (LinkedList)input.readObject();
            return linkedList;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public synchronized Configuration retrieve() {
        DBIterator itr = this.db.iterator();
        itr.seekToFirst();
        Configuration config = new Configuration(false);
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            String key = new String((byte[])entry.getKey(), StandardCharsets.UTF_8);
            String value = new String((byte[])entry.getValue(), StandardCharsets.UTF_8);
            if (key.equals(LOG_KEY) || key.equals(VERSION_KEY)) break;
            config.set(key, value);
        }
        return config;
    }

    @Override
    public List<YarnConfigurationStore.LogMutation> getConfirmedConfHistory(long fromId) {
        return null;
    }

    private void startCompactionTimer() {
        if (this.compactionIntervalMsec > 0L) {
            this.compactionTimer = new Timer(this.getClass().getSimpleName() + " compaction timer", true);
            this.compactionTimer.schedule((TimerTask)new CompactionTimerTask(), this.compactionIntervalMsec, this.compactionIntervalMsec);
        }
    }

    @Override
    public Version getConfStoreVersion() throws Exception {
        VersionPBImpl version = null;
        try {
            byte[] data = this.db.get(JniDBFactory.bytes((String)VERSION_KEY));
            if (data != null) {
                version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom(data));
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        return version;
    }

    @VisibleForTesting
    protected LinkedList<YarnConfigurationStore.LogMutation> getLogs() throws Exception {
        return this.deserLogMutations(this.db.get(JniDBFactory.bytes((String)LOG_KEY)));
    }

    @Override
    public void storeVersion() throws Exception {
        String key = VERSION_KEY;
        byte[] data = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        try {
            this.db.put(JniDBFactory.bytes((String)key), data);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    private class CompactionTimerTask
    extends TimerTask {
        private CompactionTimerTask() {
        }

        @Override
        public void run() {
            long start = Time.monotonicNow();
            LOG.info((Object)"Starting full compaction cycle");
            try {
                LeveldbConfigurationStore.this.db.compactRange(null, null);
            }
            catch (DBException e) {
                LOG.error((Object)"Error compacting database", (Throwable)e);
            }
            long duration = Time.monotonicNow() - start;
            LOG.info((Object)("Full compaction cycle completed in " + duration + " msec"));
        }
    }
}

