/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.BaseCGroupsMemoryResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.MemoryResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CGroupsMemoryResourceHandlerImpl
extends BaseCGroupsMemoryResourceHandler
implements MemoryResourceHandler {
    static final String UNDER_OOM = "under_oom 1";

    CGroupsMemoryResourceHandlerImpl(CGroupsHandler cGroupsHandler) {
        super(cGroupsHandler);
    }

    @Override
    void updateHardLimit(String cgroupId, String limit) throws ResourceHandlerException {
        this.cGroupsHandler.updateCGroupParam(MEMORY, cgroupId, CGroupsHandler.MemoryParameters.HARD_LIMIT_BYTES.getName(), limit);
    }

    @Override
    void updateSoftLimit(String cgroupId, String limit) throws ResourceHandlerException {
        this.cGroupsHandler.updateCGroupParam(MEMORY, cgroupId, CGroupsHandler.MemoryParameters.SOFT_LIMIT_BYTES.getName(), limit);
    }

    @Override
    void updateSwappiness(String cgroupId, String value) throws ResourceHandlerException {
        this.cGroupsHandler.updateCGroupParam(MEMORY, cgroupId, CGroupsHandler.MemoryParameters.SWAPPINESS.getName(), value);
    }

    @Override
    String getOOMStatus(String cgroupId) throws ResourceHandlerException {
        return this.cGroupsHandler.getCGroupParam(CGroupsHandler.CGroupController.MEMORY, cgroupId, CGroupsHandler.MemoryParameters.OOM_CONTROL.getName());
    }

    @Override
    boolean parseOOMStatus(String status) {
        return status.contains(UNDER_OOM);
    }
}

