/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.executor;

import io.hops.hadoop.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ContainerSignalContext {
    private final Container container;
    private final String user;
    private final String pid;
    private final ContainerExecutor.Signal signal;

    private ContainerSignalContext(Builder builder) {
        this.container = builder.container;
        this.user = builder.user;
        this.pid = builder.pid;
        this.signal = builder.signal;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getUser() {
        return this.user;
    }

    public String getPid() {
        return this.pid;
    }

    public ContainerExecutor.Signal getSignal() {
        return this.signal;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContainerSignalContext) {
            ContainerSignalContext other = (ContainerSignalContext)obj;
            boolean ret = other.getPid() == null && this.getPid() == null || other.getPid() != null && this.getPid() != null && other.getPid().equals(this.getPid());
            ret = ret && other.getSignal() == null && this.getSignal() == null || other.getSignal() != null && this.getSignal() != null && other.getSignal().equals((Object)this.getSignal());
            ret = ret && other.getContainer() == null && this.getContainer() == null || other.getContainer() != null && this.getContainer() != null && other.getContainer().equals(this.getContainer());
            ret = ret && other.getUser() == null && this.getUser() == null || other.getUser() != null && this.getUser() != null && other.getUser().equals(this.getUser());
            return ret;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getPid()).append((Object)this.getSignal()).append((Object)this.getContainer()).append((Object)this.getUser()).toHashCode();
    }

    public static final class Builder {
        private Container container;
        private String user;
        private String pid;
        private ContainerExecutor.Signal signal;

        public Builder setContainer(Container container) {
            this.container = container;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setPid(String pid) {
            this.pid = pid;
            return this;
        }

        public Builder setSignal(ContainerExecutor.Signal signal) {
            this.signal = signal;
            return this;
        }

        public ContainerSignalContext build() {
            return new ContainerSignalContext(this);
        }
    }
}

