/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.google.inject.servlet;

import com.google.common.collect.Iterators;
import io.hops.hadoop.shaded.com.google.inject.Injector;
import io.hops.hadoop.shaded.com.google.inject.Key;
import io.hops.hadoop.shaded.com.google.inject.Scopes;
import io.hops.hadoop.shaded.com.google.inject.servlet.InstanceFilterBindingImpl;
import io.hops.hadoop.shaded.com.google.inject.servlet.LinkedFilterBindingImpl;
import io.hops.hadoop.shaded.com.google.inject.servlet.ServletModuleTargetVisitor;
import io.hops.hadoop.shaded.com.google.inject.servlet.ServletUtils;
import io.hops.hadoop.shaded.com.google.inject.servlet.UriPatternMatcher;
import io.hops.hadoop.shaded.com.google.inject.spi.BindingTargetVisitor;
import io.hops.hadoop.shaded.com.google.inject.spi.ProviderInstanceBinding;
import io.hops.hadoop.shaded.com.google.inject.spi.ProviderWithExtensionVisitor;
import io.hops.hadoop.shaded.javax.servlet.Filter;
import io.hops.hadoop.shaded.javax.servlet.FilterConfig;
import io.hops.hadoop.shaded.javax.servlet.ServletContext;
import io.hops.hadoop.shaded.javax.servlet.ServletException;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

class FilterDefinition
implements ProviderWithExtensionVisitor<FilterDefinition> {
    private final String pattern;
    private final Key<? extends Filter> filterKey;
    private final UriPatternMatcher patternMatcher;
    private final Map<String, String> initParams;
    private final Filter filterInstance;
    private final AtomicReference<Filter> filter = new AtomicReference();

    public FilterDefinition(String pattern, Key<? extends Filter> filterKey, UriPatternMatcher patternMatcher, Map<String, String> initParams, Filter filterInstance) {
        this.pattern = pattern;
        this.filterKey = filterKey;
        this.patternMatcher = patternMatcher;
        this.initParams = Collections.unmodifiableMap(new HashMap<String, String>(initParams));
        this.filterInstance = filterInstance;
    }

    @Override
    public FilterDefinition get() {
        return this;
    }

    @Override
    public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> visitor, ProviderInstanceBinding<? extends B> binding) {
        if (visitor instanceof ServletModuleTargetVisitor) {
            if (this.filterInstance != null) {
                return ((ServletModuleTargetVisitor)visitor).visit(new InstanceFilterBindingImpl(this.initParams, this.pattern, this.filterInstance, this.patternMatcher));
            }
            return ((ServletModuleTargetVisitor)visitor).visit(new LinkedFilterBindingImpl(this.initParams, this.pattern, this.filterKey, this.patternMatcher));
        }
        return visitor.visit(binding);
    }

    private boolean shouldFilter(String uri) {
        return uri != null && this.patternMatcher.matches(uri);
    }

    public void init(final ServletContext servletContext, Injector injector, Set<Filter> initializedSoFar) throws ServletException {
        if (!Scopes.isSingleton(injector.getBinding(this.filterKey))) {
            String string = String.valueOf(String.valueOf(this.filterKey));
            throw new ServletException(new StringBuilder(71 + string.length()).append("Filters must be bound as singletons. ").append(string).append(" was not bound in singleton scope.").toString());
        }
        Filter filter = injector.getInstance(this.filterKey);
        this.filter.set(filter);
        if (initializedSoFar.contains(filter)) {
            return;
        }
        filter.init(new FilterConfig(){

            public String getFilterName() {
                return FilterDefinition.this.filterKey.toString();
            }

            public ServletContext getServletContext() {
                return servletContext;
            }

            public String getInitParameter(String s) {
                return (String)FilterDefinition.this.initParams.get(s);
            }

            public Enumeration getInitParameterNames() {
                return Iterators.asEnumeration(FilterDefinition.this.initParams.keySet().iterator());
            }
        });
        initializedSoFar.add(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Set<Filter> destroyedSoFar) {
        Filter reference = this.filter.get();
        if (null == reference || destroyedSoFar.contains(reference)) {
            return;
        }
        try {
            reference.destroy();
        }
        finally {
            destroyedSoFar.add(reference);
        }
    }

    public Filter getFilterIfMatching(HttpServletRequest request) {
        String path = ServletUtils.getContextRelativePath(request);
        if (this.shouldFilter(path)) {
            return this.filter.get();
        }
        return null;
    }

    Filter getFilter() {
        return this.filter.get();
    }
}

