/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.cli;

import io.hops.hadoop.shaded.org.apache.commons.cli.CommandLine;
import io.hops.hadoop.shaded.org.apache.commons.cli.Options;
import io.hops.hadoop.shaded.org.apache.commons.cli.ParseException;
import io.hops.hadoop.shaded.org.apache.commons.cli.PosixParser;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliCommand;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliParseException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.CliWrapperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.MalformedCommandException;
import io.hops.hadoop.shaded.org.apache.zookeeper.cli.MalformedPathException;

public class GetAllChildrenNumberCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public GetAllChildrenNumberCommand() {
        super("getAllChildrenNumber", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        PosixParser parser = new PosixParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        if (this.args.length < 2) {
            throw new MalformedCommandException(this.getUsageStr());
        }
        try {
            String path = this.args[1];
            int allChildrenNumber = this.zk.getAllChildrenNumber(path);
            this.out.println(allChildrenNumber);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }
}

