/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class WatcherFuncTest
extends ClientBase {
    private SimpleWatcher client_dwatch;
    private volatile CountDownLatch client_latch;
    private ZooKeeper client;
    private SimpleWatcher lsnr_dwatch;
    private volatile CountDownLatch lsnr_latch;
    private ZooKeeper lsnr;
    private List<Watcher.Event.EventType> expected;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client_latch = new CountDownLatch(1);
        this.client_dwatch = new SimpleWatcher(this.client_latch);
        this.client = this.createClient(this.client_dwatch, this.client_latch);
        this.lsnr_latch = new CountDownLatch(1);
        this.lsnr_dwatch = new SimpleWatcher(this.lsnr_latch);
        this.lsnr = this.createClient(this.lsnr_dwatch, this.lsnr_latch);
        this.expected = new ArrayList<Watcher.Event.EventType>();
    }

    @Override
    public void tearDown() throws Exception {
        this.client.close();
        this.lsnr.close();
        super.tearDown();
    }

    protected ZooKeeper createClient(Watcher watcher, CountDownLatch latch) throws IOException, InterruptedException {
        ZooKeeper zk = new ZooKeeper(this.hostPort, CONNECTION_TIMEOUT, watcher);
        if (!latch.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Unable to connect to server");
        }
        return zk;
    }

    private void verify() throws InterruptedException {
        this.lsnr_dwatch.verify(this.expected);
        this.expected.clear();
    }

    @Test
    public void testExistsSync() throws IOException, InterruptedException, KeeperException {
        Assert.assertNull((Object)this.lsnr.exists("/foo", true));
        Assert.assertNull((Object)this.lsnr.exists("/foo/bar", true));
        this.client.create("/foo", "parent".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.expected.add(Watcher.Event.EventType.NodeCreated);
        this.client.create("/foo/bar", "child".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.expected.add(Watcher.Event.EventType.NodeCreated);
        this.verify();
        Assert.assertNotNull((Object)this.lsnr.exists("/foo", true));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo/bar", true));
        try {
            Assert.assertNull((Object)this.lsnr.exists("/car", true));
            this.client.setData("/car", "missing".getBytes(), -1);
            Assert.fail();
        }
        catch (KeeperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)e.code());
            Assert.assertEquals((Object)"/car", (Object)e.getPath());
        }
        try {
            Assert.assertNull((Object)this.lsnr.exists("/foo/car", true));
            this.client.setData("/foo/car", "missing".getBytes(), -1);
            Assert.fail();
        }
        catch (KeeperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)e.code());
            Assert.assertEquals((Object)"/foo/car", (Object)e.getPath());
        }
        this.client.setData("/foo", "parent".getBytes(), -1);
        this.expected.add(Watcher.Event.EventType.NodeDataChanged);
        this.client.setData("/foo/bar", "child".getBytes(), -1);
        this.expected.add(Watcher.Event.EventType.NodeDataChanged);
        this.verify();
        Assert.assertNotNull((Object)this.lsnr.exists("/foo", true));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo/bar", true));
        this.client.delete("/foo/bar", -1);
        this.expected.add(Watcher.Event.EventType.NodeDeleted);
        this.client.delete("/foo", -1);
        this.expected.add(Watcher.Event.EventType.NodeDeleted);
        this.verify();
    }

    @Test
    public void testGetDataSync() throws IOException, InterruptedException, KeeperException {
        try {
            this.lsnr.getData("/foo", true, null);
            Assert.fail();
        }
        catch (KeeperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)e.code());
            Assert.assertEquals((Object)"/foo", (Object)e.getPath());
        }
        try {
            this.lsnr.getData("/foo/bar", true, null);
            Assert.fail();
        }
        catch (KeeperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)e.code());
            Assert.assertEquals((Object)"/foo/bar", (Object)e.getPath());
        }
        this.client.create("/foo", "parent".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertNotNull((Object)this.lsnr.getData("/foo", true, null));
        this.client.create("/foo/bar", "child".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertNotNull((Object)this.lsnr.getData("/foo/bar", true, null));
        this.client.setData("/foo", "parent".getBytes(), -1);
        this.expected.add(Watcher.Event.EventType.NodeDataChanged);
        this.client.setData("/foo/bar", "child".getBytes(), -1);
        this.expected.add(Watcher.Event.EventType.NodeDataChanged);
        this.verify();
        Assert.assertNotNull((Object)this.lsnr.getData("/foo", true, null));
        Assert.assertNotNull((Object)this.lsnr.getData("/foo/bar", true, null));
        this.client.delete("/foo/bar", -1);
        this.expected.add(Watcher.Event.EventType.NodeDeleted);
        this.client.delete("/foo", -1);
        this.expected.add(Watcher.Event.EventType.NodeDeleted);
        this.verify();
    }

    @Test
    public void testGetChildrenSync() throws IOException, InterruptedException, KeeperException {
        try {
            this.lsnr.getChildren("/foo", true);
            Assert.fail();
        }
        catch (KeeperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)e.code());
            Assert.assertEquals((Object)"/foo", (Object)e.getPath());
        }
        try {
            this.lsnr.getChildren("/foo/bar", true);
            Assert.fail();
        }
        catch (KeeperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)e.code());
            Assert.assertEquals((Object)"/foo/bar", (Object)e.getPath());
        }
        this.client.create("/foo", "parent".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertNotNull(this.lsnr.getChildren("/foo", true));
        this.client.create("/foo/bar", "child".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.expected.add(Watcher.Event.EventType.NodeChildrenChanged);
        Assert.assertNotNull(this.lsnr.getChildren("/foo/bar", true));
        this.client.setData("/foo", "parent".getBytes(), -1);
        this.client.setData("/foo/bar", "child".getBytes(), -1);
        Assert.assertNotNull((Object)this.lsnr.exists("/foo", true));
        Assert.assertNotNull(this.lsnr.getChildren("/foo", true));
        Assert.assertNotNull(this.lsnr.getChildren("/foo/bar", true));
        this.client.delete("/foo/bar", -1);
        this.expected.add(Watcher.Event.EventType.NodeDeleted);
        this.expected.add(Watcher.Event.EventType.NodeChildrenChanged);
        this.client.delete("/foo", -1);
        this.expected.add(Watcher.Event.EventType.NodeDeleted);
        this.verify();
    }

    @Test
    public void testExistsSyncWObj() throws IOException, InterruptedException, KeeperException {
        SimpleWatcher w1 = new SimpleWatcher(null);
        SimpleWatcher w2 = new SimpleWatcher(null);
        SimpleWatcher w3 = new SimpleWatcher(null);
        SimpleWatcher w4 = new SimpleWatcher(null);
        ArrayList<Watcher.Event.EventType> e2 = new ArrayList<Watcher.Event.EventType>();
        Assert.assertNull((Object)this.lsnr.exists("/foo", true));
        Assert.assertNull((Object)this.lsnr.exists("/foo", w1));
        Assert.assertNull((Object)this.lsnr.exists("/foo/bar", w2));
        Assert.assertNull((Object)this.lsnr.exists("/foo/bar", w3));
        Assert.assertNull((Object)this.lsnr.exists("/foo/bar", w3));
        Assert.assertNull((Object)this.lsnr.exists("/foo/bar", w4));
        this.client.create("/foo", "parent".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.expected.add(Watcher.Event.EventType.NodeCreated);
        this.client.create("/foo/bar", "child".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        e2.add(Watcher.Event.EventType.NodeCreated);
        this.lsnr_dwatch.verify(this.expected);
        w1.verify(this.expected);
        w2.verify(e2);
        w3.verify(e2);
        w4.verify(e2);
        this.expected.clear();
        e2.clear();
        Assert.assertNotNull((Object)this.lsnr.exists("/foo", w1));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo/bar", w2));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo/bar", w3));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo/bar", w4));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo/bar", w4));
        this.client.setData("/foo", "parent".getBytes(), -1);
        this.expected.add(Watcher.Event.EventType.NodeDataChanged);
        this.client.setData("/foo/bar", "child".getBytes(), -1);
        e2.add(Watcher.Event.EventType.NodeDataChanged);
        this.lsnr_dwatch.verify(new ArrayList<Watcher.Event.EventType>());
        w1.verify(this.expected);
        w2.verify(e2);
        w3.verify(e2);
        w4.verify(e2);
        this.expected.clear();
        e2.clear();
        Assert.assertNotNull((Object)this.lsnr.exists("/foo", true));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo", w1));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo", w1));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo/bar", w2));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo/bar", w2));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo/bar", w3));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo/bar", w4));
        this.client.delete("/foo/bar", -1);
        this.expected.add(Watcher.Event.EventType.NodeDeleted);
        this.client.delete("/foo", -1);
        e2.add(Watcher.Event.EventType.NodeDeleted);
        this.lsnr_dwatch.verify(this.expected);
        w1.verify(this.expected);
        w2.verify(e2);
        w3.verify(e2);
        w4.verify(e2);
        this.expected.clear();
        e2.clear();
    }

    @Test
    public void testGetDataSyncWObj() throws IOException, InterruptedException, KeeperException {
        SimpleWatcher w1 = new SimpleWatcher(null);
        SimpleWatcher w2 = new SimpleWatcher(null);
        SimpleWatcher w3 = new SimpleWatcher(null);
        SimpleWatcher w4 = new SimpleWatcher(null);
        ArrayList<Watcher.Event.EventType> e2 = new ArrayList<Watcher.Event.EventType>();
        try {
            this.lsnr.getData("/foo", w1, null);
            Assert.fail();
        }
        catch (KeeperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)e.code());
            Assert.assertEquals((Object)"/foo", (Object)e.getPath());
        }
        try {
            this.lsnr.getData("/foo/bar", w2, null);
            Assert.fail();
        }
        catch (KeeperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)e.code());
            Assert.assertEquals((Object)"/foo/bar", (Object)e.getPath());
        }
        this.client.create("/foo", "parent".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertNotNull((Object)this.lsnr.getData("/foo", true, null));
        Assert.assertNotNull((Object)this.lsnr.getData("/foo", w1, null));
        this.client.create("/foo/bar", "child".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertNotNull((Object)this.lsnr.getData("/foo/bar", w2, null));
        Assert.assertNotNull((Object)this.lsnr.getData("/foo/bar", w3, null));
        Assert.assertNotNull((Object)this.lsnr.getData("/foo/bar", w4, null));
        Assert.assertNotNull((Object)this.lsnr.getData("/foo/bar", w4, null));
        this.client.setData("/foo", "parent".getBytes(), -1);
        this.expected.add(Watcher.Event.EventType.NodeDataChanged);
        this.client.setData("/foo/bar", "child".getBytes(), -1);
        e2.add(Watcher.Event.EventType.NodeDataChanged);
        this.lsnr_dwatch.verify(this.expected);
        w1.verify(this.expected);
        w2.verify(e2);
        w3.verify(e2);
        w4.verify(e2);
        this.expected.clear();
        e2.clear();
        Assert.assertNotNull((Object)this.lsnr.getData("/foo", true, null));
        Assert.assertNotNull((Object)this.lsnr.getData("/foo", w1, null));
        Assert.assertNotNull((Object)this.lsnr.getData("/foo/bar", w2, null));
        Assert.assertNotNull((Object)this.lsnr.getData("/foo/bar", w3, null));
        Assert.assertNotNull((Object)this.lsnr.getData("/foo/bar", w3, null));
        Assert.assertNotNull((Object)this.lsnr.getData("/foo/bar", w4, null));
        this.client.delete("/foo/bar", -1);
        this.expected.add(Watcher.Event.EventType.NodeDeleted);
        this.client.delete("/foo", -1);
        e2.add(Watcher.Event.EventType.NodeDeleted);
        this.lsnr_dwatch.verify(this.expected);
        w1.verify(this.expected);
        w2.verify(e2);
        w3.verify(e2);
        w4.verify(e2);
        this.expected.clear();
        e2.clear();
    }

    @Test
    public void testGetChildrenSyncWObj() throws IOException, InterruptedException, KeeperException {
        SimpleWatcher w1 = new SimpleWatcher(null);
        SimpleWatcher w2 = new SimpleWatcher(null);
        SimpleWatcher w3 = new SimpleWatcher(null);
        SimpleWatcher w4 = new SimpleWatcher(null);
        ArrayList<Watcher.Event.EventType> e2 = new ArrayList<Watcher.Event.EventType>();
        try {
            this.lsnr.getChildren("/foo", true);
            Assert.fail();
        }
        catch (KeeperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)e.code());
            Assert.assertEquals((Object)"/foo", (Object)e.getPath());
        }
        try {
            this.lsnr.getChildren("/foo/bar", true);
            Assert.fail();
        }
        catch (KeeperException e) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)e.code());
            Assert.assertEquals((Object)"/foo/bar", (Object)e.getPath());
        }
        this.client.create("/foo", "parent".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertNotNull(this.lsnr.getChildren("/foo", true));
        Assert.assertNotNull(this.lsnr.getChildren("/foo", w1));
        this.client.create("/foo/bar", "child".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.expected.add(Watcher.Event.EventType.NodeChildrenChanged);
        Assert.assertNotNull(this.lsnr.getChildren("/foo/bar", w2));
        Assert.assertNotNull(this.lsnr.getChildren("/foo/bar", w2));
        Assert.assertNotNull(this.lsnr.getChildren("/foo/bar", w3));
        Assert.assertNotNull(this.lsnr.getChildren("/foo/bar", w4));
        this.client.setData("/foo", "parent".getBytes(), -1);
        this.client.setData("/foo/bar", "child".getBytes(), -1);
        Assert.assertNotNull((Object)this.lsnr.exists("/foo", true));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo", w1));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo", true));
        Assert.assertNotNull((Object)this.lsnr.exists("/foo", w1));
        Assert.assertNotNull(this.lsnr.getChildren("/foo", true));
        Assert.assertNotNull(this.lsnr.getChildren("/foo", w1));
        Assert.assertNotNull(this.lsnr.getChildren("/foo/bar", w2));
        Assert.assertNotNull(this.lsnr.getChildren("/foo/bar", w3));
        Assert.assertNotNull(this.lsnr.getChildren("/foo/bar", w4));
        Assert.assertNotNull(this.lsnr.getChildren("/foo/bar", w4));
        this.client.delete("/foo/bar", -1);
        e2.add(Watcher.Event.EventType.NodeDeleted);
        this.expected.add(Watcher.Event.EventType.NodeChildrenChanged);
        this.client.delete("/foo", -1);
        this.expected.add(Watcher.Event.EventType.NodeDeleted);
        this.lsnr_dwatch.verify(this.expected);
        w1.verify(this.expected);
        w2.verify(e2);
        w3.verify(e2);
        w4.verify(e2);
        this.expected.clear();
        e2.clear();
    }

    private static class SimpleWatcher
    implements Watcher {
        private LinkedBlockingQueue<WatchedEvent> events = new LinkedBlockingQueue();
        private CountDownLatch latch;

        public SimpleWatcher(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected && this.latch != null) {
                this.latch.countDown();
            }
            if (event.getType() == Watcher.Event.EventType.None) {
                return;
            }
            try {
                this.events.put(event);
            }
            catch (InterruptedException e) {
                Assert.assertTrue((String)"interruption unexpected", (boolean)false);
            }
        }

        public void verify(List<Watcher.Event.EventType> expected) throws InterruptedException {
            WatchedEvent event;
            int count;
            for (count = 0; count < expected.size() && (event = this.events.poll(30L, TimeUnit.SECONDS)) != null; ++count) {
                Assert.assertEquals((Object)((Object)expected.get(count)), (Object)((Object)event.getType()));
            }
            Assert.assertEquals((long)expected.size(), (long)count);
            this.events.clear();
        }
    }
}

