/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.startupprogress;

import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;

public class StartupProgressTestHelper {
    public static void incrementCounter(StartupProgress prog, Phase phase, Step step, long delta) {
        StartupProgress.Counter counter = prog.getCounter(phase, step);
        for (long i = 0L; i < delta; ++i) {
            counter.increment();
        }
    }

    public static void setStartupProgressForFinalState(StartupProgress prog) {
        prog.beginPhase(Phase.SAFEMODE);
        Step awaitingBlocks = new Step(StepType.AWAITING_REPORTED_BLOCKS);
        prog.beginStep(Phase.SAFEMODE, awaitingBlocks);
        prog.setTotal(Phase.SAFEMODE, awaitingBlocks, 400L);
        StartupProgressTestHelper.incrementCounter(prog, Phase.SAFEMODE, awaitingBlocks, 400L);
        prog.endStep(Phase.SAFEMODE, awaitingBlocks);
        prog.endPhase(Phase.SAFEMODE);
    }
}

