/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.client;

import io.hops.hadoop.shaded.org.apache.zookeeper.client.ZKClientConfig;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ZKClientConfigTest {
    private static final File testData = new File(System.getProperty("test.data.dir", "src/test/resources/data"));
    @Rule
    public Timeout timeout = new Timeout(10L, TimeUnit.SECONDS);

    @BeforeClass
    public static void init() {
        if (!testData.exists()) {
            testData.mkdirs();
        }
    }

    @Test
    public void testDefaultConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("zookeeper.sasl.client.username", "zookeeper1");
        properties.put("zookeeper.sasl.clientconfig", "Client1");
        properties.put("zookeeper.sasl.client", "true");
        properties.put("zookeeper.server.realm", "zookeeper/hadoop.hadoop.com");
        properties.put("zookeeper.disableAutoWatchReset", "true");
        properties.put("zookeeper.clientCnxnSocket", "ClientCnxnSocketNetty");
        properties.put("zookeeper.client.secure", "true");
        for (Map.Entry e : properties.entrySet()) {
            System.setProperty((String)e.getKey(), (String)e.getValue());
        }
        ZKClientConfig conf = new ZKClientConfig();
        for (Map.Entry e : properties.entrySet()) {
            Assert.assertEquals(e.getValue(), (Object)conf.getProperty((String)e.getKey()));
        }
        for (Map.Entry e : properties.entrySet()) {
            System.clearProperty((String)e.getKey());
        }
        conf = new ZKClientConfig();
        for (Map.Entry e : properties.entrySet()) {
            String result = conf.getProperty((String)e.getKey());
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void testSystemPropertyValue() {
        String clientName = "zookeeper1";
        System.setProperty("zookeeper.sasl.client.username", clientName);
        ZKClientConfig conf = new ZKClientConfig();
        Assert.assertEquals((Object)conf.getProperty("zookeeper.sasl.client.username"), (Object)clientName);
        String newClientName = "zookeeper2";
        conf.setProperty("zookeeper.sasl.client.username", newClientName);
        Assert.assertEquals((Object)conf.getProperty("zookeeper.sasl.client.username"), (Object)newClientName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadConfigurationFile() throws IOException, QuorumPeerConfig.ConfigException {
        File file = File.createTempFile("clientConfig", ".conf", testData);
        file.deleteOnExit();
        Properties clientConfProp = new Properties();
        clientConfProp.setProperty("zookeeper.sasl.client", "true");
        clientConfProp.setProperty("zookeeper.sasl.client.username", "ZK");
        clientConfProp.setProperty("zookeeper.sasl.clientconfig", "MyClient");
        clientConfProp.setProperty("zookeeper.server.realm", "HADOOP.COM");
        clientConfProp.setProperty("dummyProperty", "dummyValue");
        try (FileOutputStream io = new FileOutputStream(file);){
            clientConfProp.store(io, "Client Configurations");
        }
        ZKClientConfig conf = new ZKClientConfig();
        conf.addConfiguration(file.getAbsolutePath());
        Assert.assertEquals((Object)conf.getProperty("zookeeper.sasl.client"), (Object)"true");
        Assert.assertEquals((Object)conf.getProperty("zookeeper.sasl.client.username"), (Object)"ZK");
        Assert.assertEquals((Object)conf.getProperty("zookeeper.sasl.clientconfig"), (Object)"MyClient");
        Assert.assertEquals((Object)conf.getProperty("zookeeper.server.realm"), (Object)"HADOOP.COM");
        Assert.assertEquals((Object)conf.getProperty("dummyProperty"), (Object)"dummyValue");
        file.delete();
    }

    @Test
    public void testSetConfiguration() {
        ZKClientConfig conf = new ZKClientConfig();
        String defaultValue = conf.getProperty("zookeeper.sasl.client", "true");
        if (defaultValue.equals("true")) {
            conf.setProperty("zookeeper.sasl.client", "false");
        } else {
            conf.setProperty("zookeeper.sasl.client", "true");
        }
        Assert.assertTrue((conf.getProperty("zookeeper.sasl.client") != defaultValue ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerRetrievalFromProperty() {
        ZKClientConfig conf = new ZKClientConfig();
        String prop = "UnSetProperty" + System.currentTimeMillis();
        int defaultValue = 100;
        int result = conf.getInt(prop, defaultValue);
        Assert.assertEquals((long)defaultValue, (long)result);
        conf.setProperty("jute.maxbuffer", "InvlaidIntValue123");
        try {
            result = conf.getInt("jute.maxbuffer", defaultValue);
            Assert.fail((String)"NumberFormatException is expected");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Assert.assertEquals((long)defaultValue, (long)result);
        int value = 1048575;
        conf.setProperty("jute.maxbuffer", Integer.toString(value));
        result = conf.getInt("jute.maxbuffer", defaultValue);
        Assert.assertEquals((long)value, (long)result);
        value = 12345;
        conf.setProperty("jute.maxbuffer", " " + value + " ");
        result = conf.getInt("jute.maxbuffer", defaultValue);
        Assert.assertEquals((long)value, (long)result);
    }

    @Test
    public void testIntegerRetrievalFromHexadecimalProperty() {
        int hexaValue = 0x3000000;
        String wrongValue = "0xwel";
        int defaultValue = 100;
        ZKClientConfig zkClientConfig = new ZKClientConfig();
        zkClientConfig.setProperty("jute.maxbuffer", Integer.toString(hexaValue));
        int result = zkClientConfig.getInt("jute.maxbuffer", defaultValue);
        Assert.assertEquals((long)result, (long)hexaValue);
        zkClientConfig.setProperty("jute.maxbuffer", wrongValue);
        try {
            result = zkClientConfig.getInt("jute.maxbuffer", defaultValue);
            Assert.fail((String)"NumberFormatException is expected");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        zkClientConfig.setProperty("jute.maxbuffer", " " + hexaValue + " ");
        result = zkClientConfig.getInt("jute.maxbuffer", defaultValue);
        Assert.assertEquals((long)result, (long)hexaValue);
    }
}

