/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnit4ZKTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(JUnit4ZKTestRunner.class);

    public JUnit4ZKTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public static List<FrameworkMethod> computeTestMethodsForClass(Class klass, List<FrameworkMethod> defaultMethods) {
        List<FrameworkMethod> list = defaultMethods;
        String methodName = System.getProperty("test.method");
        if (methodName == null) {
            LOG.info("No test.method specified. using default methods.");
        } else {
            LOG.info("Picked up test.method={}", (Object)methodName);
            try {
                list = Arrays.asList(new FrameworkMethod(klass.getMethod(methodName, new Class[0])));
            }
            catch (NoSuchMethodException nsme) {
                LOG.warn("{} does not have test.method={}. failing to default methods.", (Object)klass.getName(), (Object)methodName);
            }
        }
        return list;
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return JUnit4ZKTestRunner.computeTestMethodsForClass(this.getTestClass().getJavaClass(), super.computeTestMethods());
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test2) {
        return new LoggedInvokeMethod(method, test2);
    }

    public static class LoggedInvokeMethod
    extends InvokeMethod {
        private final FrameworkMethod method;
        private final String name;

        public LoggedInvokeMethod(FrameworkMethod method, Object target) {
            super(method, target);
            this.method = method;
            this.name = method.getName();
        }

        public void evaluate() throws Throwable {
            LOG.info("RUNNING TEST METHOD {}", (Object)this.name);
            try {
                super.evaluate();
                Runtime rt = Runtime.getRuntime();
                long usedKB = (rt.totalMemory() - rt.freeMemory()) / 1024L;
                LOG.info("Memory used {}", (Object)usedKB);
                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                while (tg.getParent() != null) {
                    tg = tg.getParent();
                }
                LOG.info("Number of threads {}", (Object)tg.activeCount());
            }
            catch (Throwable t) {
                Test annotation = (Test)this.method.getAnnotation(Test.class);
                if (annotation != null && annotation.expected() != null && annotation.expected().isAssignableFrom(t.getClass())) {
                    LOG.info("TEST METHOD {} THREW EXPECTED EXCEPTION {}", (Object)this.name, (Object)annotation.expected());
                } else {
                    LOG.warn("TEST METHOD FAILED {}", (Object)this.name, (Object)t);
                }
                throw t;
            }
            LOG.info("FINISHED TEST METHOD {}", (Object)this.name);
        }
    }
}

