/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.jute.Record;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.ACL;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Id;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.GetACLRequest;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.GetACLResponse;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.ReplyHeader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.DataNode;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.FinalRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.hamcrest.Matcher;
import io.hops.hadoop.shaded.org.hamcrest.Matchers;
import io.hops.hadoop.shaded.org.mockito.ArgumentMatchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import io.hops.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import io.hops.hadoop.shaded.org.mockito.stubbing.Answer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FinalRequestProcessorTest {
    private List<ACL> testACLs = new ArrayList<ACL>();
    private final Record[] responseRecord = new Record[1];
    private final ReplyHeader[] replyHeaders = new ReplyHeader[1];
    private ServerCnxn cnxn;
    private ByteBuffer bb;
    private FinalRequestProcessor processor;

    @Before
    public void setUp() throws KeeperException.NoNodeException, IOException {
        this.testACLs.clear();
        this.testACLs.addAll(Arrays.asList(new ACL(31, new Id("digest", "user:secrethash")), new ACL(16, new Id("digest", "adminuser:adminsecret")), new ACL(1, new Id("world", "anyone"))));
        ZooKeeperServer zks = new ZooKeeperServer();
        ZKDatabase db = Mockito.mock(ZKDatabase.class);
        String testPath = "/testPath";
        Mockito.when(db.getNode((String)ArgumentMatchers.eq((Object)testPath))).thenReturn(new DataNode());
        Mockito.when(db.getACL((String)ArgumentMatchers.eq((Object)testPath), (Stat)ArgumentMatchers.any(Stat.class))).thenReturn(this.testACLs);
        Mockito.when(db.aclForNode((DataNode)ArgumentMatchers.any(DataNode.class))).thenReturn(this.testACLs);
        zks.setZKDatabase(db);
        this.processor = new FinalRequestProcessor(zks);
        this.cnxn = Mockito.mock(ServerCnxn.class);
        Mockito.doAnswer(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) {
                ((FinalRequestProcessorTest)FinalRequestProcessorTest.this).replyHeaders[0] = (ReplyHeader)invocationOnMock.getArgument(0);
                ((FinalRequestProcessorTest)FinalRequestProcessorTest.this).responseRecord[0] = (Record)invocationOnMock.getArgument(1);
                return null;
            }
        }).when(this.cnxn).sendResponse((ReplyHeader)ArgumentMatchers.any(), (Record)ArgumentMatchers.any(), ArgumentMatchers.anyString());
        GetACLRequest getACLRequest = new GetACLRequest();
        getACLRequest.setPath(testPath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        getACLRequest.serialize(boa, "request");
        baos.close();
        this.bb = ByteBuffer.wrap(baos.toByteArray());
    }

    @Test
    public void testACLDigestHashHiding_NoAuth_WorldCanRead() {
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, new ArrayList<Id>());
        this.processor.processRequest(r);
        this.assertMasked(true);
    }

    @Test
    public void testACLDigestHashHiding_NoAuth_NoWorld() {
        this.testACLs.remove(2);
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, new ArrayList<Id>());
        this.processor.processRequest(r);
        Assert.assertThat((Object)KeeperException.Code.get(this.replyHeaders[0].getErr()), (Matcher)Matchers.equalTo((Object)KeeperException.Code.NOAUTH));
    }

    @Test
    public void testACLDigestHashHiding_UserCanRead() {
        ArrayList<Id> authInfo = new ArrayList<Id>();
        authInfo.add(new Id("digest", "otheruser:somesecrethash"));
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, authInfo);
        this.processor.processRequest(r);
        this.assertMasked(true);
    }

    @Test
    public void testACLDigestHashHiding_UserCanAll() {
        ArrayList<Id> authInfo = new ArrayList<Id>();
        authInfo.add(new Id("digest", "user:secrethash"));
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, authInfo);
        this.processor.processRequest(r);
        this.assertMasked(false);
    }

    @Test
    public void testACLDigestHashHiding_AdminUser() {
        ArrayList<Id> authInfo = new ArrayList<Id>();
        authInfo.add(new Id("digest", "adminuser:adminsecret"));
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, authInfo);
        this.processor.processRequest(r);
        this.assertMasked(false);
    }

    @Test
    public void testACLDigestHashHiding_OnlyAdmin() {
        this.testACLs.clear();
        this.testACLs.addAll(Arrays.asList(new ACL(1, new Id("digest", "user:secrethash")), new ACL(16, new Id("digest", "adminuser:adminsecret"))));
        ArrayList<Id> authInfo = new ArrayList<Id>();
        authInfo.add(new Id("digest", "adminuser:adminsecret"));
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, authInfo);
        this.processor.processRequest(r);
        Assert.assertTrue((String)"Not a GetACL response. Auth failed?", (boolean)(this.responseRecord[0] instanceof GetACLResponse));
        GetACLResponse rsp = (GetACLResponse)this.responseRecord[0];
        Assert.assertThat((String)"Number of ACLs in the response are different", (Object)rsp.getAcl().size(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((String)"Password hash mismatch in the response", (Object)rsp.getAcl().get(0).getId().getId(), (Matcher)Matchers.equalTo((Object)"user:secrethash"));
        Assert.assertThat((String)"Password hash mismatch in the response", (Object)rsp.getAcl().get(1).getId().getId(), (Matcher)Matchers.equalTo((Object)"adminuser:adminsecret"));
    }

    private void assertMasked(boolean masked) {
        Assert.assertTrue((String)"Not a GetACL response. Auth failed?", (boolean)(this.responseRecord[0] instanceof GetACLResponse));
        GetACLResponse rsp = (GetACLResponse)this.responseRecord[0];
        Assert.assertThat((String)"Number of ACLs in the response are different", (Object)rsp.getAcl().size(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((String)"Invalid ACL list in the response", (Object)rsp.getAcl().get(0).getPerms(), (Matcher)Matchers.equalTo((Object)31));
        Assert.assertThat((String)"Invalid ACL list in the response", (Object)rsp.getAcl().get(0).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"digest"));
        if (masked) {
            Assert.assertThat((String)"Password hash is not masked in the response", (Object)rsp.getAcl().get(0).getId().getId(), (Matcher)Matchers.equalTo((Object)"user:x"));
        } else {
            Assert.assertThat((String)"Password hash mismatch in the response", (Object)rsp.getAcl().get(0).getId().getId(), (Matcher)Matchers.equalTo((Object)"user:secrethash"));
        }
        Assert.assertThat((String)"Invalid ACL list in the response", (Object)rsp.getAcl().get(1).getPerms(), (Matcher)Matchers.equalTo((Object)16));
        Assert.assertThat((String)"Invalid ACL list in the response", (Object)rsp.getAcl().get(1).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"digest"));
        if (masked) {
            Assert.assertThat((String)"Password hash is not masked in the response", (Object)rsp.getAcl().get(1).getId().getId(), (Matcher)Matchers.equalTo((Object)"adminuser:x"));
        } else {
            Assert.assertThat((String)"Password hash mismatch in the response", (Object)rsp.getAcl().get(1).getId().getId(), (Matcher)Matchers.equalTo((Object)"adminuser:adminsecret"));
        }
        Assert.assertThat((String)"Invalid ACL list in the response", (Object)rsp.getAcl().get(2).getPerms(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((String)"Invalid ACL list in the response", (Object)rsp.getAcl().get(2).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"world"));
        Assert.assertThat((String)"Invalid ACL list in the response", (Object)rsp.getAcl().get(2).getId().getId(), (Matcher)Matchers.equalTo((Object)"anyone"));
        Assert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(0).getPerms(), (Matcher)Matchers.equalTo((Object)31));
        Assert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(0).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"digest"));
        Assert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(0).getId().getId(), (Matcher)Matchers.equalTo((Object)"user:secrethash"));
        Assert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(1).getPerms(), (Matcher)Matchers.equalTo((Object)16));
        Assert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(1).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"digest"));
        Assert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(1).getId().getId(), (Matcher)Matchers.equalTo((Object)"adminuser:adminsecret"));
        Assert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(2).getPerms(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(2).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"world"));
        Assert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(2).getId().getId(), (Matcher)Matchers.equalTo((Object)"anyone"));
    }
}

