/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence;

import io.hops.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileHeader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.FileSnap;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.SnapStream;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SnapStreamTest {
    @After
    public void tearDown() {
        System.clearProperty("zookeeper.snapshot.compression.method");
        SnapStream.setStreamMode(SnapStream.StreamMode.DEFAULT_MODE);
    }

    @Test
    public void testStreamMode() {
        Assert.assertEquals((Object)SnapStream.StreamMode.CHECKED.getName(), (Object)"");
        Assert.assertEquals((Object)SnapStream.StreamMode.CHECKED.getFileExtension(), (Object)"");
        Assert.assertEquals((Object)((Object)SnapStream.StreamMode.CHECKED), (Object)((Object)SnapStream.StreamMode.fromString("name")));
        Assert.assertEquals((Object)SnapStream.StreamMode.GZIP.getName(), (Object)"gz");
        Assert.assertEquals((Object)SnapStream.StreamMode.GZIP.getFileExtension(), (Object)".gz");
        Assert.assertEquals((Object)((Object)SnapStream.StreamMode.GZIP), (Object)((Object)SnapStream.StreamMode.fromString("gz")));
        Assert.assertEquals((Object)SnapStream.StreamMode.SNAPPY.getName(), (Object)"snappy");
        Assert.assertEquals((Object)SnapStream.StreamMode.SNAPPY.getFileExtension(), (Object)".snappy");
        Assert.assertEquals((Object)((Object)SnapStream.StreamMode.SNAPPY), (Object)((Object)SnapStream.StreamMode.fromString("snappy")));
    }

    @Test
    public void testGetStreamMode() {
        Assert.assertEquals((String)"expected to return un-compressed stream", (Object)((Object)SnapStream.StreamMode.CHECKED), (Object)((Object)SnapStream.getStreamMode("snapshot.180000e3a2")));
        Assert.assertEquals((String)"expected to return snappy stream", (Object)((Object)SnapStream.StreamMode.SNAPPY), (Object)((Object)SnapStream.getStreamMode("snapshot.180000e3a2.snappy")));
        Assert.assertEquals((String)"expected to return gzip stream", (Object)((Object)SnapStream.StreamMode.GZIP), (Object)((Object)SnapStream.getStreamMode("snapshot.180000e3a2.gz")));
    }

    @Test
    public void testSerializeDeserializeWithChecked() throws IOException {
        this.testSerializeDeserialize(SnapStream.StreamMode.CHECKED, "");
    }

    @Test
    public void testSerializeDeserializeWithSNAPPY() throws IOException {
        this.testSerializeDeserialize(SnapStream.StreamMode.SNAPPY, ".snappy");
    }

    @Test
    public void testSerializeDeserializeWithGZIP() throws IOException {
        this.testSerializeDeserialize(SnapStream.StreamMode.GZIP, ".gz");
    }

    private void testSerializeDeserialize(SnapStream.StreamMode mode, String fileSuffix) throws IOException {
        this.testSerializeDeserialize(mode, fileSuffix, false);
        this.testSerializeDeserialize(mode, fileSuffix, true);
    }

    private void testSerializeDeserialize(SnapStream.StreamMode mode, String fileSuffix, boolean fsync) throws IOException {
        SnapStream.setStreamMode(mode);
        File tmpDir = ClientBase.createTmpDir();
        File file = new File(tmpDir, "snapshot.180000e3a2" + fileSuffix);
        CheckedOutputStream os = SnapStream.getOutputStream(file, fsync);
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive(os);
        FileHeader header = new FileHeader(FileSnap.SNAP_MAGIC, 2, 1L);
        header.serialize(oa, "fileheader");
        SnapStream.sealStream(os, oa);
        os.flush();
        os.close();
        Assert.assertTrue((boolean)SnapStream.isValidSnapshot(file));
        CheckedInputStream is = SnapStream.getInputStream(file);
        BinaryInputArchive ia = BinaryInputArchive.getArchive(is);
        FileHeader restoredHeader = new FileHeader();
        restoredHeader.deserialize(ia, "fileheader");
        Assert.assertEquals((String)"magic not the same", (Object)restoredHeader, (Object)header);
        SnapStream.checkSealIntegrity(is, ia);
    }

    private void checkInvalidSnapshot(String filename, boolean fsync) throws IOException {
        SnapStream.setStreamMode(SnapStream.StreamMode.CHECKED);
        File tmpDir = ClientBase.createTmpDir();
        File file = new File(tmpDir, filename);
        CheckedOutputStream os = SnapStream.getOutputStream(file, fsync);
        ((OutputStream)os).write(1);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        Assert.assertFalse((boolean)SnapStream.isValidSnapshot(file));
    }

    private void checkInvalidSnapshot(String filename) throws IOException {
        this.checkInvalidSnapshot(filename, false);
        this.checkInvalidSnapshot(filename, true);
    }

    @Test
    public void testInvalidSnapshot() throws IOException {
        Assert.assertFalse((boolean)SnapStream.isValidSnapshot(null));
        this.checkInvalidSnapshot("snapshot.180000e3a2");
        this.checkInvalidSnapshot("snapshot.180000e3a2.gz");
        this.checkInvalidSnapshot("snapshot.180000e3a2.snappy");
    }
}

