/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum;

import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import java.net.InetSocketAddress;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class QuorumServerTest
extends ZKTestCase {
    private String ipv6n1 = "[2500:0:0:0:0:0:1:0]";
    private String ipv6n2 = "[2600:0:0:0:0:0:1:0]";
    private String ipv4config = "127.0.0.1:1234:1236";

    @After
    public void tearDown() {
        System.clearProperty("zookeeper.multiAddress.enabled");
    }

    @Test
    public void testToString() throws QuorumPeerConfig.ConfigException {
        String provided = this.ipv4config + ":participant;0.0.0.0:1237";
        String expected = this.ipv4config + ":participant;0.0.0.0:1237";
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, provided);
        Assert.assertEquals((String)"Use IP address", (Object)expected, (Object)qs.toString());
        provided = this.ipv4config + ";0.0.0.0:1237";
        expected = this.ipv4config + ":participant;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, provided);
        Assert.assertEquals((String)"Type unspecified", (Object)expected, (Object)qs.toString());
        provided = this.ipv4config + ":observer;0.0.0.0:1237";
        expected = this.ipv4config + ":observer;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, provided);
        Assert.assertEquals((String)"Observer type", (Object)expected, (Object)qs.toString());
        provided = this.ipv4config + ":participant;1237";
        expected = this.ipv4config + ":participant;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, provided);
        Assert.assertEquals((String)"Client address unspecified", (Object)expected, (Object)qs.toString());
        provided = this.ipv4config + ":participant;1.2.3.4:1237";
        expected = this.ipv4config + ":participant;1.2.3.4:1237";
        qs = new QuorumPeer.QuorumServer(0L, provided);
        Assert.assertEquals((String)"Client address specified", (Object)expected, (Object)qs.toString());
        provided = "example.com:1234:1236:participant;1237";
        expected = "example.com:1234:1236:participant;0.0.0.0:1237";
        qs = new QuorumPeer.QuorumServer(0L, provided);
        Assert.assertEquals((String)"Use hostname", (Object)expected, (Object)qs.toString());
    }

    @Test
    public void constructionUnderstandsIpv6LiteralsInServerConfig() throws QuorumPeerConfig.ConfigException {
        String config = "[::1]:1234:1236:participant";
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, config);
        Assert.assertEquals((Object)"[0:0:0:0:0:0:0:1]:1234:1236:participant", (Object)qs.toString());
    }

    @Test
    public void constructionUnderstandsIpv6LiteralsInClientConfig() throws QuorumPeerConfig.ConfigException {
        String config = this.ipv4config + ":participant;[::1]:1237";
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, config);
        Assert.assertEquals((Object)(this.ipv4config + ":participant;[0:0:0:0:0:0:0:1]:1237"), (Object)qs.toString());
    }

    @Test(expected=QuorumPeerConfig.ConfigException.class)
    public void unbalancedIpv6LiteralsInServerConfigFailToBeParsed() throws QuorumPeerConfig.ConfigException {
        new QuorumPeer.QuorumServer(0L, "[::1:1234:1236:participant");
    }

    @Test(expected=QuorumPeerConfig.ConfigException.class)
    public void unbalancedIpv6LiteralsInClientConfigFailToBeParsed() throws QuorumPeerConfig.ConfigException {
        new QuorumPeer.QuorumServer(0L, this.ipv4config + ":participant;[::1:1237");
    }

    @Test(expected=QuorumPeerConfig.ConfigException.class)
    public void shouldNotAllowMultipleAddressesWhenMultiAddressFeatureIsDisabled() throws QuorumPeerConfig.ConfigException {
        System.setProperty("zookeeper.multiAddress.enabled", "false");
        new QuorumPeer.QuorumServer(0L, "127.0.0.1:1234:1236|127.0.0.1:2234:2236");
    }

    @Test
    public void shouldAllowMultipleAddressesWhenMultiAddressFeatureIsEnabled() throws QuorumPeerConfig.ConfigException {
        System.setProperty("zookeeper.multiAddress.enabled", "true");
        QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(0L, "127.0.0.1:1234:1236|127.0.0.1:2234:2236");
        Assert.assertEquals((String)"MultiAddress parse error", (Object)"127.0.0.1:1234:1236|127.0.0.1:2234:2236:participant", (Object)qs.toString());
    }

    @Test
    public void testWildcard() throws KeeperException.BadArgumentsException {
        String[] addrs = new String[]{"127.0.0.1", "[0:0:0:0:0:0:0:1]", "0.0.0.0", "[::]"};
        for (int i = 0; i < addrs.length; ++i) {
            for (int j = i; j < addrs.length; ++j) {
                QuorumPeer.QuorumServer server1 = new QuorumPeer.QuorumServer(1L, new InetSocketAddress(this.ipv6n1, 1234), new InetSocketAddress(this.ipv6n1, 1236), new InetSocketAddress(addrs[i], 1237));
                QuorumPeer.QuorumServer server2 = new QuorumPeer.QuorumServer(2L, new InetSocketAddress(this.ipv6n2, 1234), new InetSocketAddress(this.ipv6n2, 1236), new InetSocketAddress(addrs[j], 1237));
                server1.checkAddressDuplicate(server2);
            }
        }
    }

    @Test(expected=KeeperException.BadArgumentsException.class)
    public void testDuplicate() throws KeeperException.BadArgumentsException {
        QuorumPeer.QuorumServer server1 = new QuorumPeer.QuorumServer(1L, new InetSocketAddress(this.ipv6n1, 1234), new InetSocketAddress(this.ipv6n1, 1236), new InetSocketAddress(this.ipv6n1, 1237));
        QuorumPeer.QuorumServer server2 = new QuorumPeer.QuorumServer(2L, new InetSocketAddress(this.ipv6n2, 1234), new InetSocketAddress(this.ipv6n2, 1236), new InetSocketAddress(this.ipv6n1, 1237));
        server1.checkAddressDuplicate(server2);
    }
}

