/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell.find;

import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;

class MockFileSystem
extends FilterFileSystem {
    private static FileSystem mockFs = null;

    static FileSystem setup() throws IOException {
        if (mockFs == null) {
            mockFs = Mockito.mock(FileSystem.class);
        }
        Mockito.reset(mockFs);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "mockfs:///");
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        Mockito.when(mockFs.getConf()).thenReturn(conf);
        return mockFs;
    }

    private MockFileSystem() {
        super(mockFs);
    }

    public void initialize(URI uri, Configuration conf) {
    }

    public Path makeQualified(Path path) {
        return path;
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.fs.globStatus(pathPattern);
    }

    public Path getWorkingDirectory() {
        return new Path("/");
    }

    public Path resolvePath(Path p) throws IOException {
        return p;
    }
}

