/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.cedarsoftware.util;

import io.hops.hadoop.shaded.com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveSet<E>
implements Set<E> {
    private final CaseInsensitiveMap<E, Object> map;

    public CaseInsensitiveSet() {
        this.map = new CaseInsensitiveMap();
    }

    public CaseInsensitiveSet(Collection<? extends E> collection) {
        this.map = new CaseInsensitiveMap(collection.size());
        this.addAll(collection);
    }

    public CaseInsensitiveSet(int initialCapacity) {
        this.map = new CaseInsensitiveMap(initialCapacity);
    }

    public CaseInsensitiveSet(int initialCapacity, float loadFactor) {
        this.map = new CaseInsensitiveMap(initialCapacity, loadFactor);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (E item : this.map.keySet()) {
            if (item == null) continue;
            if (item instanceof String) {
                hash += ((String)item).toLowerCase().hashCode();
                continue;
            }
            hash += item.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        return that.size() == this.size() && this.containsAll(that);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean exists = this.map.containsKey(e);
        this.map.put(e, null);
        return !exists;
    }

    @Override
    public boolean remove(Object o) {
        boolean exists = this.map.containsKey(o);
        this.map.remove(o);
        return exists;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.map.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E elem : c) {
            this.map.put(elem, null);
        }
        return this.map.size() != c.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        CaseInsensitiveMap other = new CaseInsensitiveMap();
        for (Object o : c) {
            other.put(o, null);
        }
        Iterator<E> i = this.map.keySet().iterator();
        while (i.hasNext()) {
            E elem = i.next();
            if (other.containsKey(elem)) continue;
            i.remove();
        }
        return this.map.size() != c.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object elem : c) {
            this.map.remove(elem);
        }
        return this.map.size() != c.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.keySet().toString();
    }
}

