/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.hadoop.shaded.org.apache.commons.lang3.RandomStringUtils;
import io.hops.hadoop.shaded.org.apache.commons.lang3.RandomUtils;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.XAttrDataAccess;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.security.SecureRandom;

public class XAttrTestHelpers {
    public static int getXAttrTableRowCount() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                XAttrDataAccess da = (XAttrDataAccess)HdfsStorageFactory.getDataAccess(XAttrDataAccess.class);
                return da.count();
            }
        }.handle();
    }

    public static String generateRandomXAttrName(int size) {
        return RandomStringUtils.randomAlphanumeric((int)size);
    }

    public static byte[] generateRandomByteArrayWithRandomSize(int MAX_SIZE) {
        int size = RandomUtils.nextInt((int)1, (int)(MAX_SIZE + 1));
        return XAttrTestHelpers.generateRandomByteArray(size);
    }

    public static byte[] generateRandomByteArray(int size) {
        SecureRandom random = new SecureRandom();
        byte[] data = new byte[size];
        random.nextBytes(data);
        return data;
    }
}

