/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.sun.jersey.server.impl.container.grizzly2;

import io.hops.hadoop.shaded.com.sun.jersey.api.core.ResourceConfig;
import io.hops.hadoop.shaded.com.sun.jersey.core.header.InBoundHeaders;
import io.hops.hadoop.shaded.com.sun.jersey.server.impl.ThreadLocalInvoker;
import io.hops.hadoop.shaded.com.sun.jersey.spi.container.ContainerListener;
import io.hops.hadoop.shaded.com.sun.jersey.spi.container.ContainerRequest;
import io.hops.hadoop.shaded.com.sun.jersey.spi.container.ContainerResponse;
import io.hops.hadoop.shaded.com.sun.jersey.spi.container.ContainerResponseWriter;
import io.hops.hadoop.shaded.com.sun.jersey.spi.container.ReloadListener;
import io.hops.hadoop.shaded.com.sun.jersey.spi.container.WebApplication;
import io.hops.hadoop.shaded.com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import io.hops.hadoop.shaded.javax.ws.rs.core.Context;
import io.hops.hadoop.shaded.javax.ws.rs.core.GenericEntity;
import io.hops.hadoop.shaded.javax.ws.rs.core.Response;
import io.hops.hadoop.shaded.javax.ws.rs.core.UriBuilder;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.HttpHandler;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.Request;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.server.Response;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.util.Constants;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;

public final class GrizzlyContainer
extends HttpHandler
implements ContainerListener {
    private volatile WebApplication application;
    private final ThreadLocalInvoker<Request> requestInvoker = new ThreadLocalInvoker();
    private final ThreadLocalInvoker<Response> responseInvoker = new ThreadLocalInvoker();

    GrizzlyContainer(ResourceConfig resourceConfig, WebApplication application) {
        this.application = application;
        this.setAllowEncodedSlash(resourceConfig.getFeature("io.hops.hadoop.shaded.com.sun.jersey.api.container.grizzly.AllowEncodedSlashFeature"));
        GenericEntity<ThreadLocal<Request>> requestThreadLocal = new GenericEntity<ThreadLocal<Request>>(this.requestInvoker.getImmutableThreadLocal()){};
        resourceConfig.getSingletons().add(new ContextInjectableProvider<Object>(requestThreadLocal.getType(), requestThreadLocal.getEntity()));
        GenericEntity<ThreadLocal<Response>> responseThreadLocal = new GenericEntity<ThreadLocal<Response>>(this.responseInvoker.getImmutableThreadLocal()){};
        resourceConfig.getSingletons().add(new ContextInjectableProvider<Object>(responseThreadLocal.getType(), responseThreadLocal.getEntity()));
    }

    @Override
    public void onReload() {
        WebApplication oldApplication = this.application;
        this.application = this.application.clone();
        if (this.application.getFeaturesAndProperties() instanceof ReloadListener) {
            ((ReloadListener)this.application.getFeaturesAndProperties()).onReload();
        }
        oldApplication.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(Request request, Response response) {
        try {
            this.requestInvoker.set(request);
            this.responseInvoker.set(response);
            this._service(request, response);
        }
        finally {
            this.requestInvoker.set(null);
            this.responseInvoker.set(null);
        }
    }

    private void _service(Request request, Response response) {
        WebApplication _application = this.application;
        URI baseUri = this.getBaseUri(request);
        String originalURI = UriBuilder.fromPath((String)request.getRequest().getRequestURIRef().getOriginalRequestURIBC().toString(Constants.DEFAULT_HTTP_CHARSET)).build(new Object[0]).toString();
        String queryString = request.getQueryString();
        if (queryString != null) {
            originalURI = originalURI + "?" + queryString;
        }
        URI requestUri = baseUri.resolve(originalURI);
        try {
            ContainerRequest cRequest = new ContainerRequest(_application, request.getMethod().getMethodString(), baseUri, requestUri, this.getHeaders(request), request.getInputStream());
            _application.handleRequest(cRequest, new Writer(response));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private URI getBaseUri(Request request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), this.getBasePath(request), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getBasePath(Request request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            return "/";
        }
        if (contextPath.charAt(contextPath.length() - 1) != '/') {
            return contextPath + "/";
        }
        return contextPath;
    }

    private InBoundHeaders getHeaders(Request request) {
        InBoundHeaders rh = new InBoundHeaders();
        for (String name : request.getHeaderNames()) {
            rh.add(name, (Object)request.getHeader(name));
        }
        return rh;
    }

    private static final class Writer
    implements ContainerResponseWriter {
        final Response response;

        Writer(Response response) {
            this.response = response;
        }

        @Override
        public void finish() throws IOException {
        }

        @Override
        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse cResponse) throws IOException {
            Response.StatusType statusInfo = cResponse.getStatusType();
            if (statusInfo.getReasonPhrase() == null) {
                this.response.setStatus(statusInfo.getStatusCode());
            } else {
                this.response.setStatus(statusInfo.getStatusCode(), statusInfo.getReasonPhrase());
            }
            if (contentLength != -1L && contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)contentLength);
            }
            for (Map.Entry e : cResponse.getHttpHeaders().entrySet()) {
                for (Object value : (List)e.getValue()) {
                    this.response.addHeader((String)e.getKey(), ContainerResponse.getHeaderValue(value));
                }
            }
            String contentType = this.response.getHeader("Content-Type");
            if (contentType != null) {
                this.response.setContentType(contentType);
            }
            return this.response.getOutputStream();
        }
    }

    private static class ContextInjectableProvider<T>
    extends SingletonTypeInjectableProvider<Context, T> {
        protected ContextInjectableProvider(Type type, T instance) {
            super(type, instance);
        }
    }
}

