/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind;

import io.hops.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.WriteBehind;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.operations.DeleteOperation;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.operations.SingleOperation;
import io.hops.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.operations.WriteOperation;
import io.hops.hadoop.shaded.org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import io.hops.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import io.hops.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheWritingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

abstract class AbstractWriteBehind<K, V>
implements WriteBehind<K, V> {
    private final CacheLoaderWriter<K, V> cacheLoaderWriter;

    public AbstractWriteBehind(CacheLoaderWriter<K, V> cacheLoaderWriter) {
        this.cacheLoaderWriter = cacheLoaderWriter;
    }

    @Override
    public V load(K key) throws Exception {
        SingleOperation<K, V> operation = this.getOperation(key);
        return (V)(operation == null ? this.cacheLoaderWriter.load(key) : (operation.getClass() == WriteOperation.class ? ((WriteOperation)operation).getValue() : null));
    }

    @Override
    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        HashMap<K, V> entries = new HashMap<K, V>();
        for (K k : keys) {
            entries.put(k, this.load(k));
        }
        return entries;
    }

    @Override
    public void write(K key, V value) throws CacheWritingException {
        this.addOperation(new WriteOperation<K, V>(key, value));
    }

    @Override
    public void writeAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) throws BulkCacheWritingException, Exception {
        for (Map.Entry<K, V> entry : entries) {
            this.write(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void delete(K key) throws CacheWritingException {
        this.addOperation(new DeleteOperation(key));
    }

    @Override
    public void deleteAll(Iterable<? extends K> keys) throws BulkCacheWritingException, Exception {
        for (K k : keys) {
            this.delete(k);
        }
    }

    protected abstract SingleOperation<K, V> getOperation(K var1);

    protected abstract void addOperation(SingleOperation<K, V> var1);

    protected static <T> void putUninterruptibly(BlockingQueue<T> queue, T r) {
        boolean interrupted = false;
        while (true) {
            try {
                queue.put(r);
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

