/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.commons.collections.CollectionUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.AsyncCallback;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKParameterized;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=ZKParameterized.RunnerFactory.class)
public class RemoveWatchesTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveWatchesTest.class);
    private ZooKeeper zk1 = null;
    private ZooKeeper zk2 = null;
    private final boolean useAsync;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.zk1 = this.createClient();
        this.zk2 = this.createClient();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.zk1 != null) {
            this.zk1.close();
        }
        if (this.zk2 != null) {
            this.zk2.close();
        }
        super.tearDown();
    }

    public RemoveWatchesTest(boolean useAsync) {
        this.useAsync = useAsync;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList({false}, {true});
    }

    private void removeWatches(ZooKeeper zk, String path, Watcher watcher, Watcher.WatcherType watcherType, boolean local, KeeperException.Code rc) throws InterruptedException, KeeperException {
        LOG.info("Sending removeWatches req using zk {} path: {} type: {} watcher: {} ", new Object[]{zk, path, watcherType, watcher});
        if (this.useAsync) {
            MyCallback c1 = new MyCallback(rc.intValue(), path);
            zk.removeWatches(path, watcher, watcherType, local, c1, null);
            Assert.assertTrue((String)"Didn't succeeds removeWatch operation", (boolean)c1.matches());
            if (KeeperException.Code.OK.intValue() != c1.rc) {
                KeeperException ke = KeeperException.create(KeeperException.Code.get(c1.rc));
                throw ke;
            }
        } else {
            zk.removeWatches(path, watcher, watcherType, local);
        }
    }

    private void removeAllWatches(ZooKeeper zk, String path, Watcher.WatcherType watcherType, boolean local, KeeperException.Code rc) throws InterruptedException, KeeperException {
        LOG.info("Sending removeWatches req using zk {} path: {} type: {} ", new Object[]{zk, path, watcherType});
        if (this.useAsync) {
            MyCallback c1 = new MyCallback(rc.intValue(), path);
            zk.removeAllWatches(path, watcherType, local, c1, null);
            Assert.assertTrue((String)"Didn't succeeds removeWatch operation", (boolean)c1.matches());
            if (KeeperException.Code.OK.intValue() != c1.rc) {
                KeeperException ke = KeeperException.create(KeeperException.Code.get(c1.rc));
                throw ke;
            }
        } else {
            zk.removeAllWatches(path, watcherType, local);
        }
    }

    @Test(timeout=90000L)
    public void testRemoveSingleWatcher() throws Exception {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        this.zk1.create("/node2", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        MyWatcher w2 = new MyWatcher("/node2", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node2", w2));
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Data, false, KeeperException.Code.OK);
        Assert.assertEquals((String)"Didn't find data watcher", (long)1L, (long)this.zk2.getDataWatches().size());
        Assert.assertEquals((String)"Didn't find data watcher", (Object)"/node2", (Object)this.zk2.getDataWatches().get(0));
        this.removeWatches(this.zk2, "/node2", w2, Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove data watcher", (boolean)w2.matches());
        if (this.zk1 != null) {
            this.zk1.close();
            this.zk1 = null;
        }
        List<Watcher.Event.EventType> events = w1.getEventsAfterWatchRemoval();
        Assert.assertFalse((String)"Shouldn't get NodeDeletedEvent after watch removal", (boolean)events.contains((Object)Watcher.Event.EventType.NodeDeleted));
        Assert.assertEquals((String)"Shouldn't get NodeDeletedEvent after watch removal", (long)0L, (long)events.size());
    }

    @Test(timeout=90000L)
    public void testMultipleDataWatchers() throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w2));
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Data, false, KeeperException.Code.OK);
        Assert.assertEquals((String)"Didn't find data watcher", (long)1L, (long)this.zk2.getDataWatches().size());
        Assert.assertEquals((String)"Didn't find data watcher", (Object)"/node1", (Object)this.zk2.getDataWatches().get(0));
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove data watcher", (boolean)w2.matches());
        if (this.zk1 != null) {
            this.zk1.close();
            this.zk1 = null;
        }
        List<Watcher.Event.EventType> events = w2.getEventsAfterWatchRemoval();
        Assert.assertEquals((String)"Shouldn't get NodeDeletedEvent after watch removal", (long)0L, (long)events.size());
    }

    @Test(timeout=90000L)
    public void testMultipleChildWatchers() throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", w1);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", w2);
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Children, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)w2.matches());
        Assert.assertEquals((String)"Didn't find child watcher", (long)1L, (long)this.zk2.getChildWatches().size());
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)w1.matches());
        this.zk1.create("/node1/node2", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (int count = 30; count > 0 && w1.getEventsAfterWatchRemoval().size() <= 0; --count) {
            Thread.sleep(100L);
        }
        List<Watcher.Event.EventType> events = w2.getEventsAfterWatchRemoval();
        Assert.assertEquals((String)"Shouldn't get NodeChildrenChanged event", (long)0L, (long)events.size());
    }

    @Test(timeout=90000L)
    public void testRemoveAllWatchers() throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 2);
        MyWatcher w2 = new MyWatcher("/node1", 2);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w2));
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", w1);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", w2);
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        this.zk1.create("/node1/child", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assert.assertTrue((String)"Didn't remove data watcher", (boolean)w1.matches());
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)w2.matches());
    }

    @Test(timeout=90000L)
    public void testRemoveAllDataWatchers() throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w2));
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", w1);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", w2);
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Data, false, KeeperException.Code.OK);
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Data, false, KeeperException.Code.OK);
        this.zk1.create("/node1/child", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assert.assertTrue((String)"Didn't remove data watcher", (boolean)w1.matches());
        Assert.assertTrue((String)"Didn't remove data watcher", (boolean)w2.matches());
        for (int count = 10; count > 0 && (w1.getEventsAfterWatchRemoval().size() <= 0 || w2.getEventsAfterWatchRemoval().size() <= 0); --count) {
            Thread.sleep(1000L);
        }
        List<Watcher.Event.EventType> events = w1.getEventsAfterWatchRemoval();
        Assert.assertEquals((String)"Didn't get NodeChildrenChanged event", (long)1L, (long)events.size());
        Assert.assertTrue((String)"Didn't get NodeChildrenChanged event", (boolean)events.contains((Object)Watcher.Event.EventType.NodeChildrenChanged));
        events = w2.getEventsAfterWatchRemoval();
        Assert.assertEquals((String)"Didn't get NodeChildrenChanged event", (long)1L, (long)events.size());
        Assert.assertTrue((String)"Didn't get NodeChildrenChanged event", (boolean)events.contains((Object)Watcher.Event.EventType.NodeChildrenChanged));
    }

    @Test(timeout=90000L)
    public void testRemoveAllChildWatchers() throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w2));
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", w1);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", w2);
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Children, false, KeeperException.Code.OK);
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Children, false, KeeperException.Code.OK);
        this.zk1.setData("/node1", "test".getBytes(), -1);
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)w1.matches());
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)w2.matches());
        for (int count = 10; count > 0 && (w1.getEventsAfterWatchRemoval().size() <= 0 || w2.getEventsAfterWatchRemoval().size() <= 0); --count) {
            Thread.sleep(1000L);
        }
        List<Watcher.Event.EventType> events = w1.getEventsAfterWatchRemoval();
        Assert.assertEquals((String)"Didn't get NodeDataChanged event", (long)1L, (long)events.size());
        Assert.assertTrue((String)"Didn't get NodeDataChanged event", (boolean)events.contains((Object)Watcher.Event.EventType.NodeDataChanged));
        events = w2.getEventsAfterWatchRemoval();
        Assert.assertEquals((String)"Didn't get NodeDataChanged event", (long)1L, (long)events.size());
        Assert.assertTrue((String)"Didn't get NodeDataChanged event", (boolean)events.contains((Object)Watcher.Event.EventType.NodeDataChanged));
    }

    @Test(timeout=90000L)
    public void testNoWatcherException() throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 2);
        MyWatcher w2 = new MyWatcher("/node1", 2);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node2", w2));
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", w1);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", w2);
        MyWatcher w3 = new MyWatcher("/node1", 2);
        try {
            this.removeWatches(this.zk2, "/node1", w3, Watcher.WatcherType.Any, false, KeeperException.Code.NOWATCHER);
            Assert.fail((String)"Should throw exception as given watcher doesn't exists");
        }
        catch (KeeperException.NoWatcherException noWatcherException) {
            // empty catch block
        }
        try {
            this.removeWatches(this.zk2, "/node1", w3, Watcher.WatcherType.Children, false, KeeperException.Code.NOWATCHER);
            Assert.fail((String)"Should throw exception as given watcher doesn't exists");
        }
        catch (KeeperException.NoWatcherException noWatcherException) {
            // empty catch block
        }
        try {
            this.removeWatches(this.zk2, "/node1", w3, Watcher.WatcherType.Data, false, KeeperException.Code.NOWATCHER);
            Assert.fail((String)"Should throw exception as given watcher doesn't exists");
        }
        catch (KeeperException.NoWatcherException noWatcherException) {
            // empty catch block
        }
        try {
            this.removeWatches(this.zk2, "/nonexists", w3, Watcher.WatcherType.Data, false, KeeperException.Code.NOWATCHER);
            Assert.fail((String)"Should throw exception as given watcher doesn't exists");
        }
        catch (KeeperException.NoWatcherException noWatcherException) {
            // empty catch block
        }
    }

    @Test(timeout=90000L)
    public void testRemoveAnyDataWatcher() throws Exception {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        MyWatcher w2 = new MyWatcher("/node1", 2);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w2));
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", w2);
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove data watcher", (boolean)w1.matches());
        Assert.assertEquals((String)"Didn't find child watcher", (long)1L, (long)this.zk2.getChildWatches().size());
        Assert.assertEquals((String)"Didn't find data watcher", (long)1L, (long)this.zk2.getDataWatches().size());
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)w2.matches());
    }

    @Test(timeout=90000L)
    public void testRemoveAnyChildWatcher() throws Exception {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 2);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", w2);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", w1);
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)w2.matches());
        Assert.assertEquals((String)"Didn't find child watcher", (long)1L, (long)this.zk2.getChildWatches().size());
        Assert.assertEquals((String)"Didn't find data watcher", (long)1L, (long)this.zk2.getDataWatches().size());
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove watchers", (boolean)w1.matches());
    }

    @Test(timeout=90000L)
    public void testRemoveWatcherWhenNoConnection() throws Exception {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 2);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", w1);
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", w2);
        this.stopServer();
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Any, true, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)w2.matches());
        Assert.assertFalse((String)"Shouldn't remove data watcher", (boolean)w1.matches());
        try {
            this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.CONNECTIONLOSS);
            Assert.fail((String)"Should throw exception as last watch removal requires server connection");
        }
        catch (KeeperException.ConnectionLossException connectionLossException) {
            // empty catch block
        }
        Assert.assertFalse((String)"Shouldn't remove data watcher", (boolean)w1.matches());
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, true, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove data watcher", (boolean)w1.matches());
    }

    @Test(timeout=90000L)
    public void testManyPreNodeWatchers() throws Exception {
        int i;
        int count = 50;
        ArrayList<MyWatcher> wList = new ArrayList<MyWatcher>(count);
        String path = "/node";
        for (i = 0; i < count; ++i) {
            String nodePath = path + i;
            MyWatcher w = new MyWatcher(nodePath, 1);
            wList.add(w);
            LOG.info("Adding pre node watcher {} on path {}", (Object)w, (Object)nodePath);
            this.zk1.exists(nodePath, w);
        }
        Assert.assertEquals((String)"Failed to add watchers!", (long)count, (long)this.zk1.getExistWatches().size());
        for (i = 0; i < count; ++i) {
            MyWatcher watcher = (MyWatcher)wList.get(i);
            this.removeWatches(this.zk1, path + i, watcher, Watcher.WatcherType.Data, false, KeeperException.Code.OK);
            Assert.assertTrue((String)"Didn't remove data watcher", (boolean)watcher.matches());
        }
        Assert.assertEquals((String)"Didn't remove watch references!", (long)0L, (long)this.zk1.getExistWatches().size());
    }

    @Test(timeout=90000L)
    public void testManyChildWatchers() throws Exception {
        String nodePath;
        int i;
        int count = 50;
        ArrayList<MyWatcher> wList = new ArrayList<MyWatcher>(count);
        String path = "/node";
        for (i = 0; i < count; ++i) {
            nodePath = path + i;
            this.zk1.create(nodePath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            nodePath = nodePath + "/";
        }
        for (i = 0; i < count; ++i) {
            nodePath = path + i;
            MyWatcher w = new MyWatcher(path + i, 1);
            wList.add(w);
            LOG.info("Adding child watcher {} on path {}", (Object)w, (Object)nodePath);
            this.zk1.getChildren(nodePath, w);
            nodePath = nodePath + "/";
        }
        Assert.assertEquals((String)"Failed to add watchers!", (long)count, (long)this.zk1.getChildWatches().size());
        for (i = 0; i < count; ++i) {
            MyWatcher watcher = (MyWatcher)wList.get(i);
            this.removeWatches(this.zk1, path + i, watcher, Watcher.WatcherType.Children, false, KeeperException.Code.OK);
            Assert.assertTrue((String)"Didn't remove child watcher", (boolean)watcher.matches());
        }
        Assert.assertEquals((String)"Didn't remove watch references!", (long)0L, (long)this.zk1.getChildWatches().size());
    }

    @Test(timeout=90000L)
    public void testManyDataWatchers() throws Exception {
        int i;
        int count = 50;
        ArrayList<MyWatcher> wList = new ArrayList<MyWatcher>(count);
        String path = "/node";
        for (i = 0; i < count; ++i) {
            String nodePath = path + i;
            MyWatcher w = new MyWatcher(path + i, 1);
            wList.add(w);
            this.zk1.create(nodePath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            LOG.info("Adding data watcher {} on path {}", (Object)w, (Object)nodePath);
            this.zk1.getData(nodePath, w, null);
            nodePath = nodePath + "/";
        }
        Assert.assertEquals((String)"Failed to add watchers!", (long)count, (long)this.zk1.getDataWatches().size());
        for (i = 0; i < count; ++i) {
            MyWatcher watcher = (MyWatcher)wList.get(i);
            this.removeWatches(this.zk1, path + i, watcher, Watcher.WatcherType.Data, false, KeeperException.Code.OK);
            Assert.assertTrue((String)"Didn't remove data watcher", (boolean)watcher.matches());
        }
        Assert.assertEquals((String)"Didn't remove watch references!", (long)0L, (long)this.zk1.getDataWatches().size());
    }

    @Test(timeout=90000L)
    public void testManyWatchersWhenNoConnection() throws Exception {
        MyWatcher w;
        String nodePath;
        int i;
        int count = 3;
        ArrayList<MyWatcher> wList = new ArrayList<MyWatcher>(count);
        String path = "/node";
        for (i = 0; i < count; ++i) {
            nodePath = path + i;
            this.zk1.create(nodePath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            nodePath = nodePath + "/";
        }
        for (i = 0; i < count; ++i) {
            nodePath = path + i;
            w = new MyWatcher(path + i, 2);
            wList.add(w);
            LOG.info("Adding child watcher {} on path {}", (Object)w, (Object)nodePath);
            this.zk1.getChildren(nodePath, w);
            nodePath = nodePath + "/";
        }
        Assert.assertEquals((String)"Failed to add watchers!", (long)count, (long)this.zk1.getChildWatches().size());
        for (i = 0; i < count; ++i) {
            nodePath = path + i;
            w = (MyWatcher)wList.get(i);
            LOG.info("Adding data watcher {} on path {}", (Object)w, (Object)nodePath);
            this.zk1.getData(nodePath, w, null);
            nodePath = nodePath + "/";
        }
        Assert.assertEquals((String)"Failed to add watchers!", (long)count, (long)this.zk1.getDataWatches().size());
        this.stopServer();
        for (i = 0; i < count; ++i) {
            MyWatcher watcher = (MyWatcher)wList.get(i);
            this.removeWatches(this.zk1, path + i, watcher, Watcher.WatcherType.Any, true, KeeperException.Code.OK);
            Assert.assertTrue((String)"Didn't remove watcher", (boolean)watcher.matches());
        }
        Assert.assertEquals((String)"Didn't remove watch references!", (long)0L, (long)this.zk1.getChildWatches().size());
        Assert.assertEquals((String)"Didn't remove watch references!", (long)0L, (long)this.zk1.getDataWatches().size());
    }

    @Test(timeout=90000L)
    public void testChRootRemoveWatcher() throws Exception {
        String chRoot = "/appsX";
        this.zk1.create("/appsX", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        if (this.zk1 != null) {
            this.zk1.close();
        }
        if (this.zk2 != null) {
            this.zk2.close();
        }
        this.zk1 = this.createClient(this.hostPort + chRoot);
        this.zk2 = this.createClient(this.hostPort + chRoot);
        LOG.info("Creating child znode /node1 using chRoot client");
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 2);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", w2);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", w1);
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)w1.matches());
        Assert.assertEquals((String)"Didn't find child watcher", (long)1L, (long)this.zk2.getChildWatches().size());
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)w2.matches());
    }

    @Test(timeout=90000L)
    public void testNoWatcherServerException() throws InterruptedException, IOException, TimeoutException {
        boolean nw;
        MyZooKeeper zk;
        block2: {
            ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
            zk = new MyZooKeeper(this.hostPort, CONNECTION_TIMEOUT, watcher);
            nw = false;
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            try {
                zk.removeWatches("/nowatchhere", watcher, Watcher.WatcherType.Data, false);
            }
            catch (KeeperException nwe) {
                if (nwe.code().intValue() != KeeperException.Code.NOWATCHER.intValue()) break block2;
                nw = true;
            }
        }
        Assert.assertTrue((String)"Server didn't return NOWATCHER", (zk.getRemoveWatchesRC() == KeeperException.Code.NOWATCHER.intValue() ? 1 : 0) != 0);
        Assert.assertTrue((String)"NoWatcherException didn't happen", (boolean)nw);
    }

    @Test(timeout=90000L)
    public void testRemoveAllNoWatcherException() throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            this.removeAllWatches(this.zk2, "/node1", Watcher.WatcherType.Any, false, KeeperException.Code.NOWATCHER);
            Assert.fail((String)"Should throw exception as given watcher doesn't exists");
        }
        catch (KeeperException.NoWatcherException noWatcherException) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testNullWatcherReference() throws Exception {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            if (this.useAsync) {
                this.zk1.removeWatches("/node1", null, Watcher.WatcherType.Data, false, null, null);
            } else {
                this.zk1.removeWatches("/node1", null, Watcher.WatcherType.Data, false);
            }
            Assert.fail((String)"Must throw IllegalArgumentException as watcher is null!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=90000L)
    public void testRemoveWhenMultipleDataWatchesOnAPath() throws Exception {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch dataWatchCount = new CountDownLatch(1);
        CountDownLatch rmWatchCount = new CountDownLatch(1);
        Watcher w1 = event -> {
            if (event.getType() == Watcher.Event.EventType.DataWatchRemoved) {
                rmWatchCount.countDown();
            }
        };
        Watcher w2 = event -> {
            if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                dataWatchCount.countDown();
            }
        };
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w2));
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Data, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove data watcher", (boolean)rmWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS));
        this.zk1.setData("/node1", "test".getBytes(), -1);
        LOG.info("Waiting for data watchers to be notified");
        Assert.assertTrue((String)"Didn't get data watch notification!", (boolean)dataWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS));
    }

    @Test(timeout=90000L)
    public void testRemoveWhenMultipleChildWatchesOnAPath() throws Exception {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch childWatchCount = new CountDownLatch(1);
        CountDownLatch rmWatchCount = new CountDownLatch(1);
        Watcher w1 = event -> {
            if (event.getType() == Watcher.Event.EventType.ChildWatchRemoved) {
                rmWatchCount.countDown();
            }
        };
        Watcher w2 = event -> {
            if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                childWatchCount.countDown();
            }
        };
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertEquals((String)"Didn't set child watches", (long)0L, (long)this.zk2.getChildren("/node1", w1).size());
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertEquals((String)"Didn't set child watches", (long)0L, (long)this.zk2.getChildren("/node1", w2).size());
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Children, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)rmWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS));
        this.zk1.create("/node1/node2", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        LOG.info("Waiting for child watchers to be notified");
        Assert.assertTrue((String)"Didn't get child watch notification!", (boolean)childWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS));
    }

    @Test(timeout=90000L)
    public void testRemoveAllDataWatchesOnAPath() throws Exception {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch dWatchCount = new CountDownLatch(2);
        CountDownLatch rmWatchCount = new CountDownLatch(2);
        Watcher w1 = event -> {
            switch (event.getType()) {
                case DataWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeDataChanged: {
                    dWatchCount.countDown();
                    break;
                }
            }
        };
        Watcher w2 = event -> {
            switch (event.getType()) {
                case DataWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeDataChanged: {
                    dWatchCount.countDown();
                    break;
                }
            }
        };
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w2));
        Assert.assertTrue((String)"Server session is not a watcher", (boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Data));
        this.removeAllWatches(this.zk2, "/node1", Watcher.WatcherType.Data, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove data watcher", (boolean)rmWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Server session is still a watcher after removal", (boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Data));
    }

    @Test(timeout=90000L)
    public void testRemoveAllChildWatchesOnAPath() throws Exception {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch cWatchCount = new CountDownLatch(2);
        CountDownLatch rmWatchCount = new CountDownLatch(2);
        Watcher w1 = event -> {
            switch (event.getType()) {
                case ChildWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeChildrenChanged: {
                    cWatchCount.countDown();
                    break;
                }
            }
        };
        Watcher w2 = event -> {
            switch (event.getType()) {
                case ChildWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeChildrenChanged: {
                    cWatchCount.countDown();
                    break;
                }
            }
        };
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertEquals((String)"Didn't set child watches", (long)0L, (long)this.zk2.getChildren("/node1", w1).size());
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertEquals((String)"Didn't set child watches", (long)0L, (long)this.zk2.getChildren("/node1", w2).size());
        Assert.assertTrue((String)"Server session is not a watcher", (boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Children));
        this.removeAllWatches(this.zk2, "/node1", Watcher.WatcherType.Children, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove child watcher", (boolean)rmWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Server session is still a watcher after removal", (boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Children));
    }

    @Test(timeout=90000L)
    public void testRemoveAllWatchesOnAPath() throws Exception {
        this.zk1.create("/node1", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch watchCount = new CountDownLatch(2);
        CountDownLatch rmWatchCount = new CountDownLatch(4);
        Watcher w1 = event -> {
            switch (event.getType()) {
                case ChildWatchRemoved: 
                case DataWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeChildrenChanged: 
                case NodeDataChanged: {
                    watchCount.countDown();
                    break;
                }
            }
        };
        Watcher w2 = event -> {
            switch (event.getType()) {
                case ChildWatchRemoved: 
                case DataWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeChildrenChanged: 
                case NodeDataChanged: {
                    watchCount.countDown();
                    break;
                }
            }
        };
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertEquals((String)"Didn't set child watches", (long)0L, (long)this.zk2.getChildren("/node1", w1).size());
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertEquals((String)"Didn't set child watches", (long)0L, (long)this.zk2.getChildren("/node1", w2).size());
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w1));
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assert.assertNotNull((String)"Didn't set data watches", (Object)this.zk2.exists("/node1", w2));
        Assert.assertTrue((String)"Server session is not a watcher", (boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Data));
        this.removeAllWatches(this.zk2, "/node1", Watcher.WatcherType.Any, false, KeeperException.Code.OK);
        Assert.assertTrue((String)"Didn't remove data watcher", (boolean)rmWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Server session is still a watcher after removal", (boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Data));
        Assert.assertEquals((String)"Received watch notification after removal!", (long)2L, (long)watchCount.getCount());
    }

    private boolean isServerSessionWatcher(long sessionId, String path, Watcher.WatcherType type) {
        HashSet cnxns = new HashSet();
        CollectionUtils.addAll(cnxns, this.serverFactory.getConnections().iterator());
        for (ServerCnxn cnxn : cnxns) {
            if (cnxn.getSessionId() != sessionId) continue;
            return this.serverFactory.getZooKeeperServer().getZKDatabase().getDataTree().containsWatcher(path, type, cnxn);
        }
        return false;
    }

    private class MyCallback
    implements AsyncCallback.VoidCallback {
        private final String path;
        private final int rc;
        private String eventPath;
        int eventRc;
        private CountDownLatch latch = new CountDownLatch(1);

        public MyCallback(int rc, String path) {
            this.rc = rc;
            this.path = path;
        }

        @Override
        public void processResult(int rc, String eventPath, Object ctx) {
            System.out.println("latch:" + this.path + " " + eventPath);
            this.eventPath = eventPath;
            this.eventRc = rc;
            this.latch.countDown();
        }

        public boolean matches() throws InterruptedException {
            if (!this.latch.await(ClientBase.CONNECTION_TIMEOUT / 5, TimeUnit.MILLISECONDS)) {
                return false;
            }
            return this.path.equals(this.eventPath) && this.rc == this.eventRc;
        }
    }

    private class MyWatcher
    implements Watcher {
        private final String path;
        private String eventPath;
        private CountDownLatch latch;
        private List<Watcher.Event.EventType> eventsAfterWatchRemoval = new ArrayList<Watcher.Event.EventType>();

        MyWatcher(String path, int count) {
            this.path = path;
            this.latch = new CountDownLatch(count);
        }

        @Override
        public void process(WatchedEvent event) {
            LOG.debug("Event path : {}, eventPath : {}", (Object)this.path, (Object)event.getPath());
            this.eventPath = event.getPath();
            if (this.latch.getCount() == 0L && event.getType() != Watcher.Event.EventType.None) {
                this.eventsAfterWatchRemoval.add(event.getType());
            }
            if (event.getType() == Watcher.Event.EventType.ChildWatchRemoved || event.getType() == Watcher.Event.EventType.DataWatchRemoved) {
                this.latch.countDown();
            }
        }

        public boolean matches() throws InterruptedException {
            if (!this.latch.await(ClientBase.CONNECTION_TIMEOUT / 5, TimeUnit.MILLISECONDS)) {
                LOG.error("Failed waiting to remove the watches");
                return false;
            }
            LOG.debug("Client path : {} eventPath : {}", (Object)this.path, (Object)this.eventPath);
            return this.path.equals(this.eventPath);
        }

        public List<Watcher.Event.EventType> getEventsAfterWatchRemoval() {
            return this.eventsAfterWatchRemoval;
        }
    }

    private class MyZooKeeper
    extends ZooKeeper {
        private MyWatchManager myWatchManager;

        public MyZooKeeper(String hp, int timeout, Watcher watcher) throws IOException {
            super(hp, timeout, watcher, false);
        }

        @Override
        protected ZooKeeper.ZKWatchManager defaultWatchManager() {
            this.myWatchManager = new MyWatchManager(this.getClientConfig().getBoolean("zookeeper.disableAutoWatchReset"));
            return this.myWatchManager;
        }

        public int getRemoveWatchesRC() {
            return this.myWatchManager.lastrc;
        }

        class MyWatchManager
        extends ZooKeeper.ZKWatchManager {
            public int lastrc;

            public MyWatchManager(boolean disableAutoWatchReset) {
                super(disableAutoWatchReset);
            }

            @Override
            void containsWatcher(String path, Watcher watcher, Watcher.WatcherType watcherType) throws KeeperException.NoWatcherException {
            }

            @Override
            protected boolean removeWatches(Map<String, Set<Watcher>> pathVsWatcher, Watcher watcher, String path, boolean local, int rc, Set<Watcher> removedWatchers) throws KeeperException {
                this.lastrc = rc;
                return false;
            }
        }
    }
}

