/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.client.FourLetterWordMain;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.X509Exception;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumBase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourLetterWordsQuorumTest
extends QuorumBase {
    protected static final Logger LOG = LoggerFactory.getLogger(FourLetterWordsQuorumTest.class);

    @Test
    public void testFourLetterWords() throws Exception {
        String[] servers;
        for (String hp : servers = this.hostPort.split(",")) {
            this.verify(hp, "ruok", "imok");
            this.verify(hp, "envi", "java.version");
            this.verify(hp, "conf", "clientPort");
            this.verify(hp, "stat", "Outstanding");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", "queued");
            this.verify(hp, "dump", "Session");
            this.verify(hp, "wchs", "watches");
            this.verify(hp, "wchp", "");
            this.verify(hp, "wchc", "");
            this.verify(hp, "srst", "reset");
            this.verify(hp, "crst", "reset");
            this.verify(hp, "stat", "Outstanding");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", "queued");
            TestableZooKeeper zk = this.createClient(hp);
            String sid = FourLetterWordsQuorumTest.getHexSessionId(zk.getSessionId());
            this.verify(hp, "stat", "queued");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", sid);
            this.verify(hp, "dump", sid);
            this.verify(hp, "dirs", "size");
            zk.getData("/", true, null);
            this.verify(hp, "stat", "queued");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", sid);
            this.verify(hp, "dump", sid);
            this.verify(hp, "wchs", "watching 1");
            this.verify(hp, "wchp", sid);
            this.verify(hp, "wchc", sid);
            this.verify(hp, "dirs", "size");
            zk.close();
            this.verify(hp, "ruok", "imok");
            this.verify(hp, "envi", "java.version");
            this.verify(hp, "conf", "clientPort");
            this.verify(hp, "stat", "Outstanding");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", "queued");
            this.verify(hp, "dump", "Session");
            this.verify(hp, "wchs", "watch");
            this.verify(hp, "wchp", "");
            this.verify(hp, "wchc", "");
            this.verify(hp, "dirs", "size");
            this.verify(hp, "srst", "reset");
            this.verify(hp, "crst", "reset");
            this.verify(hp, "stat", "Outstanding");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", "queued");
            this.verify(hp, "mntr", "zk_version\t");
        }
    }

    private void verify(String hp, String cmd, String expected) throws IOException, X509Exception.SSLContextException {
        for (ClientBase.HostPort hpobj : FourLetterWordsQuorumTest.parseHostPortList(hp)) {
            String resp = FourLetterWordMain.send4LetterWord(hpobj.host, hpobj.port, cmd);
            LOG.info("cmd {} expected {} got {}", new Object[]{cmd, expected, resp});
            if (cmd.equals("dump")) {
                Assert.assertTrue((resp.contains(expected) || resp.contains("Sessions with Ephemerals") ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((boolean)resp.contains(expected));
        }
    }
}

