/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.ehcache.impl.events;

import io.hops.hadoop.shaded.org.ehcache.Cache;
import io.hops.hadoop.shaded.org.ehcache.core.CacheConfigurationChangeEvent;
import io.hops.hadoop.shaded.org.ehcache.core.CacheConfigurationChangeListener;
import io.hops.hadoop.shaded.org.ehcache.core.CacheConfigurationProperty;
import io.hops.hadoop.shaded.org.ehcache.core.events.CacheEventDispatcher;
import io.hops.hadoop.shaded.org.ehcache.core.events.CacheEvents;
import io.hops.hadoop.shaded.org.ehcache.core.internal.events.EventListenerWrapper;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.events.StoreEvent;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.events.StoreEventListener;
import io.hops.hadoop.shaded.org.ehcache.core.spi.store.events.StoreEventSource;
import io.hops.hadoop.shaded.org.ehcache.event.CacheEvent;
import io.hops.hadoop.shaded.org.ehcache.event.CacheEventListener;
import io.hops.hadoop.shaded.org.ehcache.event.EventFiring;
import io.hops.hadoop.shaded.org.ehcache.event.EventOrdering;
import io.hops.hadoop.shaded.org.ehcache.event.EventType;
import io.hops.hadoop.shaded.org.ehcache.impl.events.EventDispatchTask;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEventDispatcherImpl<K, V>
implements CacheEventDispatcher<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheEventDispatcherImpl.class);
    private final ExecutorService unOrderedExectuor;
    private final ExecutorService orderedExecutor;
    private int listenersCount = 0;
    private int orderedListenerCount = 0;
    private final List<EventListenerWrapper<K, V>> syncListenersList = new CopyOnWriteArrayList<EventListenerWrapper<K, V>>();
    private final List<EventListenerWrapper<K, V>> aSyncListenersList = new CopyOnWriteArrayList<EventListenerWrapper<K, V>>();
    private final StoreEventListener<K, V> eventListener = new StoreListener();
    private volatile Cache<K, V> listenerSource;
    private volatile StoreEventSource<K, V> storeEventSource;

    public CacheEventDispatcherImpl(ExecutorService unOrderedExecutor, ExecutorService orderedExecutor) {
        this.unOrderedExectuor = unOrderedExecutor;
        this.orderedExecutor = orderedExecutor;
    }

    @Override
    public void registerCacheEventListener(CacheEventListener<? super K, ? super V> listener, EventOrdering ordering, EventFiring firing, EnumSet<EventType> forEventTypes) {
        EventListenerWrapper<? super K, ? super V> wrapper = new EventListenerWrapper<K, V>(listener, firing, ordering, forEventTypes);
        this.registerCacheEventListener(wrapper);
    }

    private synchronized void registerCacheEventListener(EventListenerWrapper<K, V> wrapper) {
        if (this.aSyncListenersList.contains(wrapper) || this.syncListenersList.contains(wrapper)) {
            throw new IllegalStateException("Cache Event Listener already registered: " + wrapper.getListener());
        }
        if (wrapper.isOrdered() && this.orderedListenerCount++ == 0) {
            this.storeEventSource.setEventOrdering(true);
        }
        switch (wrapper.getFiringMode()) {
            case ASYNCHRONOUS: {
                this.aSyncListenersList.add(wrapper);
                break;
            }
            case SYNCHRONOUS: {
                this.syncListenersList.add(wrapper);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled EventFiring value: " + (Object)((Object)wrapper.getFiringMode())));
            }
        }
        if (this.listenersCount++ == 0) {
            this.storeEventSource.addEventListener(this.eventListener);
        }
    }

    @Override
    public void deregisterCacheEventListener(CacheEventListener<? super K, ? super V> listener) {
        EventListenerWrapper<? super K, ? super V> wrapper = new EventListenerWrapper<K, V>(listener);
        if (!this.removeWrapperFromList(wrapper, this.aSyncListenersList) && !this.removeWrapperFromList(wrapper, this.syncListenersList)) {
            throw new IllegalStateException("Unknown cache event listener: " + listener);
        }
    }

    private synchronized boolean removeWrapperFromList(EventListenerWrapper wrapper, List<EventListenerWrapper<K, V>> listenersList) {
        int index = listenersList.indexOf(wrapper);
        if (index != -1) {
            EventListenerWrapper<K, V> containedWrapper = listenersList.remove(index);
            if (containedWrapper.isOrdered() && --this.orderedListenerCount == 0) {
                this.storeEventSource.setEventOrdering(false);
            }
            if (--this.listenersCount == 0) {
                this.storeEventSource.removeEventListener(this.eventListener);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void shutdown() {
        this.storeEventSource.removeEventListener(this.eventListener);
        this.storeEventSource.setEventOrdering(false);
        this.syncListenersList.clear();
        this.aSyncListenersList.clear();
        this.unOrderedExectuor.shutdown();
        this.orderedExecutor.shutdown();
    }

    @Override
    public synchronized void setListenerSource(Cache<K, V> source) {
        this.listenerSource = source;
    }

    void onEvent(CacheEvent<K, V> event) {
        ExecutorService executor = this.storeEventSource.isEventOrdering() ? this.orderedExecutor : this.unOrderedExectuor;
        if (!this.aSyncListenersList.isEmpty()) {
            executor.submit(new EventDispatchTask<K, V>(event, this.aSyncListenersList));
        }
        if (!this.syncListenersList.isEmpty()) {
            Future<?> future = executor.submit(new EventDispatchTask<K, V>(event, this.syncListenersList));
            try {
                future.get();
            }
            catch (Exception e) {
                LOGGER.error("Exception received as result from synchronous listeners", (Throwable)e);
            }
        }
    }

    @Override
    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> configurationChangeListenerList = new ArrayList<CacheConfigurationChangeListener>();
        configurationChangeListenerList.add(new CacheConfigurationChangeListener(){

            @Override
            public void cacheConfigurationChange(CacheConfigurationChangeEvent event) {
                if (event.getProperty().equals((Object)CacheConfigurationProperty.ADD_LISTENER)) {
                    CacheEventDispatcherImpl.this.registerCacheEventListener((EventListenerWrapper)event.getNewValue());
                } else if (event.getProperty().equals((Object)CacheConfigurationProperty.REMOVE_LISTENER)) {
                    CacheEventListener oldListener = (CacheEventListener)event.getOldValue();
                    CacheEventDispatcherImpl.this.deregisterCacheEventListener(oldListener);
                }
            }
        });
        return configurationChangeListenerList;
    }

    @Override
    public synchronized void setStoreEventSource(StoreEventSource<K, V> eventSource) {
        this.storeEventSource = eventSource;
    }

    private final class StoreListener
    implements StoreEventListener<K, V> {
        private StoreListener() {
        }

        @Override
        public void onEvent(StoreEvent<K, V> event) {
            switch (event.getType()) {
                case CREATED: {
                    CacheEventDispatcherImpl.this.onEvent(CacheEvents.creation(event.getKey(), event.getNewValue(), CacheEventDispatcherImpl.this.listenerSource));
                    break;
                }
                case UPDATED: {
                    CacheEventDispatcherImpl.this.onEvent(CacheEvents.update(event.getKey(), event.getOldValue(), event.getNewValue(), CacheEventDispatcherImpl.this.listenerSource));
                    break;
                }
                case REMOVED: {
                    CacheEventDispatcherImpl.this.onEvent(CacheEvents.removal(event.getKey(), event.getOldValue(), CacheEventDispatcherImpl.this.listenerSource));
                    break;
                }
                case EXPIRED: {
                    CacheEventDispatcherImpl.this.onEvent(CacheEvents.expiry(event.getKey(), event.getOldValue(), CacheEventDispatcherImpl.this.listenerSource));
                    break;
                }
                case EVICTED: {
                    CacheEventDispatcherImpl.this.onEvent(CacheEvents.eviction(event.getKey(), event.getOldValue(), CacheEventDispatcherImpl.this.listenerSource));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected StoreEvent value: " + (Object)((Object)event.getType())));
                }
            }
        }
    }
}

