/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.LightWeightCacheDistributed;
import org.apache.hadoop.hdfs.server.namenode.XAttrPermissionFilter;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;

class FSDirXAttrOp {
    private static final XAttr UNREADABLE_BY_SUPERUSER_XATTR = XAttrHelper.buildXAttr("security.hdfs.unreadable.by.superuser", null);
    public static final XAttr XATTR_ENCRYPTION_ZONE = XAttrHelper.buildXAttr("raw.hdfs.crypto.encryption.zone", null);
    public static final XAttr XATTR_FILE_ENCRYPTION_INFO = XAttrHelper.buildXAttr("raw.hdfs.crypto.file.encryption.info", null);

    FSDirXAttrOp() {
    }

    static HdfsFileStatus setXAttr(final FSDirectory fsd, final String srcArg, final String src, final XAttr xAttr, final EnumSet<XAttrSetFlag> flag) throws IOException {
        FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
        FSDirXAttrOp.checkXAttrSize(fsd, xAttr);
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.SET_XATTR){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNameNode().getId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                locks.add((Lock)il);
                ArrayList<XAttr> xAttrsToLock = new ArrayList<XAttr>();
                xAttrsToLock.add(xAttr);
                xAttrsToLock.add(XATTR_FILE_ENCRYPTION_INFO);
                xAttrsToLock.add(XATTR_ENCRYPTION_ZONE);
                locks.add(lf.getXAttrLock(xAttrsToLock));
                locks.add(lf.getAcesLock());
                locks.add(lf.getEZLock());
                if (fsd.getFSNamesystem().isRetryCacheEnabled()) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId(), Server.getRpcEpoch()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCacheEntry cacheEntry = LightWeightCacheDistributed.get();
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                HdfsFileStatus stat = null;
                boolean success = false;
                try {
                    stat = FSDirXAttrOp.setXAttrInt(fsd, srcArg, src, xAttr, flag, cacheEntry != null);
                    success = true;
                }
                finally {
                    LightWeightCacheDistributed.put(null, success);
                }
                return stat;
            }
        }.handle();
    }

    static List<XAttr> getXAttrs(final FSDirectory fsd, final String srcArg, final String src, final List<XAttr> xAttrs) throws IOException {
        FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
        return (List)new HopsTransactionalRequestHandler(HDFSOperationType.GET_XATTRS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNameNode().getId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                locks.add((Lock)il);
                locks.add(lf.getXAttrLock(xAttrs));
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                return FSDirXAttrOp.getXAttrsInt(fsd, srcArg, src, xAttrs);
            }
        }.handle();
    }

    static List<XAttr> listXAttrs(final FSDirectory fsd, final String srcArg, final String src) throws IOException {
        FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
        return (List)new HopsTransactionalRequestHandler(HDFSOperationType.LIST_XATTRS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNameNode().getId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                locks.add((Lock)il);
                locks.add(lf.getXAttrLock());
            }

            public Object performTask() throws IOException {
                return FSDirXAttrOp.listXAttrsInt(fsd, srcArg, src);
            }
        }.handle();
    }

    static HdfsFileStatus removeXAttr(final FSDirectory fsd, final String srcArg, final String src, final XAttr xAttr) throws IOException {
        FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.GET_XATTRS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNameNode().getId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                locks.add((Lock)il);
                ArrayList<XAttr> xAttrsToLock = new ArrayList<XAttr>();
                xAttrsToLock.add(xAttr);
                xAttrsToLock.add(XATTR_FILE_ENCRYPTION_INFO);
                locks.add(lf.getXAttrLock(xAttrsToLock));
                locks.add(lf.getAcesLock());
                if (fsd.getFSNamesystem().isRetryCacheEnabled()) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId(), Server.getRpcEpoch()));
                }
                locks.add(lf.getEZLock());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                HdfsFileStatus stat;
                RetryCacheEntry cacheEntry = LightWeightCacheDistributed.get();
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    stat = FSDirXAttrOp.removeXAttrInt(fsd, srcArg, src, xAttr, cacheEntry != null);
                    success = true;
                }
                finally {
                    LightWeightCacheDistributed.put(null, success);
                }
                return stat;
            }
        }.handle();
    }

    private static HdfsFileStatus setXAttrInt(FSDirectory fsd, String srcArg, String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag, boolean logRetryCache) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        XAttrPermissionFilter.checkPermissionForApi(pc, xAttr, FSDirectory.isReservedRawName(srcArg));
        INodesInPath iip = fsd.getINodesInPath4Write(src);
        FSDirXAttrOp.checkXAttrChangeAccess(fsd, iip, xAttr, pc);
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
        xAttrs.add(xAttr);
        FSDirXAttrOp.unprotectedSetXAttrs(fsd, src, xAttrs, flag);
        return fsd.getAuditFileInfo(fsd.getINodesInPath(src, false));
    }

    private static List<XAttr> getXAttrsInt(FSDirectory fsd, String srcArg, String src, List<XAttr> xAttrs) throws IOException {
        boolean getAll;
        boolean isRawPath = FSDirectory.isReservedRawName(srcArg);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        boolean bl = getAll = xAttrs == null || xAttrs.isEmpty();
        if (!getAll) {
            XAttrPermissionFilter.checkPermissionForApi(pc, xAttrs, isRawPath);
        }
        INodesInPath iip = fsd.getINodesInPath(src, true);
        if (fsd.isPermissionEnabled()) {
            fsd.checkPathAccess(pc, iip, FsAction.READ);
        }
        List<XAttr> all = FSDirXAttrOp.getXAttrsInt(fsd, src, xAttrs);
        List<XAttr> filteredAll = XAttrPermissionFilter.filterXAttrsForApi(pc, all, isRawPath);
        if (getAll) {
            return filteredAll;
        }
        if (filteredAll == null || !iip.getLastINode().hasXAttrs()) {
            return null;
        }
        ArrayList toGet = Lists.newArrayListWithCapacity((int)xAttrs.size());
        for (XAttr xAttr : xAttrs) {
            boolean foundIt = false;
            for (XAttr a : filteredAll) {
                if (xAttr.getNameSpace() != a.getNameSpace() || !xAttr.getName().equals(a.getName())) continue;
                toGet.add(a);
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            throw new IOException("At least one of the attributes provided was not found.");
        }
        return toGet;
    }

    private static List<XAttr> listXAttrsInt(FSDirectory fsd, String srcArg, String src) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        INodesInPath iip = fsd.getINodesInPath(src, true);
        if (fsd.isPermissionEnabled()) {
            fsd.checkParentAccess(pc, iip, FsAction.EXECUTE);
        }
        List<XAttr> all = FSDirXAttrOp.getXAttrsInt(fsd, src);
        List<XAttr> filteredAll = XAttrPermissionFilter.filterXAttrsForApi(pc, all, FSDirectory.isReservedRawName(srcArg));
        return filteredAll;
    }

    private static HdfsFileStatus removeXAttrInt(FSDirectory fsd, String srcArg, String src, XAttr xAttr, boolean logRetryCache) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        XAttrPermissionFilter.checkPermissionForApi(pc, xAttr, FSDirectory.isReservedRawName(srcArg));
        INodesInPath iip = fsd.getINodesInPath4Write(src);
        FSDirXAttrOp.checkXAttrChangeAccess(fsd, iip, xAttr, pc);
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
        xAttrs.add(xAttr);
        List<XAttr> removedXAttrs = FSDirXAttrOp.unprotectedRemoveXAttrs(fsd, src, xAttrs);
        if (removedXAttrs == null || removedXAttrs.isEmpty()) {
            throw new IOException("No matching attributes found for remove operation");
        }
        return fsd.getAuditFileInfo(fsd.getINodesInPath(src, false));
    }

    static XAttr unprotectedGetXAttrByName(INode inode, String xAttrName) throws IOException {
        List<XAttr> xAttrs = FSDirXAttrOp.unprotectedGetXAttrs(inode);
        if (xAttrs == null) {
            return null;
        }
        for (XAttr x : xAttrs) {
            if (!XAttrHelper.getPrefixName(x).equals(xAttrName)) continue;
            return x;
        }
        return null;
    }

    private static void checkXAttrsConfigFlag(FSDirectory fsd) throws IOException {
        if (!fsd.isXattrsEnabled()) {
            throw new IOException(String.format("The XAttr operation has been rejected.  Support for XAttrs has been disabled by setting %s to false.", "dfs.namenode.xattrs.enabled"));
        }
    }

    private static void checkXAttrChangeAccess(FSDirectory fsd, INodesInPath iip, XAttr xAttr, FSPermissionChecker pc) throws IOException {
        if (fsd.isPermissionEnabled() && xAttr.getNameSpace() == XAttr.NameSpace.USER) {
            INode inode = iip.getLastINode();
            if (inode != null && inode.isDirectory() && inode.getFsPermission().getStickyBit()) {
                if (!pc.isSuperUser()) {
                    fsd.checkOwner(pc, iip);
                }
            } else {
                fsd.checkPathAccess(pc, iip, FsAction.WRITE);
            }
        }
    }

    public static void checkXAttrSize(FSDirectory fsd, XAttr xAttr) {
        int nameSize = XAttrStorage.getXAttrByteSize(xAttr.getName());
        int valueSize = 0;
        if (xAttr.getValue() != null) {
            valueSize = xAttr.getValue().length;
        }
        if (nameSize > XAttrStorage.getMaxXAttrNameSize()) {
            throw new HadoopIllegalArgumentException("The XAttr name is too big. The maximum size of the name is " + XAttrStorage.getMaxXAttrNameSize() + ", but the name size is " + nameSize);
        }
        if (valueSize > XAttrStorage.getMaxXAttrValueSize()) {
            throw new HadoopIllegalArgumentException("The XAttr value is too big. The maximum size of the value is " + XAttrStorage.getMaxXAttrValueSize() + ", but the value size is " + valueSize);
        }
        int allowedValueSize = fsd.getXattrMaxSize() - XAttrStorage.getMaxXAttrNameSize();
        if (allowedValueSize > 0 && valueSize > allowedValueSize) {
            throw new HadoopIllegalArgumentException("The XAttr value is too big. The maximum size of the value is " + allowedValueSize + ", but the value size is " + valueSize);
        }
        int size = nameSize + valueSize;
        if (size > fsd.getXattrMaxSize()) {
            throw new HadoopIllegalArgumentException("The XAttr is too big. The maximum combined size of the name and value is " + fsd.getXattrMaxSize() + ", but the total size is " + size);
        }
    }

    static void unprotectedSetXAttrs(FSDirectory fsd, String src, List<XAttr> xAttrs, EnumSet<XAttrSetFlag> flag) throws IOException {
        INodesInPath iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(iip);
        FSDirXAttrOp.setINodeXAttrs(fsd, inode, xAttrs, flag);
    }

    static void setINodeXAttrs(FSDirectory fsd, INode inode, List<XAttr> toSet, EnumSet<XAttrSetFlag> flag) throws IOException {
        for (int i = 0; i < toSet.size(); ++i) {
            for (int j = i + 1; j < toSet.size(); ++j) {
                if (!toSet.get(i).equalsIgnoreValue((Object)toSet.get(j))) continue;
                throw new IOException("Cannot specify the same XAttr to be set more than once");
            }
        }
        for (XAttr xAttr : toSet) {
            boolean exists = XAttrStorage.readINodeXAttr(inode, xAttr) != null;
            XAttrSetFlag.validate((String)xAttr.getName(), (boolean)exists, flag);
            FSDirXAttrOp.incrementXAttrs(fsd, inode, xAttr, exists);
            String xaName = XAttrHelper.getPrefixName(xAttr);
            if ("raw.hdfs.crypto.encryption.zone".equals(xaName)) {
                HdfsProtos.ZoneEncryptionInfoProto ezProto = HdfsProtos.ZoneEncryptionInfoProto.parseFrom(xAttr.getValue());
                fsd.ezManager.addEncryptionZone(inode.getId(), PBHelper.convert(ezProto.getSuite()), PBHelper.convert(ezProto.getCryptoProtocolVersion()), ezProto.getKeyName());
            }
            if (!inode.isFile() && "security.hdfs.unreadable.by.superuser".equals(xaName)) {
                throw new IOException("Can only set 'security.hdfs.unreadable.by.superuser' on a file.");
            }
            XAttrStorage.updateINodeXAttr(inode, xAttr, exists);
        }
    }

    private static void incrementXAttrs(FSDirectory fsd, INode inode, XAttr xAttr, boolean xAttrExists) throws IOException {
        if (xAttrExists) {
            return;
        }
        boolean limitsExceeded = false;
        String message = "Cannot add additional %sXAttr to inode, would exceed limit of %d";
        if (FSDirXAttrOp.isUserVisible(xAttr)) {
            if (inode.getNumUserXAttrs() == XAttrStorage.getMaxNumberOfUserXAttrPerInode()) {
                limitsExceeded = true;
            } else {
                inode.incrementUserXAttrs();
                limitsExceeded = inode.getNumUserXAttrs() > fsd.getInodeXAttrsLimit();
            }
            message = String.format(message, "", fsd.getInodeXAttrsLimit());
        } else if (inode.getNumSysXAttrs() == XAttrStorage.getMaxNumberOfSysXAttrPerInode()) {
            limitsExceeded = true;
            message = String.format(message, "System ", XAttrStorage.getMaxNumberOfSysXAttrPerInode());
        } else {
            inode.incrementSysXAttrs();
        }
        if (limitsExceeded) {
            throw new IOException(message);
        }
    }

    private static boolean isUserVisible(XAttr xAttr) {
        return xAttr.getNameSpace() == XAttr.NameSpace.USER || xAttr.getNameSpace() == XAttr.NameSpace.TRUSTED;
    }

    static List<XAttr> getXAttrs(INode inode) throws IOException {
        return FSDirXAttrOp.unprotectedGetXAttrs(inode, Collections.emptyList());
    }

    private static List<XAttr> getXAttrsInt(FSDirectory fsd, String src) throws IOException {
        return FSDirXAttrOp.getXAttrsInt(fsd, src, Collections.emptyList());
    }

    private static List<XAttr> getXAttrsInt(FSDirectory fsd, String src, List<XAttr> xAttrs) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        INodesInPath iip = fsd.getINodesInPath(srcs, true);
        INode inode = FSDirectory.resolveLastINode(iip);
        return FSDirXAttrOp.unprotectedGetXAttrs(inode, xAttrs);
    }

    private static List<XAttr> unprotectedGetXAttrs(INode inode) throws IOException {
        return XAttrStorage.readINodeXAttrs(inode, Collections.emptyList());
    }

    private static List<XAttr> unprotectedGetXAttrs(INode inode, List<XAttr> xAttrs) throws IOException {
        return XAttrStorage.readINodeXAttrs(inode, xAttrs);
    }

    static List<XAttr> unprotectedRemoveXAttrs(FSDirectory fsd, String src, List<XAttr> toRemove) throws IOException {
        INodesInPath iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(iip);
        List<XAttr> storedXAttrs = XAttrStorage.readINodeXAttrs(inode, toRemove);
        for (XAttr xAttr : toRemove) {
            if (!UNREADABLE_BY_SUPERUSER_XATTR.equalsIgnoreValue((Object)xAttr)) continue;
            throw new AccessControlException("The xattr 'security.hdfs.unreadable.by.superuser' can not be deleted.");
        }
        for (XAttr xAttr : storedXAttrs) {
            XAttrStorage.removeINodeXAttr(inode, xAttr);
            FSDirXAttrOp.decrementXAttrs(inode, xAttr);
        }
        if (!storedXAttrs.isEmpty()) {
            return storedXAttrs;
        }
        return null;
    }

    private static void decrementXAttrs(INode inode, XAttr xAttr) throws TransactionContextException, StorageException {
        if (FSDirXAttrOp.isUserVisible(xAttr)) {
            inode.decrementUserXAttrs();
        } else {
            inode.decrementSysXAttrs();
        }
    }
}

