/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.common;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.NetUtils;
import io.hops.hadoop.shaded.org.hamcrest.CoreMatchers;
import java.net.InetSocketAddress;
import org.junit.Assert;
import org.junit.Test;

public class NetUtilsTest
extends ZKTestCase {
    private Integer port = 1234;
    private String v4addr = "127.0.0.1";
    private String v6addr = "[0:0:0:0:0:0:0:1]";
    private String v6addr2 = "[2600:0:0:0:0:0:0:0]";
    private String v4local = this.v4addr + ":" + this.port.toString();
    private String v6local = this.v6addr + ":" + this.port.toString();
    private String v6ext = this.v6addr2 + ":" + this.port.toString();

    @Test
    public void testFormatInetAddrGoodIpv4() {
        InetSocketAddress isa = new InetSocketAddress(this.v4addr, (int)this.port);
        Assert.assertEquals((Object)"127.0.0.1:1234", (Object)NetUtils.formatInetAddr(isa));
    }

    @Test
    public void testFormatInetAddrGoodIpv6Local() {
        InetSocketAddress isa = new InetSocketAddress("::1", (int)this.port);
        Assert.assertEquals((Object)this.v6local, (Object)NetUtils.formatInetAddr(isa));
    }

    @Test
    public void testFormatInetAddrGoodIpv6Ext() {
        InetSocketAddress isa = new InetSocketAddress("2600::", (int)this.port);
        Assert.assertEquals((Object)this.v6ext, (Object)NetUtils.formatInetAddr(isa));
    }

    @Test
    public void testFormatInetAddrGoodHostname() {
        InetSocketAddress isa = new InetSocketAddress("localhost", 1234);
        Assert.assertThat((Object)NetUtils.formatInetAddr(isa), CoreMatchers.anyOf(CoreMatchers.equalTo(this.v4local), CoreMatchers.equalTo(this.v6local)));
    }

    @Test
    public void testFormatAddrUnresolved() {
        InetSocketAddress isa = InetSocketAddress.createUnresolved("doesnt.exist.com", 1234);
        Assert.assertEquals((Object)"doesnt.exist.com:1234", (Object)NetUtils.formatInetAddr(isa));
    }

    @Test(expected=IllegalArgumentException.class)
    public void tetGetIPV6HostAndPort_WhenHostDoesNotEndWithBracket() {
        NetUtils.getIPV6HostAndPort("[2001:0db8:85a3:0000:0000:8a2e:0370:7334:443");
    }

    @Test(expected=IllegalArgumentException.class)
    public void tetGetIPV6HostAndPort_WhenNoPortAfterColon() {
        NetUtils.getIPV6HostAndPort("[2001:0db8:85a3:0000:0000:8a2e:0370:7334]:");
    }

    @Test(expected=IllegalArgumentException.class)
    public void tetGetIPV6HostAndPort_WhenPortIsNotSeparatedProperly() {
        NetUtils.getIPV6HostAndPort("[2001:0db8:85a3:0000:0000:8a2e:0370:7334]2181");
    }

    @Test(expected=IllegalArgumentException.class)
    public void tetGetIPV6HostAndPort_WhenHostIsEmpty() {
        NetUtils.getIPV6HostAndPort("[]:2181");
    }

    @Test
    public void tetGetIPV6HostAndPort_EmptyStringArrayIfDoesNotStartWithBracket() {
        String[] ipv6HostAndPort = NetUtils.getIPV6HostAndPort("2001:0db8:85a3:0000:0000:8a2e:0370:7334]");
        Assert.assertEquals((long)0L, (long)ipv6HostAndPort.length);
    }

    @Test
    public void tetGetIPV6HostAndPort_ReturnHostPort() {
        String[] ipv6HostAndPort = NetUtils.getIPV6HostAndPort("[2001:0db8:85a3:0000:0000:8a2e:0370:7334]:2181");
        Assert.assertEquals((long)2L, (long)ipv6HostAndPort.length);
        Assert.assertEquals((Object)"2001:0db8:85a3:0000:0000:8a2e:0370:7334", (Object)ipv6HostAndPort[0]);
        Assert.assertEquals((Object)"2181", (Object)ipv6HostAndPort[1]);
    }

    @Test
    public void tetGetIPV6HostAndPort_ReturnHostPortPort() {
        String[] ipv6HostAndPort = NetUtils.getIPV6HostAndPort("[2001:0db8:85a3:0000:0000:8a2e:0370:7334]:2181:3181");
        Assert.assertEquals((long)2L, (long)ipv6HostAndPort.length);
        Assert.assertEquals((Object)"2001:0db8:85a3:0000:0000:8a2e:0370:7334", (Object)ipv6HostAndPort[0]);
        Assert.assertEquals((Object)"2181:3181", (Object)ipv6HostAndPort[1]);
    }
}

