/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.Op;
import io.hops.hadoop.shaded.org.apache.zookeeper.OpResult;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Id;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.CreateRequest;
import io.hops.hadoop.shaded.org.apache.zookeeper.proto.GetDataRequest;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.Request;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiOpSessionUpgradeTest
extends QuorumBase {
    protected static final Logger LOG = LoggerFactory.getLogger(MultiOpSessionUpgradeTest.class);

    @Override
    public void setUp() throws Exception {
        this.localSessionsEnabled = true;
        this.localSessionsUpgradingEnabled = true;
        super.setUp();
    }

    @Test
    public void ephemeralCreateMultiOpTest() throws KeeperException, InterruptedException, IOException {
        TestableZooKeeper zk = this.createClient();
        String data = "test";
        String path = "/ephemeralcreatemultiop";
        zk.create(path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        QuorumZooKeeperServer server = this.getConnectedServer(zk.getSessionId());
        Assert.assertNotNull((String)"unable to find server interlocutor", (Object)server);
        UpgradeableSessionTracker sessionTracker = (UpgradeableSessionTracker)server.getSessionTracker();
        Assert.assertFalse((String)"session already global", (boolean)sessionTracker.isGlobalSession(zk.getSessionId()));
        List<OpResult> multi = null;
        try {
            multi = zk.multi(Arrays.asList(Op.setData(path, data.getBytes(), 0), Op.create(path + "/e", data.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL), Op.create(path + "/p", data.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT), Op.create(path + "/q", data.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL)));
        }
        catch (KeeperException.SessionExpiredException e) {
            Assert.fail((String)"received session expired for a session promotion in a multi-op");
        }
        Assert.assertNotNull(multi);
        Assert.assertEquals((long)4L, (long)multi.size());
        Assert.assertEquals((Object)data, (Object)new String(zk.getData(path + "/e", false, null)));
        Assert.assertEquals((Object)data, (Object)new String(zk.getData(path + "/p", false, null)));
        Assert.assertEquals((Object)data, (Object)new String(zk.getData(path + "/q", false, null)));
        Assert.assertTrue((String)"session not promoted", (boolean)sessionTracker.isGlobalSession(zk.getSessionId()));
    }

    @Test
    public void directCheckUpgradeSessionTest() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        String path = "/directcheckupgradesession";
        zk.create(path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        QuorumZooKeeperServer server = this.getConnectedServer(zk.getSessionId());
        Assert.assertNotNull((String)"unable to find server interlocutor", (Object)server);
        Request readRequest = this.makeGetDataRequest(path, zk.getSessionId());
        Request createRequest = this.makeCreateRequest(path + "/e", zk.getSessionId());
        Assert.assertNull((String)"tried to upgrade on a read", (Object)server.checkUpgradeSession(readRequest));
        Assert.assertNotNull((String)"failed to upgrade on a create", (Object)server.checkUpgradeSession(createRequest));
        Assert.assertNull((String)"tried to upgrade after successful promotion", (Object)server.checkUpgradeSession(createRequest));
    }

    private Request makeGetDataRequest(String path, long sessionId) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(boas);
        GetDataRequest getDataRequest = new GetDataRequest(path, false);
        getDataRequest.serialize(boa, "request");
        ByteBuffer bb = ByteBuffer.wrap(boas.toByteArray());
        return new Request(null, sessionId, 1, 4, bb, new ArrayList<Id>());
    }

    private Request makeCreateRequest(String path, long sessionId) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(boas);
        CreateRequest createRequest = new CreateRequest(path, "data".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL.toFlag());
        createRequest.serialize(boa, "request");
        ByteBuffer bb = ByteBuffer.wrap(boas.toByteArray());
        return new Request(null, sessionId, 1, 15, bb, new ArrayList<Id>());
    }

    private QuorumZooKeeperServer getConnectedServer(long sessionId) {
        for (QuorumPeer peer : this.getPeerList()) {
            if (!peer.getActiveServer().getSessionTracker().isTrackingSession(sessionId)) continue;
            return (QuorumZooKeeperServer)peer.getActiveServer();
        }
        return null;
    }
}

