/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.TxnLog;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.persistence.Util;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPacket;
import java.io.IOException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnLogProposalIterator
implements Iterator<Leader.Proposal> {
    private static final Logger LOG = LoggerFactory.getLogger(TxnLogProposalIterator.class);
    public static final TxnLogProposalIterator EMPTY_ITERATOR = new TxnLogProposalIterator();
    private boolean hasNext = false;
    private TxnLog.TxnIterator itr;

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Leader.Proposal next() {
        Leader.Proposal p = new Leader.Proposal();
        try {
            QuorumPacket pp;
            byte[] serializedData = Util.marshallTxnEntry(this.itr.getHeader(), this.itr.getTxn(), this.itr.getDigest());
            p.packet = pp = new QuorumPacket(2, this.itr.getHeader().getZxid(), serializedData, null);
            p.request = null;
            this.hasNext = this.itr.next();
        }
        catch (IOException e) {
            LOG.error("Unable to read txnlog from disk", (Throwable)e);
            this.hasNext = false;
        }
        return p;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.itr != null) {
            try {
                this.itr.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error closing file iterator", (Throwable)ioe);
            }
        }
    }

    private TxnLogProposalIterator() {
    }

    public TxnLogProposalIterator(TxnLog.TxnIterator itr) {
        if (itr != null) {
            this.itr = itr;
            this.hasNext = itr.getHeader() != null;
        }
    }
}

