/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.http.jmx;

import io.hops.hadoop.shaded.org.glassfish.gmbal.Description;
import io.hops.hadoop.shaded.org.glassfish.gmbal.GmbalMBean;
import io.hops.hadoop.shaded.org.glassfish.gmbal.ManagedAttribute;
import io.hops.hadoop.shaded.org.glassfish.gmbal.ManagedObject;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Buffer;
import io.hops.hadoop.shaded.org.glassfish.grizzly.Connection;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.ContentEncoding;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpContent;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpHeader;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpPacket;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpProbe;
import io.hops.hadoop.shaded.org.glassfish.grizzly.http.TransferEncoding;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.GrizzlyJmxManager;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.JmxObject;
import java.util.concurrent.atomic.AtomicLong;

@ManagedObject
@Description(value="This Filter is responsible for the parsing incoming HTTP packets and serializing high level objects back into the HTTP protocol format.")
public class HttpCodecFilter
extends JmxObject {
    private final io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpCodecFilter httpCodecFilter;
    private final AtomicLong httpContentReceived = new AtomicLong();
    private final AtomicLong httpContentWritten = new AtomicLong();
    private final AtomicLong httpCodecErrorCount = new AtomicLong();
    private final HttpProbe probe = new JmxHttpProbe();

    public HttpCodecFilter(io.hops.hadoop.shaded.org.glassfish.grizzly.http.HttpCodecFilter httpCodecFilter) {
        this.httpCodecFilter = httpCodecFilter;
    }

    @Override
    public String getJmxName() {
        return "HttpCodecFilter";
    }

    @Override
    protected void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        this.httpCodecFilter.getMonitoringConfig().addProbes(this.probe);
    }

    @Override
    protected void onDeregister(GrizzlyJmxManager mom) {
        this.httpCodecFilter.getMonitoringConfig().removeProbes(this.probe);
    }

    @ManagedAttribute(id="total-bytes-received")
    @Description(value="The total number of bytes this filter has processed as part of the HTTP protocol parsing process.")
    public long getTotalContentReceived() {
        return this.httpContentReceived.get();
    }

    @ManagedAttribute(id="total-bytes-written")
    @Description(value="The total number of bytes that have been written as part of the serialization process to the HTTP protocol.")
    public long getTotalContentWritten() {
        return this.httpContentWritten.get();
    }

    @ManagedAttribute(id="http-codec-error-count")
    @Description(value="The total number of protocol errors that have occurred during either the parsing or serialization process.")
    public long getHttpCodecErrorCount() {
        return this.httpCodecErrorCount.get();
    }

    private final class JmxHttpProbe
    implements HttpProbe {
        private JmxHttpProbe() {
        }

        @Override
        public void onDataReceivedEvent(Connection connection, Buffer buffer) {
            HttpCodecFilter.this.httpContentReceived.addAndGet(buffer.remaining());
        }

        @Override
        public void onDataSentEvent(Connection connection, Buffer buffer) {
            HttpCodecFilter.this.httpContentWritten.addAndGet(buffer.remaining());
        }

        @Override
        public void onErrorEvent(Connection connection, HttpPacket httpPacket, Throwable error) {
            HttpCodecFilter.this.httpCodecErrorCount.incrementAndGet();
        }

        @Override
        public void onHeaderParseEvent(Connection connection, HttpHeader header, int size) {
        }

        @Override
        public void onHeaderSerializeEvent(Connection connection, HttpHeader header, Buffer buffer) {
        }

        @Override
        public void onContentChunkParseEvent(Connection connection, HttpContent content) {
        }

        @Override
        public void onContentChunkSerializeEvent(Connection connection, HttpContent content) {
        }

        @Override
        public void onContentEncodingParseEvent(Connection connection, HttpHeader header, Buffer buffer, ContentEncoding contentEncoding) {
        }

        @Override
        public void onContentEncodingSerializeEvent(Connection connection, HttpHeader header, Buffer buffer, ContentEncoding contentEncoding) {
        }

        @Override
        public void onTransferEncodingParseEvent(Connection connection, HttpHeader header, Buffer buffer, TransferEncoding transferEncoding) {
        }

        @Override
        public void onTransferEncodingSerializeEvent(Connection connection, HttpHeader header, Buffer buffer, TransferEncoding transferEncoding) {
        }
    }
}

