/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.QuotaUpdate;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.namenode.INode;

final class QuotaUpdateLock
extends Lock {
    private final int limit;
    private final long inodeID;

    QuotaUpdateLock(long inodeID, int limit) {
        this.inodeID = inodeID;
        this.limit = limit;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        if (this.inodeID != (long)INode.NON_EXISTING_INODE_ID) {
            this.acquireLockList(DEFAULT_LOCK_TYPE, (FinderType)QuotaUpdate.Finder.ByINodeId, new Object[]{this.inodeID, this.limit});
        }
    }

    protected final Lock.Type getType() {
        return Lock.Type.QuotaUpdate;
    }
}

