/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper;

import io.hops.hadoop.shaded.org.apache.zookeeper.DummyWatcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.client.HostProvider;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class CustomHostProviderTest
extends ZKTestCase {
    private AtomicInteger counter = new AtomicInteger(3);

    @Test
    public void testZooKeeperWithCustomHostProvider() throws IOException, InterruptedException {
        int CLIENT_PORT = PortAssignment.unique();
        SpecialHostProvider specialHostProvider = new SpecialHostProvider();
        int expectedCounter = 3;
        this.counter.set(expectedCounter);
        ZooKeeper zkDefaults = new ZooKeeper("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE, false);
        ZooKeeper zkSpecial = new ZooKeeper("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE, false, specialHostProvider);
        Assert.assertTrue((this.counter.get() == expectedCounter ? 1 : 0) != 0);
        zkDefaults.updateServerList("127.0.0.1:" + PortAssignment.unique());
        Assert.assertTrue((this.counter.get() == expectedCounter ? 1 : 0) != 0);
        zkSpecial.updateServerList("127.0.0.1:" + PortAssignment.unique());
        Assert.assertTrue((this.counter.get() == --expectedCounter ? 1 : 0) != 0);
    }

    private class SpecialHostProvider
    implements HostProvider {
        private SpecialHostProvider() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public InetSocketAddress next(long spinDelay) {
            return new InetSocketAddress("127.0.0.1", 2181);
        }

        @Override
        public void onConnected() {
        }

        @Override
        public boolean updateServerList(Collection<InetSocketAddress> serverAddresses, InetSocketAddress currentHost) {
            CustomHostProviderTest.this.counter.decrementAndGet();
            return false;
        }
    }
}

