/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.glassfish.grizzly.memory.jmx;

import io.hops.hadoop.shaded.org.glassfish.gmbal.Description;
import io.hops.hadoop.shaded.org.glassfish.gmbal.GmbalMBean;
import io.hops.hadoop.shaded.org.glassfish.gmbal.ManagedAttribute;
import io.hops.hadoop.shaded.org.glassfish.gmbal.ManagedObject;
import io.hops.hadoop.shaded.org.glassfish.gmbal.NameValue;
import io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryProbe;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.GrizzlyJmxManager;
import io.hops.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.JmxObject;
import java.util.concurrent.atomic.AtomicLong;

@ManagedObject
@Description(value="Grizzly Memory Manager")
public class MemoryManager
extends JmxObject {
    protected final io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager memoryManager;
    private final MemoryProbe probe;
    private final AtomicLong totalAllocatedBytes = new AtomicLong();
    private final AtomicLong realAllocatedBytes = new AtomicLong();
    private final AtomicLong poolAllocatedBytes = new AtomicLong();
    private final AtomicLong poolReleasedBytes = new AtomicLong();

    public MemoryManager(io.hops.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        this.probe = new JmxMemoryProbe();
    }

    @Override
    public String getJmxName() {
        return "MemoryManager";
    }

    @Override
    protected void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        this.memoryManager.getMonitoringConfig().addProbes(this.probe);
    }

    @Override
    protected void onDeregister(GrizzlyJmxManager mom) {
        this.memoryManager.getMonitoringConfig().removeProbes(this.probe);
    }

    @NameValue
    public String getMemoryManagerType() {
        return this.memoryManager.getClass().getName();
    }

    @ManagedAttribute(id="total-allocated-bytes")
    @Description(value="Total number of allocated bytes (real + pool)")
    public long getTotalAllocatedBytes() {
        return this.totalAllocatedBytes.get();
    }

    @ManagedAttribute(id="real-allocated-bytes")
    @Description(value="Total number of bytes allocated using ByteBuffer.allocate(...) operation")
    public long getRealAllocatedBytes() {
        return this.realAllocatedBytes.get();
    }

    @ManagedAttribute(id="pool-allocated-bytes")
    @Description(value="Total number of bytes allocated from memory pool")
    public long getPoolAllocatedBytes() {
        return this.poolAllocatedBytes.get();
    }

    @ManagedAttribute(id="pool-released-bytes")
    @Description(value="Total number of bytes released to memory pool")
    public long getPoolReleasedBytes() {
        return this.poolReleasedBytes.get();
    }

    private class JmxMemoryProbe
    implements MemoryProbe {
        private JmxMemoryProbe() {
        }

        @Override
        public void onBufferAllocateEvent(int size) {
            MemoryManager.this.totalAllocatedBytes.addAndGet(size);
            MemoryManager.this.realAllocatedBytes.addAndGet(size);
        }

        @Override
        public void onBufferAllocateFromPoolEvent(int size) {
            MemoryManager.this.totalAllocatedBytes.addAndGet(size);
            MemoryManager.this.poolAllocatedBytes.addAndGet(size);
        }

        @Override
        public void onBufferReleaseToPoolEvent(int size) {
            MemoryManager.this.poolReleasedBytes.addAndGet(size);
        }
    }
}

