/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.audit;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.audit.AuditLogPerfReading;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.Time;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKAuditLoggerPerformance {
    private static final Logger LOG = LoggerFactory.getLogger(ZKAuditLoggerPerformance.class);
    private ZooKeeper zkClient;
    private String parentPath;
    private int numberOfRecords;

    public ZKAuditLoggerPerformance(ZooKeeper zkClient, String parentPath, int numberOfRecords) {
        this.zkClient = zkClient;
        this.parentPath = parentPath;
        this.numberOfRecords = numberOfRecords;
    }

    public void create() throws Exception {
        for (int i = 0; i < this.numberOfRecords; ++i) {
            this.zkClient.create(this.getPath(i), "0123456789".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    public void setData() throws Exception {
        for (int i = 0; i < this.numberOfRecords; ++i) {
            this.zkClient.setData(this.getPath(i), "9876543210".getBytes(), -1);
        }
    }

    public void delete() throws Exception {
        for (int i = 0; i < this.numberOfRecords; ++i) {
            this.zkClient.delete(this.getPath(i), -1);
        }
    }

    public AuditLogPerfReading doOperations() throws Exception {
        AuditLogPerfReading perfReading = new AuditLogPerfReading();
        long startTime = Time.currentElapsedTime();
        this.create();
        perfReading.setCreate(Time.currentElapsedTime() - startTime);
        startTime = Time.currentElapsedTime();
        this.setData();
        perfReading.setSetData(Time.currentElapsedTime() - startTime);
        startTime = Time.currentElapsedTime();
        this.delete();
        perfReading.setDelete(Time.currentElapsedTime() - startTime);
        return perfReading;
    }

    private String getPath(int i) {
        return this.parentPath + "zNode" + i;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("USAGE: ZKAuditLoggerPerformance connectionString parentPath numberOfRecords");
            System.exit(1);
        }
        String cxnString = args[0];
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zkClient = null;
        try {
            zkClient = new ZooKeeper(cxnString, 60000, watcher);
            watcher.waitForConnected(30000L);
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            String msg = "ZooKeeper client can not connect to " + cxnString;
            ZKAuditLoggerPerformance.logErrorAndExit(e, msg);
        }
        String parentPath = args[1];
        try {
            Stat exists = zkClient.exists(parentPath, false);
            if (exists == null) {
                System.err.println("Parent path '" + parentPath + "' must exist.");
                System.exit(1);
            }
        }
        catch (KeeperException | InterruptedException e1) {
            String msg = "Error while checking the existence of parent path";
            ZKAuditLoggerPerformance.logErrorAndExit(e1, msg);
        }
        int recordCount = 0;
        try {
            recordCount = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            String msg = "Failed to parse '" + args[2] + "' to integer";
            LOG.error(msg, (Throwable)e);
            System.err.println(msg);
            System.exit(1);
        }
        ZKAuditLoggerPerformance auditLoggingPerf = new ZKAuditLoggerPerformance(zkClient, parentPath, recordCount);
        AuditLogPerfReading doOperations = null;
        try {
            doOperations = auditLoggingPerf.doOperations();
        }
        catch (Exception e) {
            String msg = "Error while doing operations.";
            LOG.error(msg, (Throwable)e);
            System.err.println(msg);
            System.exit(1);
        }
        System.out.println("Time taken for " + recordCount + " operations are:");
        System.out.println(doOperations.report());
        System.exit(0);
    }

    private static void logErrorAndExit(Exception e, String msg) {
        LOG.error(msg, (Throwable)e);
        System.err.println(msg + ", error=" + e.getMessage());
        System.exit(1);
    }
}

