/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server;

import io.hops.hadoop.shaded.io.netty.channel.Channel;
import io.hops.hadoop.shaded.io.netty.channel.EventLoop;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.metrics.MetricsUtils;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.NIOServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.NIOServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.NettyServerCnxn;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.NettyServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SessionTrackerImpl;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumUtil;
import io.hops.hadoop.shaded.org.mockito.ArgumentMatchers;
import io.hops.hadoop.shaded.org.mockito.Mockito;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionMetricsTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(ConnectionMetricsTest.class);

    @Test
    public void testRevalidateCount() throws Exception {
        ServerMetrics.getMetrics().resetAll();
        QuorumUtil util = new QuorumUtil(1);
        util.enableLocalSession(false);
        util.startAll();
        int follower1 = (int)util.getFollowerQuorumPeers().get(0).getId();
        int follower2 = (int)util.getFollowerQuorumPeers().get(1).getId();
        LOG.info("connecting to server: {}", (Object)follower1);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(util.getConnectionStringForServer(follower1), ClientBase.CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        LOG.info("connected");
        zk.updateServerList(util.getConnectionStringForServer(follower2));
        util.shutdown(follower1);
        watcher.waitForDisconnected(ClientBase.CONNECTION_TIMEOUT);
        LOG.info("disconnected");
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        LOG.info("reconnected");
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)1L, (Object)values.get("connection_revalidate_count"));
        Assert.assertEquals((Object)1L, (Object)values.get("revalidate_count"));
        zk.close();
        util.shutdownAll();
    }

    private NIOServerCnxn createMockNIOCnxn() throws IOException {
        InetSocketAddress socketAddr = new InetSocketAddress(80);
        Socket socket = Mockito.mock(Socket.class);
        Mockito.when(socket.getRemoteSocketAddress()).thenReturn(socketAddr);
        SocketChannel sock = Mockito.mock(SocketChannel.class);
        Mockito.when(sock.socket()).thenReturn(socket);
        Mockito.when(sock.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenReturn(-1);
        return new MockNIOServerCnxn(Mockito.mock(ZooKeeperServer.class), sock, null, Mockito.mock(NIOServerCnxnFactory.class), null);
    }

    @Test
    public void testNIOConnectionDropCount() throws Exception {
        ServerMetrics.getMetrics().resetAll();
        NIOServerCnxn cnxn = this.createMockNIOCnxn();
        cnxn.doIO(new FakeSK());
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)1L, (Object)values.get("connection_drop_count"));
    }

    @Test
    public void testNettyConnectionDropCount() throws Exception {
        InetSocketAddress socketAddr = new InetSocketAddress(80);
        Channel channel = Mockito.mock(Channel.class);
        Mockito.when(channel.isOpen()).thenReturn(false);
        Mockito.when(channel.remoteAddress()).thenReturn(socketAddr);
        EventLoop eventLoop = Mockito.mock(EventLoop.class);
        Mockito.when(channel.eventLoop()).thenReturn(eventLoop);
        ServerMetrics.getMetrics().resetAll();
        NettyServerCnxnFactory factory = new NettyServerCnxnFactory();
        NettyServerCnxn cnxn = new NettyServerCnxn(channel, Mockito.mock(ZooKeeperServer.class), factory);
        factory.cnxns.add(cnxn);
        cnxn.close();
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)1L, (Object)values.get("connection_drop_count"));
    }

    @Test
    public void testSessionlessConnectionsExpired() throws Exception {
        NIOServerCnxnFactory factory = new NIOServerCnxnFactory();
        factory.configure(new InetSocketAddress(PortAssignment.unique()), 1000);
        ((ServerCnxnFactory)factory).start();
        int timeout = Integer.getInteger("zookeeper.nio.sessionlessCnxnTimeout", 10000);
        ServerMetrics.getMetrics().resetAll();
        factory.touchCnxn(this.createMockNIOCnxn());
        factory.touchCnxn(this.createMockNIOCnxn());
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        for (int sleptTime = 0; values.get("sessionless_connections_expired") == null || sleptTime < 2 * timeout; sleptTime += 100) {
            Thread.sleep(100L);
            values = MetricsUtils.currentServerMetrics();
        }
        Assert.assertEquals((Object)2L, (Object)values.get("sessionless_connections_expired"));
        ((ServerCnxnFactory)factory).shutdown();
    }

    @Test
    public void testStaleSessionsExpired() throws Exception {
        int tickTime = 1000;
        SessionTrackerImpl tracker = new SessionTrackerImpl(Mockito.mock(ZooKeeperServer.class), new ConcurrentHashMap<Long, Integer>(), tickTime, 1L, null);
        tracker.sessionsById.put(1L, Mockito.mock(SessionTrackerImpl.SessionImpl.class));
        tracker.sessionsById.put(2L, Mockito.mock(SessionTrackerImpl.SessionImpl.class));
        tracker.touchSession(1L, tickTime);
        tracker.touchSession(2L, tickTime);
        ServerMetrics.getMetrics().resetAll();
        tracker.start();
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        for (int sleptTime = 0; values.get("stale_sessions_expired") == null || sleptTime < 2 * tickTime; sleptTime += 100) {
            Thread.sleep(100L);
            values = MetricsUtils.currentServerMetrics();
        }
        Assert.assertEquals((Object)2L, (Object)values.get("stale_sessions_expired"));
        tracker.shutdown();
    }

    private static class FakeSK
    extends SelectionKey {
        private int ops = 5;

        private FakeSK() {
        }

        @Override
        public SelectableChannel channel() {
            return null;
        }

        @Override
        public Selector selector() {
            return Mockito.mock(Selector.class);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void cancel() {
        }

        @Override
        public int interestOps() {
            return this.ops;
        }

        @Override
        public SelectionKey interestOps(int ops) {
            this.ops = ops;
            return this;
        }

        @Override
        public int readyOps() {
            return this.ops;
        }
    }

    private class MockNIOServerCnxn
    extends NIOServerCnxn {
        public MockNIOServerCnxn(ZooKeeperServer zk, SocketChannel sock, SelectionKey sk, NIOServerCnxnFactory factory, NIOServerCnxnFactory.SelectorThread selectorThread) throws IOException {
            super(zk, sock, sk, factory, selectorThread);
        }

        @Override
        protected boolean isSocketOpen() {
            return true;
        }
    }
}

