/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.common;

import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.common.KeyStoreFileType;
import org.junit.Assert;
import org.junit.Test;

public class KeyStoreFileTypeTest
extends ZKTestCase {
    @Test
    public void testGetPropertyValue() {
        Assert.assertEquals((Object)"PEM", (Object)KeyStoreFileType.PEM.getPropertyValue());
        Assert.assertEquals((Object)"JKS", (Object)KeyStoreFileType.JKS.getPropertyValue());
        Assert.assertEquals((Object)"PKCS12", (Object)KeyStoreFileType.PKCS12.getPropertyValue());
        Assert.assertEquals((Object)"BCFKS", (Object)KeyStoreFileType.BCFKS.getPropertyValue());
    }

    @Test
    public void testFromPropertyValue() {
        Assert.assertEquals((Object)((Object)KeyStoreFileType.PEM), (Object)((Object)KeyStoreFileType.fromPropertyValue("PEM")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.JKS), (Object)((Object)KeyStoreFileType.fromPropertyValue("JKS")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.PKCS12), (Object)((Object)KeyStoreFileType.fromPropertyValue("PKCS12")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.BCFKS), (Object)((Object)KeyStoreFileType.fromPropertyValue("BCFKS")));
        Assert.assertNull((Object)((Object)KeyStoreFileType.fromPropertyValue("")));
        Assert.assertNull((Object)((Object)KeyStoreFileType.fromPropertyValue(null)));
    }

    @Test
    public void testFromPropertyValueIgnoresCase() {
        Assert.assertEquals((Object)((Object)KeyStoreFileType.PEM), (Object)((Object)KeyStoreFileType.fromPropertyValue("pem")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.JKS), (Object)((Object)KeyStoreFileType.fromPropertyValue("jks")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.PKCS12), (Object)((Object)KeyStoreFileType.fromPropertyValue("pkcs12")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.BCFKS), (Object)((Object)KeyStoreFileType.fromPropertyValue("bcfks")));
        Assert.assertNull((Object)((Object)KeyStoreFileType.fromPropertyValue("")));
        Assert.assertNull((Object)((Object)KeyStoreFileType.fromPropertyValue(null)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromPropertyValueThrowsOnBadPropertyValue() {
        KeyStoreFileType.fromPropertyValue("foobar");
    }

    @Test
    public void testFromFilename() {
        Assert.assertEquals((Object)((Object)KeyStoreFileType.JKS), (Object)((Object)KeyStoreFileType.fromFilename("mykey.jks")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.JKS), (Object)((Object)KeyStoreFileType.fromFilename("/path/to/key/dir/mykey.jks")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.PEM), (Object)((Object)KeyStoreFileType.fromFilename("mykey.pem")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.PEM), (Object)((Object)KeyStoreFileType.fromFilename("/path/to/key/dir/mykey.pem")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.PKCS12), (Object)((Object)KeyStoreFileType.fromFilename("mykey.p12")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.PKCS12), (Object)((Object)KeyStoreFileType.fromFilename("/path/to/key/dir/mykey.p12")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.BCFKS), (Object)((Object)KeyStoreFileType.fromFilename("mykey.bcfks")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.BCFKS), (Object)((Object)KeyStoreFileType.fromFilename("/path/to/key/dir/mykey.bcfks")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromFilenameThrowsOnBadFileExtension() {
        KeyStoreFileType.fromFilename("prod.key");
    }

    @Test
    public void testFromPropertyValueOrFileName() {
        Assert.assertEquals((Object)((Object)KeyStoreFileType.JKS), (Object)((Object)KeyStoreFileType.fromPropertyValueOrFileName("JKS", "prod.key")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.PEM), (Object)((Object)KeyStoreFileType.fromPropertyValueOrFileName("PEM", "prod.key")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.PKCS12), (Object)((Object)KeyStoreFileType.fromPropertyValueOrFileName("PKCS12", "prod.key")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.BCFKS), (Object)((Object)KeyStoreFileType.fromPropertyValueOrFileName("BCFKS", "prod.key")));
        Assert.assertEquals((Object)((Object)KeyStoreFileType.JKS), (Object)((Object)KeyStoreFileType.fromPropertyValueOrFileName("", "prod.jks")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromPropertyValueOrFileNameThrowsOnBadPropertyValue() {
        KeyStoreFileType.fromPropertyValueOrFileName("foobar", "prod.jks");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromPropertyValueOrFileNameThrowsOnBadFileExtension() {
        KeyStoreFileType.fromPropertyValueOrFileName("", "prod.key");
    }
}

