/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.terracotta.offheapstore.set;

import io.hops.hadoop.shaded.org.terracotta.offheapstore.OffHeapHashMap;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.paging.PageSource;
import io.hops.hadoop.shaded.org.terracotta.offheapstore.storage.StorageEngine;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

public class OffHeapHashSet<E>
extends AbstractSet<E> {
    private final OffHeapHashMap<E, Boolean> map;

    public OffHeapHashSet(PageSource source, boolean tableSteals, StorageEngine<? super E, Boolean> engine, int capacity) {
        this(new OffHeapHashMap<E, Boolean>(source, tableSteals, engine, capacity));
    }

    public OffHeapHashSet(OffHeapHashMap<E, Boolean> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.map.keySet().toArray(ts);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> clctn) {
        return this.map.keySet().containsAll(clctn);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public StorageEngine<? super E, ?> getStorageEngine() {
        return this.map.getStorageEngine();
    }
}

