/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc;

import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.Column;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLIdentifier;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerException;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.StreamPacket;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.TDSReader;
import io.hops.hadoop.shaded.com.microsoft.sqlserver.jdbc.TDSReaderMark;

final class StreamTabName
extends StreamPacket {
    private TDSReader tdsReader;
    private TDSReaderMark tableNamesMark;

    StreamTabName() {
        super(164);
    }

    @Override
    void setFromTDS(TDSReader tdsReader) throws SQLServerException {
        if (164 != tdsReader.readUnsignedByte()) assert (false) : "Not a TABNAME token";
        this.tdsReader = tdsReader;
        int tokenLength = tdsReader.readUnsignedShort();
        this.tableNamesMark = tdsReader.mark();
        tdsReader.skip(tokenLength);
    }

    void applyTo(Column[] columns, int numTables) throws SQLServerException {
        int i;
        TDSReaderMark currentMark = this.tdsReader.mark();
        this.tdsReader.reset(this.tableNamesMark);
        SQLIdentifier[] tableNames = new SQLIdentifier[numTables];
        for (i = 0; i < numTables; ++i) {
            tableNames[i] = this.tdsReader.readSQLIdentifier();
        }
        for (i = 0; i < columns.length; ++i) {
            Column col = columns[i];
            if (col.getTableNum() <= 0) continue;
            col.setTableName(tableNames[col.getTableNum() - 1]);
        }
        this.tdsReader.reset(currentMark);
    }
}

