/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.Vote;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.HierarchicalQuorumTest;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.QuorumBase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLEZeroWeightTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(HierarchicalQuorumTest.class);
    Properties qp;
    int count;
    Map<Long, QuorumPeer.QuorumServer> peers;
    ArrayList<LEThread> threads;
    File[] tmpdir;
    int[] port;
    volatile Vote[] votes;

    @Before
    public void setUp() throws Exception {
        this.count = 9;
        this.peers = new HashMap<Long, QuorumPeer.QuorumServer>(this.count);
        this.threads = new ArrayList(this.count);
        this.votes = new Vote[this.count];
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        String config = "group.1=0:1:2\ngroup.2=3:4:5\ngroup.3=6:7:8\nweight.0=1\nweight.1=1\nweight.2=1\nweight.3=0\nweight.4=0\nweight.5=0\nweight.6=0\nweight.7=0\nweight.8=0";
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.qp = new Properties();
        this.qp.load(is);
    }

    @After
    public void tearDown() throws Exception {
        for (int i = 0; i < this.threads.size(); ++i) {
            LEThread leThread = this.threads.get(i);
            QuorumBase.shutdown(leThread.peer);
        }
    }

    @Test
    public void testZeroWeightQuorum() throws Exception {
        int i;
        LOG.info("TestZeroWeightQuorum: {}, {}", (Object)this.getTestName(), (Object)this.count);
        for (i = 0; i < this.count; ++i) {
            InetSocketAddress addr1 = new InetSocketAddress("127.0.0.1", PortAssignment.unique());
            InetSocketAddress addr2 = new InetSocketAddress("127.0.0.1", PortAssignment.unique());
            InetSocketAddress addr3 = new InetSocketAddress("127.0.0.1", PortAssignment.unique());
            this.port[i] = addr3.getPort();
            this.qp.setProperty("server." + i, "127.0.0.1:" + addr1.getPort() + ":" + addr2.getPort() + ";" + this.port[i]);
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, addr1, addr2, addr3));
            this.tmpdir[i] = ClientBase.createTmpDir();
        }
        for (i = 0; i < this.count; ++i) {
            QuorumHierarchical hq = new QuorumHierarchical(this.qp);
            QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[i], this.tmpdir[i], this.port[i], 3, i, 1000, 2, 2, 2, hq);
            peer.startLeaderElection();
            LEThread thread = new LEThread(peer, i);
            thread.start();
            this.threads.add(thread);
        }
        LOG.info("Started threads {}", (Object)this.getTestName());
        for (i = 0; i < this.threads.size(); ++i) {
            this.threads.get(i).join(15000L);
            if (this.threads.get(i).isAlive()) {
                Assert.fail((String)"Threads didn't join");
                continue;
            }
            if (!this.threads.get((int)i).fail) continue;
            Assert.fail((String)"Elected zero-weight server");
        }
    }

    class LEThread
    extends Thread {
        int i;
        QuorumPeer peer;
        boolean fail;

        LEThread(QuorumPeer peer, int i) {
            this.i = i;
            this.peer = peer;
            LOG.info("Constructor: {}", (Object)this.getName());
        }

        @Override
        public void run() {
            try {
                Vote v = null;
                this.fail = false;
                do {
                    this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                    LOG.info("Going to call leader election.");
                    v = this.peer.getElectionAlg().lookForLeader();
                    if (v == null) {
                        LOG.info("Thread {} got a null vote", (Object)this.i);
                        return;
                    }
                    this.peer.setCurrentVote(v);
                    LOG.info("Finished election: {}, {}", (Object)this.i, (Object)v.getId());
                    FLEZeroWeightTest.this.votes[this.i] = v;
                    if (this.peer.getPeerState() != QuorumPeer.ServerState.LEADING || this.peer.getId() <= 2L) continue;
                    this.fail = true;
                } while (this.peer.getPeerState() != QuorumPeer.ServerState.FOLLOWING && this.peer.getPeerState() != QuorumPeer.ServerState.LEADING);
                LOG.debug("Thread {} votes {}", (Object)this.i, (Object)v);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

