/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.audit;

import io.hops.hadoop.shaded.org.apache.log4j.Appender;
import io.hops.hadoop.shaded.org.apache.log4j.Layout;
import io.hops.hadoop.shaded.org.apache.log4j.Level;
import io.hops.hadoop.shaded.org.apache.log4j.Logger;
import io.hops.hadoop.shaded.org.apache.log4j.Priority;
import io.hops.hadoop.shaded.org.apache.log4j.SimpleLayout;
import io.hops.hadoop.shaded.org.apache.log4j.WriterAppender;
import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.KeeperException;
import io.hops.hadoop.shaded.org.apache.zookeeper.TestableZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.audit.Log4jAuditLogger;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StandaloneServerAuditTest
extends ClientBase {
    private static ByteArrayOutputStream os;

    @BeforeClass
    public static void setup() {
        System.setProperty("zookeeper.audit.enable", "true");
        SimpleLayout layout = new SimpleLayout();
        os = new ByteArrayOutputStream();
        WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)os);
        appender.setImmediateFlush(true);
        appender.setThreshold((Priority)Level.INFO);
        Logger zLogger = Logger.getLogger(Log4jAuditLogger.class);
        zLogger.addAppender((Appender)appender);
    }

    @AfterClass
    public static void teardown() {
        System.clearProperty("zookeeper.audit.enable");
    }

    @Test
    public void testCreateAuditLog() throws KeeperException, InterruptedException, IOException {
        TestableZooKeeper zk = this.createClient();
        String path = "/createPath";
        zk.create(path, "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        List<String> logs = StandaloneServerAuditTest.readAuditLog(os);
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertTrue((boolean)logs.get(0).endsWith("operation=create\tznode=/createPath\tznode_type=persistent\tresult=success"));
    }

    private static List<String> readAuditLog(ByteArrayOutputStream os) throws IOException {
        String line;
        ArrayList<String> logs = new ArrayList<String>();
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        while ((line = r.readLine()) != null) {
            logs.add(line);
        }
        os.reset();
        return logs;
    }
}

