/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.server.util;

import io.hops.hadoop.shaded.org.apache.zookeeper.server.util.CircularBuffer;
import org.junit.Assert;
import org.junit.Test;

public class CircularBufferTest {
    @Test
    public void testCircularBuffer() {
        int capacity = 3;
        CircularBuffer<String> buffer = new CircularBuffer<String>(String.class, 3);
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write("A");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write("B");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write("C");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        Assert.assertEquals((Object)"A", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"B", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"C", (Object)buffer.take());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write("1");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write("2");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write("3");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write("4");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        Assert.assertEquals((Object)"2", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"3", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"4", (Object)buffer.take());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write("a");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write("b");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write("c");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write("d");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write("e");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write("f");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write("g");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        Assert.assertEquals((Object)"e", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"f", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"g", (Object)buffer.take());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
    }

    @Test
    public void testCircularBufferWithCapacity1() {
        boolean capacity = true;
        CircularBuffer<String> buffer = new CircularBuffer<String>(String.class, 1);
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write("A");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write("B");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        Assert.assertEquals((Object)"B", (Object)buffer.take());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
    }

    @Test
    public void testCircularBufferReset() {
        int capacity = 3;
        CircularBuffer<String> buffer = new CircularBuffer<String>(String.class, 3);
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write("A");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((long)1L, (long)buffer.size());
        Assert.assertEquals((Object)"A", (Object)buffer.peek());
        buffer.write("B");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((long)2L, (long)buffer.size());
        Assert.assertEquals((Object)"A", (Object)buffer.peek());
        buffer.reset();
        Assert.assertNull((Object)buffer.peek());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((long)0L, (long)buffer.size());
    }

    @Test
    public void testCircularBufferIllegalCapacity() {
        try {
            CircularBuffer<String> buffer = new CircularBuffer<String>(String.class, 0);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"CircularBuffer capacity should be greater than 0", (Object)e.getMessage());
        }
    }
}

