/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.zookeeper.test;

import io.hops.hadoop.shaded.org.apache.zookeeper.CreateMode;
import io.hops.hadoop.shaded.org.apache.zookeeper.PortAssignment;
import io.hops.hadoop.shaded.org.apache.zookeeper.WatchedEvent;
import io.hops.hadoop.shaded.org.apache.zookeeper.Watcher;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZKTestCase;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooDefs;
import io.hops.hadoop.shaded.org.apache.zookeeper.ZooKeeper;
import io.hops.hadoop.shaded.org.apache.zookeeper.data.Stat;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import io.hops.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.hops.hadoop.shaded.org.apache.zookeeper.test.ClientBase;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryTest
extends ZKTestCase
implements Watcher {
    protected static final Logger LOG = LoggerFactory.getLogger(RecoveryTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private volatile CountDownLatch startSignal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecovery() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        int oldSnapCount = SyncRequestProcessor.getSnapCount();
        SyncRequestProcessor.setSnapCount(1000);
        try {
            String subsubpath;
            int i;
            String path;
            int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
            ServerCnxnFactory f = ServerCnxnFactory.createFactory(PORT, -1);
            f.startup(zks);
            LOG.info("starting up the the server, waiting");
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            this.startSignal = new CountDownLatch(1);
            ZooKeeper zk = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, this);
            this.startSignal.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
            Assert.assertTrue((String)"count == 0", (this.startSignal.getCount() == 0L ? 1 : 0) != 0);
            LOG.info("starting creating nodes");
            for (int i2 = 0; i2 < 10; ++i2) {
                path = "/" + i2;
                zk.create(path, (path + "!").getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                for (int j = 0; j < 10; ++j) {
                    String subpath = path + "/" + j;
                    zk.create(subpath, (subpath + "!").getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    for (int k = 0; k < 20; ++k) {
                        String subsubpath2 = subpath + "/" + k;
                        zk.create(subsubpath2, (subsubpath2 + "!").getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                }
            }
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
            f = ServerCnxnFactory.createFactory(PORT, -1);
            this.startSignal = new CountDownLatch(1);
            f.startup(zks);
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            this.startSignal.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
            Assert.assertTrue((String)"count == 0", (this.startSignal.getCount() == 0L ? 1 : 0) != 0);
            Stat stat = new Stat();
            for (i = 0; i < 10; ++i) {
                path = "/" + i;
                LOG.info("Checking " + path);
                Assert.assertEquals((Object)new String(zk.getData(path, false, stat)), (Object)(path + "!"));
                for (int j = 0; j < 10; ++j) {
                    String subpath = path + "/" + j;
                    Assert.assertEquals((Object)new String(zk.getData(subpath, false, stat)), (Object)(subpath + "!"));
                    for (int k = 0; k < 20; ++k) {
                        subsubpath = subpath + "/" + k;
                        Assert.assertEquals((Object)new String(zk.getData(subsubpath, false, stat)), (Object)(subsubpath + "!"));
                    }
                }
            }
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
            f = ServerCnxnFactory.createFactory(PORT, -1);
            this.startSignal = new CountDownLatch(1);
            f.startup(zks);
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            this.startSignal.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
            Assert.assertTrue((String)"count == 0", (this.startSignal.getCount() == 0L ? 1 : 0) != 0);
            stat = new Stat();
            LOG.info("Check 2");
            for (i = 0; i < 10; ++i) {
                path = "/" + i;
                Assert.assertEquals((Object)new String(zk.getData(path, false, stat)), (Object)(path + "!"));
                for (int j = 0; j < 10; ++j) {
                    String subpath = path + "/" + j;
                    Assert.assertEquals((Object)new String(zk.getData(subpath, false, stat)), (Object)(subpath + "!"));
                    for (int k = 0; k < 20; ++k) {
                        subsubpath = subpath + "/" + k;
                        Assert.assertEquals((Object)new String(zk.getData(subsubpath, false, stat)), (Object)(subsubpath + "!"));
                    }
                }
            }
            zk.close();
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            SyncRequestProcessor.setSnapCount(oldSnapCount);
        }
    }

    @Override
    public void process(WatchedEvent event) {
        LOG.info("Event:{} {} {}", new Object[]{event.getState(), event.getType(), event.getPath()});
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected && this.startSignal != null && this.startSignal.getCount() > 0L) {
            this.startSignal.countDown();
        }
    }
}

